/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableParallelIteratedSingleClassifierEnhancer;
import weka.classifiers.evaluation.Evaluation;
import weka.classifiers.trees.REPTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Aggregateable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class Bagging
extends RandomizableParallelIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler,
PartitionGenerator,
Aggregateable<Bagging> {
    static final long serialVersionUID = -115879962237199703L;
    protected int m_BagSizePercent = 100;
    protected boolean m_CalcOutOfBag = false;
    protected boolean m_RepresentUsingWeights = false;
    protected Evaluation m_OutOfBagEvaluationObject = null;
    private boolean m_StoreOutOfBagPredictions = false;
    private boolean m_OutputOutOfBagComplexityStatistics;
    private boolean m_Numeric = false;
    private boolean m_printClassifiers;
    protected Random m_random;
    protected boolean[][] m_inBag;
    protected Instances m_data;
    protected List<Classifier> m_classifiersCache;

    public Bagging() {
        this.m_Classifier = new REPTree();
    }

    public String globalInfo() {
        return "Class for bagging a classifier to reduce variance. Can do classification and regression depending on the base learner. \n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        result.setValue(TechnicalInformation.Field.YEAR, "1996");
        result.setValue(TechnicalInformation.Field.TITLE, "Bagging predictors");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "24");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "123-140");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.REPTree";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSize of each bag, as a percentage of the\n\ttraining set size. (default 100)", "P", 1, "-P"));
        newVector.addElement(new Option("\tCalculate the out of bag error.", "O", 0, "-O"));
        newVector.addElement(new Option("\tWhether to store out of bag predictions in internal evaluation object.", "store-out-of-bag-predictions", 0, "-store-out-of-bag-predictions"));
        newVector.addElement(new Option("\tWhether to output complexity-based statistics when out-of-bag evaluation is performed.", "output-out-of-bag-complexity-statistics", 0, "-output-out-of-bag-complexity-statistics"));
        newVector.addElement(new Option("\tRepresent copies of instances using weights rather than explicitly.", "represent-copies-using-weights", 0, "-represent-copies-using-weights"));
        newVector.addElement(new Option("\tPrint the individual classifiers in the output", "print", 0, "-print"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String bagSize = Utils.getOption('P', options);
        if (bagSize.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(bagSize));
        } else {
            this.setBagSizePercent(100);
        }
        this.setCalcOutOfBag(Utils.getFlag('O', options));
        this.setStoreOutOfBagPredictions(Utils.getFlag("store-out-of-bag-predictions", options));
        this.setOutputOutOfBagComplexityStatistics(Utils.getFlag("output-out-of-bag-complexity-statistics", options));
        this.setRepresentCopiesUsingWeights(Utils.getFlag("represent-copies-using-weights", options));
        this.setPrintClassifiers(Utils.getFlag("print", options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-P");
        options.add("" + this.getBagSizePercent());
        if (this.getCalcOutOfBag()) {
            options.add("-O");
        }
        if (this.getStoreOutOfBagPredictions()) {
            options.add("-store-out-of-bag-predictions");
        }
        if (this.getOutputOutOfBagComplexityStatistics()) {
            options.add("-output-out-of-bag-complexity-statistics");
        }
        if (this.getRepresentCopiesUsingWeights()) {
            options.add("-represent-copies-using-weights");
        }
        if (this.getPrintClassifiers()) {
            options.add("-print");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String bagSizePercentTipText() {
        return "Size of each bag, as a percentage of the training set size.";
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int newBagSizePercent) {
        this.m_BagSizePercent = newBagSizePercent;
    }

    public String representCopiesUsingWeightsTipText() {
        return "Whether to represent copies of instances using weights rather than explicitly.";
    }

    public void setRepresentCopiesUsingWeights(boolean representUsingWeights) {
        this.m_RepresentUsingWeights = representUsingWeights;
    }

    public boolean getRepresentCopiesUsingWeights() {
        return this.m_RepresentUsingWeights;
    }

    public String storeOutOfBagPredictionsTipText() {
        return "Whether to store the out-of-bag predictions.";
    }

    public void setStoreOutOfBagPredictions(boolean storeOutOfBag) {
        this.m_StoreOutOfBagPredictions = storeOutOfBag;
    }

    public boolean getStoreOutOfBagPredictions() {
        return this.m_StoreOutOfBagPredictions;
    }

    public String calcOutOfBagTipText() {
        return "Whether the out-of-bag error is calculated.";
    }

    public void setCalcOutOfBag(boolean calcOutOfBag) {
        this.m_CalcOutOfBag = calcOutOfBag;
    }

    public boolean getCalcOutOfBag() {
        return this.m_CalcOutOfBag;
    }

    public String outputOutOfBagComplexityStatisticsTipText() {
        return "Whether to output complexity-based statistics when out-of-bag evaluation is performed.";
    }

    public boolean getOutputOutOfBagComplexityStatistics() {
        return this.m_OutputOutOfBagComplexityStatistics;
    }

    public void setOutputOutOfBagComplexityStatistics(boolean b) {
        this.m_OutputOutOfBagComplexityStatistics = b;
    }

    public String printClassifiersTipText() {
        return "Print the individual classifiers in the output";
    }

    public void setPrintClassifiers(boolean print) {
        this.m_printClassifiers = print;
    }

    public boolean getPrintClassifiers() {
        return this.m_printClassifiers;
    }

    public double measureOutOfBagError() {
        if (this.m_OutOfBagEvaluationObject == null) {
            return -1.0;
        }
        if (this.m_Numeric) {
            return this.m_OutOfBagEvaluationObject.meanAbsoluteError();
        }
        return this.m_OutOfBagEvaluationObject.errorRate();
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureOutOfBagError");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (Bagging)");
    }

    @Override
    protected synchronized Instances getTrainingSet(int iteration) throws Exception {
        int bagSize = (int)((double)this.m_data.numInstances() * ((double)this.m_BagSizePercent / 100.0));
        Instances bagData = null;
        Random r = new Random(this.m_Seed + iteration);
        if (this.m_CalcOutOfBag) {
            this.m_inBag[iteration] = new boolean[this.m_data.numInstances()];
            bagData = this.m_data.resampleWithWeights(r, this.m_inBag[iteration], this.getRepresentCopiesUsingWeights());
        } else if (bagSize < this.m_data.numInstances()) {
            Instances newBagData;
            bagData = this.m_data.resampleWithWeights(r, false);
            bagData.randomize(r);
            bagData = newBagData = new Instances(bagData, 0, bagSize);
        } else {
            bagData = this.m_data.resampleWithWeights(r, this.getRepresentCopiesUsingWeights());
        }
        return bagData;
    }

    public Evaluation getOutOfBagEvaluationObject() {
        return this.m_OutOfBagEvaluationObject;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        if (this.getRepresentCopiesUsingWeights() && !(this.m_Classifier instanceof WeightedInstancesHandler)) {
            throw new IllegalArgumentException("Cannot represent copies using weights when base learner in bagging does not implement WeightedInstancesHandler.");
        }
        this.m_data = new Instances(data);
        super.buildClassifier(this.m_data);
        if (this.m_CalcOutOfBag && this.m_BagSizePercent != 100) {
            throw new IllegalArgumentException("Bag size needs to be 100% if out-of-bag error is to be calculated!");
        }
        this.m_random = new Random(this.m_Seed);
        this.m_inBag = null;
        if (this.m_CalcOutOfBag) {
            this.m_inBag = new boolean[this.m_Classifiers.length][];
        }
        for (int j = 0; j < this.m_Classifiers.length; ++j) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            if (!(this.m_Classifier instanceof Randomizable)) continue;
            ((Randomizable)((Object)this.m_Classifiers[j])).setSeed(this.m_random.nextInt());
        }
        this.m_Numeric = this.m_data.classAttribute().isNumeric();
        this.buildClassifiers();
        if (this.getCalcOutOfBag()) {
            this.m_OutOfBagEvaluationObject = new Evaluation(this.m_data);
            for (int i = 0; i < this.m_data.numInstances(); ++i) {
                double[] votes = this.m_Numeric ? new double[1] : new double[this.m_data.numClasses()];
                int voteCount = 0;
                for (int j = 0; j < this.m_Classifiers.length; ++j) {
                    if (this.m_inBag[j][i]) continue;
                    if (this.m_Numeric) {
                        double pred = this.m_Classifiers[j].classifyInstance(this.m_data.instance(i));
                        if (Utils.isMissingValue(pred)) continue;
                        votes[0] = votes[0] + pred;
                        ++voteCount;
                        continue;
                    }
                    ++voteCount;
                    double[] newProbs = this.m_Classifiers[j].distributionForInstance(this.m_data.instance(i));
                    for (int k = 0; k < newProbs.length; ++k) {
                        int n = k;
                        votes[n] = votes[n] + newProbs[k];
                    }
                }
                if (this.m_Numeric) {
                    if (voteCount <= 0) continue;
                    votes[0] = votes[0] / (double)voteCount;
                    this.m_OutOfBagEvaluationObject.evaluationForSingleInstance(votes, this.m_data.instance(i), this.getStoreOutOfBagPredictions());
                    continue;
                }
                double sum = Utils.sum(votes);
                if (!(sum > 0.0)) continue;
                Utils.normalize(votes, sum);
                this.m_OutOfBagEvaluationObject.evaluationForSingleInstance(votes, this.m_data.instance(i), this.getStoreOutOfBagPredictions());
            }
        } else {
            this.m_OutOfBagEvaluationObject = null;
        }
        this.m_inBag = null;
        this.m_data = new Instances(this.m_data, 0);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] sums = new double[instance.numClasses()];
        double numPreds = 0.0;
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            if (this.m_Numeric) {
                double pred = this.m_Classifiers[i].classifyInstance(instance);
                if (Utils.isMissingValue(pred)) continue;
                sums[0] = sums[0] + pred;
                numPreds += 1.0;
                continue;
            }
            double[] newProbs = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < newProbs.length; ++j) {
                int n = j;
                sums[n] = sums[n] + newProbs[j];
            }
        }
        if (this.m_Numeric) {
            sums[0] = numPreds == 0.0 ? Utils.missingValue() : sums[0] / numPreds;
            return sums;
        }
        if (Utils.eq(Utils.sum(sums), 0.0)) {
            return sums;
        }
        Utils.normalize(sums);
        return sums;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Bagging: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("Bagging with " + this.getNumIterations() + " iterations and base learner\n\n" + this.getClassifierSpec());
        if (this.getPrintClassifiers()) {
            text.append("All the base classifiers: \n\n");
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                text.append(this.m_Classifiers[i].toString() + "\n\n");
            }
        }
        if (this.m_CalcOutOfBag) {
            text.append(this.m_OutOfBagEvaluationObject.toSummaryString("\n\n*** Out-of-bag estimates ***\n", this.getOutputOutOfBagComplexityStatistics()));
        }
        return text.toString();
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof PartitionGenerator)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
        }
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            ArrayList<double[]> al = new ArrayList<double[]>();
            int size = 0;
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                double[] r = ((PartitionGenerator)((Object)this.m_Classifiers[i])).getMembershipValues(inst);
                size += r.length;
                al.add(r);
            }
            double[] values = new double[size];
            int pos = 0;
            for (double[] v : al) {
                System.arraycopy(v, 0, values, pos, v.length);
                pos += v.length;
            }
            return values;
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public int numElements() throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            int size = 0;
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                size += ((PartitionGenerator)((Object)this.m_Classifiers[i])).numElements();
            }
            return size;
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        Bagging.runClassifier(new Bagging(), argv);
    }

    @Override
    public Bagging aggregate(Bagging toAggregate) throws Exception {
        if (!this.m_Classifier.getClass().isAssignableFrom(toAggregate.m_Classifier.getClass())) {
            throw new Exception("Can't aggregate because base classifiers differ");
        }
        if (this.m_classifiersCache == null) {
            this.m_classifiersCache = new ArrayList<Classifier>();
            this.m_classifiersCache.addAll(Arrays.asList(this.m_Classifiers));
        }
        this.m_classifiersCache.addAll(Arrays.asList(toAggregate.m_Classifiers));
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
        this.m_Classifiers = this.m_classifiersCache.toArray(new Classifier[1]);
        this.m_NumIterations = this.m_Classifiers.length;
        this.m_classifiersCache = null;
    }
}

