/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.classifiers.misc.InputMappedClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Vote
extends RandomizableMultipleClassifiersCombiner
implements TechnicalInformationHandler,
EnvironmentHandler,
Aggregateable<Classifier> {
    static final long serialVersionUID = -637891196294399624L;
    public static final int AVERAGE_RULE = 1;
    public static final int PRODUCT_RULE = 2;
    public static final int MAJORITY_VOTING_RULE = 3;
    public static final int MIN_RULE = 4;
    public static final int MAX_RULE = 5;
    public static final int MEDIAN_RULE = 6;
    public static final Tag[] TAGS_RULES = new Tag[]{new Tag(1, "AVG", "Average of Probabilities"), new Tag(2, "PROD", "Product of Probabilities"), new Tag(3, "MAJ", "Majority Voting"), new Tag(4, "MIN", "Minimum Probability"), new Tag(5, "MAX", "Maximum Probability"), new Tag(6, "MED", "Median")};
    protected int m_CombinationRule = 1;
    protected List<String> m_classifiersToLoad = new ArrayList<String>();
    protected List<Classifier> m_preBuiltClassifiers = new ArrayList<Classifier>();
    protected transient Environment m_env = Environment.getSystemWide();
    protected Instances m_structure;
    protected boolean m_dontPrintModels;

    public String globalInfo() {
        return "Class for combining classifiers. Different combinations of probability estimates for classification are available.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull path to serialized classifier to include.\n\tMay be specified multiple times to include\n\tmultiple serialized classifiers. Note: it does\n\tnot make sense to use pre-built classifiers in\n\ta cross-validation.", "P", 1, "-P <path to serialized classifier>"));
        result.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "R", 1, "-R " + Tag.toOptionList(TAGS_RULES)));
        result.addElement(new Option("\tSuppress the printing of the individual models in the output", "do-not-print", 0, "-do-not-print"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-R");
        result.add("" + this.getCombinationRule());
        for (i = 0; i < this.m_classifiersToLoad.size(); ++i) {
            result.add("-P");
            result.add(this.m_classifiersToLoad.get(i));
        }
        if (this.m_dontPrintModels) {
            result.add("-do-not-print");
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String loadString;
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setCombinationRule(new SelectedTag(tmpStr, TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, TAGS_RULES));
        }
        this.m_classifiersToLoad.clear();
        while ((loadString = Utils.getOption('P', options)).length() != 0) {
            this.m_classifiersToLoad.add(loadString);
        }
        this.setDoNotPrintModels(Utils.getFlag("do-not-print", options));
        super.setOptions(options);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ludmila I. Kuncheva");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining Pattern Classifiers: Methods and Algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons, Inc.");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "J. Kittler and M. Hatef and Robert P.W. Duin and J. Matas");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "On combining classifiers");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        additional.setValue(TechnicalInformation.Field.VOLUME, "20");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "226-239");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        if (this.m_preBuiltClassifiers.size() == 0 && this.m_classifiersToLoad.size() > 0) {
            try {
                this.loadClassifiers(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_preBuiltClassifiers.size() > 0) {
            if (this.m_Classifiers.length == 0) {
                result = (Capabilities)this.m_preBuiltClassifiers.get(0).getCapabilities().clone();
            }
            for (int i = 1; i < this.m_preBuiltClassifiers.size(); ++i) {
                result.and(this.m_preBuiltClassifiers.get(i).getCapabilities());
            }
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                result.enableDependency(cap);
            }
        }
        if (this.m_CombinationRule == 2 || this.m_CombinationRule == 3) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        } else if (this.m_CombinationRule == 6) {
            result.disableAllClasses();
            result.disableAllClassDependencies();
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enableDependency(Capabilities.Capability.NUMERIC_CLASS);
        }
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        this.m_structure = new Instances(newData, 0);
        if (this.m_classifiersToLoad.size() > 0) {
            this.m_preBuiltClassifiers.clear();
            this.loadClassifiers(data);
            if (this.m_Classifiers.length == 1 && this.m_Classifiers[0] instanceof ZeroR) {
                this.m_Classifiers = new Classifier[0];
            }
        }
        this.getCapabilities().testWithFail(data);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            this.getClassifier(i).buildClassifier(newData);
        }
    }

    private void loadClassifiers(Instances data) throws Exception {
        for (String path : this.m_classifiersToLoad) {
            File toLoad;
            if (Environment.containsEnvVariables(path)) {
                try {
                    path = this.m_env.substitute(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(toLoad = new File(path)).isFile()) {
                throw new Exception("\"" + path + "\" does not seem to be a valid file!");
            }
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(toLoad)));
            Object c = is.readObject();
            if (!(c instanceof Classifier)) {
                is.close();
                throw new Exception("\"" + path + "\" does not contain a classifier!");
            }
            Object header = null;
            header = is.readObject();
            if (header instanceof Instances && !(c instanceof InputMappedClassifier) && data != null && !data.equalHeaders((Instances)header)) {
                is.close();
                throw new Exception("\"" + path + "\" was trained with data that is of a differnet structure than the incoming training data");
            }
            if (header == null) {
                System.out.println("[Vote] warning: no header instances for \"" + path + "\"");
            }
            is.close();
            this.addPreBuiltClassifier((Classifier)c);
        }
    }

    public void addPreBuiltClassifier(Classifier c) {
        this.m_preBuiltClassifiers.add(c);
    }

    public void removePreBuiltClassifier(Classifier c) {
        this.m_preBuiltClassifiers.remove(c);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double result;
        switch (this.m_CombinationRule) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                double[] dist = this.distributionForInstance(instance);
                if (instance.classAttribute().isNominal()) {
                    int index = Utils.maxIndex(dist);
                    if (dist[index] == 0.0) {
                        result = Utils.missingValue();
                        break;
                    }
                    result = index;
                    break;
                }
                if (instance.classAttribute().isNumeric()) {
                    result = dist[0];
                    break;
                }
                result = Utils.missingValue();
                break;
            }
            case 6: {
                result = this.classifyInstanceMedian(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        return result;
    }

    protected double classifyInstanceMedian(Instance instance) throws Exception {
        double[] results = new double[this.m_Classifiers.length + this.m_preBuiltClassifiers.size()];
        int numResults = 0;
        for (Classifier m_Classifier : this.m_Classifiers) {
            double pred = m_Classifier.classifyInstance(instance);
            if (Utils.isMissingValue(pred)) continue;
            results[numResults++] = pred;
        }
        for (int i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            double pred = this.m_preBuiltClassifiers.get(i).classifyInstance(instance);
            if (Utils.isMissingValue(pred)) continue;
            results[numResults++] = pred;
        }
        if (numResults == 0) {
            return Utils.missingValue();
        }
        if (numResults == 1) {
            return results[0];
        }
        double[] actualResults = new double[numResults];
        System.arraycopy(results, 0, actualResults, 0, numResults);
        return Utils.kthSmallestValue(actualResults, actualResults.length / 2);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = new double[instance.numClasses()];
        switch (this.m_CombinationRule) {
            case 1: {
                result = this.distributionForInstanceAverage(instance);
                break;
            }
            case 2: {
                result = this.distributionForInstanceProduct(instance);
                break;
            }
            case 3: {
                result = this.distributionForInstanceMajorityVoting(instance);
                break;
            }
            case 4: {
                result = this.distributionForInstanceMin(instance);
                break;
            }
            case 5: {
                result = this.distributionForInstanceMax(instance);
                break;
            }
            case 6: {
                result[0] = this.classifyInstance(instance);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        if (!instance.classAttribute().isNumeric() && Utils.sum(result) > 0.0) {
            Utils.normalize(result);
        }
        return result;
    }

    protected double[] distributionForInstanceAverage(Instance instance) throws Exception {
        int j;
        double[] dist;
        int i;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] + dist[j];
            }
            numPredictions += 1.0;
        }
        for (i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] + dist[j];
            }
            numPredictions += 1.0;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            } else {
                int j2 = 0;
                while (j2 < probs.length) {
                    int n = j2++;
                    probs[n] = probs[n] / numPredictions;
                }
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceProduct(Instance instance) throws Exception {
        int j;
        double[] dist;
        int i;
        double[] probs = new double[instance.numClasses()];
        for (int i2 = 0; i2 < probs.length; ++i2) {
            probs[i2] = 1.0;
        }
        int numPredictions = 0;
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (!(Utils.sum(dist) > 0.0)) continue;
            for (j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] * dist[j];
            }
            ++numPredictions;
        }
        for (i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (!(Utils.sum(dist) > 0.0)) continue;
            for (j = 0; j < dist.length; ++j) {
                int n = j;
                probs[n] = probs[n] * dist[j];
            }
            ++numPredictions;
        }
        if (numPredictions == 0) {
            return new double[instance.numClasses()];
        }
        if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceMajorityVoting(Instance instance) throws Exception {
        int j;
        int maxIndex;
        int i;
        double[] probs = new double[instance.classAttribute().numValues()];
        double[] votes = new double[probs.length];
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            probs = this.getClassifier(i).distributionForInstance(instance);
            maxIndex = 0;
            for (j = 0; j < probs.length; ++j) {
                if (!(probs[j] > probs[maxIndex])) continue;
                maxIndex = j;
            }
            if (!(probs[maxIndex] > 0.0)) continue;
            for (j = 0; j < probs.length; ++j) {
                if (probs[j] != probs[maxIndex]) continue;
                int n = j;
                votes[n] = votes[n] + 1.0;
            }
        }
        for (i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            probs = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            maxIndex = 0;
            for (j = 0; j < probs.length; ++j) {
                if (!(probs[j] > probs[maxIndex])) continue;
                maxIndex = j;
            }
            if (!(probs[maxIndex] > 0.0)) continue;
            for (j = 0; j < probs.length; ++j) {
                if (probs[j] != probs[maxIndex]) continue;
                int n = j;
                votes[n] = votes[n] + 1.0;
            }
        }
        int tmpMajorityIndex = 0;
        for (int k = 1; k < votes.length; ++k) {
            if (!(votes[k] > votes[tmpMajorityIndex])) continue;
            tmpMajorityIndex = k;
        }
        if (votes[tmpMajorityIndex] == 0.0) {
            return new double[instance.numClasses()];
        }
        Vector<Integer> majorityIndexes = new Vector<Integer>();
        for (int k = 0; k < votes.length; ++k) {
            if (votes[k] != votes[tmpMajorityIndex]) continue;
            majorityIndexes.add(k);
        }
        int majorityIndex = tmpMajorityIndex;
        if (majorityIndexes.size() > 1) {
            double[] distPreds = this.distributionForInstanceAverage(instance);
            majorityIndex = Utils.maxIndex(distPreds);
        }
        probs = new double[probs.length];
        probs[majorityIndex] = 1.0;
        return probs;
    }

    protected double[] distributionForInstanceMax(Instance instance) throws Exception {
        int j;
        double[] dist;
        int i;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                if (!(probs[j] < dist[j]) && numPredictions != 0.0) continue;
                probs[j] = dist[j];
            }
            numPredictions += 1.0;
        }
        for (i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                if (!(probs[j] < dist[j]) && numPredictions != 0.0) continue;
                probs[j] = dist[j];
            }
            numPredictions += 1.0;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    protected double[] distributionForInstanceMin(Instance instance) throws Exception {
        int j;
        double[] dist;
        int i;
        double[] probs = new double[instance.numClasses()];
        double numPredictions = 0.0;
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.getClassifier(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                if (!(probs[j] > dist[j]) && numPredictions != 0.0) continue;
                probs[j] = dist[j];
            }
            numPredictions += 1.0;
        }
        for (i = 0; i < this.m_preBuiltClassifiers.size(); ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            dist = this.m_preBuiltClassifiers.get(i).distributionForInstance(instance);
            if (instance.classAttribute().isNumeric() && Utils.isMissingValue(dist[0])) continue;
            for (j = 0; j < dist.length; ++j) {
                if (!(probs[j] > dist[j]) && numPredictions != 0.0) continue;
                probs[j] = dist[j];
            }
            numPredictions += 1.0;
        }
        if (instance.classAttribute().isNumeric()) {
            if (numPredictions == 0.0) {
                probs[0] = Utils.missingValue();
            }
        } else if (Utils.sum(probs) > 0.0) {
            Utils.normalize(probs);
        }
        return probs;
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, TAGS_RULES);
    }

    public void setCombinationRule(SelectedTag newRule) {
        if (newRule.getTags() == TAGS_RULES) {
            this.m_CombinationRule = newRule.getSelectedTag().getID();
        }
    }

    public String preBuiltClassifiersTipText() {
        return "The pre-built serialized classifiers to include. Multiple serialized classifiers can be included alongside those that are built from scratch when this classifier runs. Note that it does not make sense to include pre-built classifiers in a cross-validation since they are static and their models do not change from fold to fold.";
    }

    public void setPreBuiltClassifiers(File[] preBuilt) {
        this.m_classifiersToLoad.clear();
        if (preBuilt != null && preBuilt.length > 0) {
            for (File element : preBuilt) {
                String path = element.toString();
                this.m_classifiersToLoad.add(path);
            }
        }
    }

    public File[] getPreBuiltClassifiers() {
        File[] result = new File[this.m_classifiersToLoad.size()];
        for (int i = 0; i < this.m_classifiersToLoad.size(); ++i) {
            result[i] = new File(this.m_classifiersToLoad.get(i));
        }
        return result;
    }

    public String doNotPrintModelsTipText() {
        return "Do not print the individual trees in the output";
    }

    public void setDoNotPrintModels(boolean print) {
        this.m_dontPrintModels = print;
    }

    public boolean getDoNotPrintModels() {
        return this.m_dontPrintModels;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Vote: No model built yet.";
        }
        String result = "Vote combines";
        result = result + " the probability distributions of these base learners:\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            result = result + '\t' + this.getClassifierSpec(i) + '\n';
        }
        for (Classifier c : this.m_preBuiltClassifiers) {
            result = result + "\t" + c.getClass().getName() + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions()) + "\n";
        }
        result = result + "using the '";
        switch (this.m_CombinationRule) {
            case 1: {
                result = result + "Average";
                break;
            }
            case 2: {
                result = result + "Product";
                break;
            }
            case 3: {
                result = result + "Majority Voting";
                break;
            }
            case 4: {
                result = result + "Minimum";
                break;
            }
            case 5: {
                result = result + "Maximum";
                break;
            }
            case 6: {
                result = result + "Median";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown combination rule '" + this.m_CombinationRule + "'!");
            }
        }
        result = result + "' combination rule \n";
        StringBuilder resultBuilder = null;
        if (!this.m_dontPrintModels) {
            resultBuilder = new StringBuilder();
            resultBuilder.append(result).append("\nAll the models:\n\n");
            for (Classifier c : this.m_Classifiers) {
                resultBuilder.append(c).append("\n");
            }
            for (Classifier c : this.m_preBuiltClassifiers) {
                resultBuilder.append(c).append("\n");
            }
        }
        return resultBuilder == null ? result : resultBuilder.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public Classifier aggregate(Classifier toAggregate) throws Exception {
        if (this.m_structure == null && this.m_Classifiers.length == 1 && this.m_Classifiers[0] instanceof ZeroR) {
            this.setClassifiers(new Classifier[0]);
        }
        this.addPreBuiltClassifier(toAggregate);
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
    }

    public static void main(String[] argv) {
        Vote.runClassifier(new Vote(), argv);
    }
}

