/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import weka.classifiers.rules.part.ClassifierDecList;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48.Stats;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class C45PruneableDecList
extends ClassifierDecList {
    private static final long serialVersionUID = -2757684345218324559L;
    private double CF = 0.25;

    public C45PruneableDecList(ModelSelection toSelectLocModel, double cf, int minNum) throws Exception {
        super(toSelectLocModel, minNum);
        this.CF = cf;
    }

    @Override
    public void buildDecList(Instances data, boolean leaf) throws Exception {
        this.m_train = null;
        this.m_test = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.indeX = 0;
        double sumOfWeights = data.sumOfWeights();
        NoSplit noSplit = new NoSplit(new Distribution(data));
        this.m_localModel = leaf ? noSplit : this.m_toSelectModel.selectModel(data);
        if (this.m_localModel.numSubsets() > 1) {
            int j;
            int ind;
            Instances[] localInstances = this.m_localModel.split(data);
            data = null;
            this.m_sons = new ClassifierDecList[this.m_localModel.numSubsets()];
            int i = 0;
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
                }
                ++i;
                ind = this.chooseIndex();
                if (ind == -1) {
                    for (j = 0; j < this.m_sons.length; ++j) {
                        if (this.m_sons[j] != null) continue;
                        this.m_sons[j] = this.getNewDecList(localInstances[j], true);
                    }
                    if (i < 2) {
                        this.m_localModel = noSplit;
                        this.m_isLeaf = true;
                        this.m_sons = null;
                        if (Utils.eq(sumOfWeights, 0.0)) {
                            this.m_isEmpty = true;
                        }
                        return;
                    }
                    ind = 0;
                    break;
                }
                this.m_sons[ind] = this.getNewDecList(localInstances[ind], false);
            } while (i < this.m_sons.length && this.m_sons[ind].m_isLeaf);
            for (j = 0; j < this.m_sons.length && this.m_sons[j] != null && this.m_sons[j].m_isLeaf; ++j) {
            }
            if (j == this.m_sons.length) {
                this.pruneEnd();
                if (!this.m_isLeaf) {
                    this.indeX = this.chooseLastIndex();
                }
            } else {
                this.indeX = this.chooseLastIndex();
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(sumOfWeights, 0.0)) {
                this.m_isEmpty = true;
            }
        }
    }

    @Override
    protected ClassifierDecList getNewDecList(Instances data, boolean leaf) throws Exception {
        C45PruneableDecList newDecList = new C45PruneableDecList(this.m_toSelectModel, this.CF, this.m_minNumObj);
        newDecList.buildDecList(data, leaf);
        return newDecList;
    }

    protected void pruneEnd() {
        double errorsTree = this.getEstimatedErrorsForTree();
        double errorsLeaf = this.getEstimatedErrorsForLeaf();
        if (Utils.smOrEq(errorsLeaf, errorsTree + 0.1)) {
            this.m_isLeaf = true;
            this.m_sons = null;
            this.m_localModel = new NoSplit(this.localModel().distribution());
        }
    }

    private double getEstimatedErrorsForTree() {
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForLeaf();
        }
        double error = 0.0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            if (Utils.eq(this.son(i).localModel().distribution().total(), 0.0)) continue;
            error += ((C45PruneableDecList)this.son(i)).getEstimatedErrorsForTree();
        }
        return error;
    }

    public double getEstimatedErrorsForLeaf() {
        double errors = this.localModel().distribution().numIncorrect();
        return errors + Stats.addErrs(this.localModel().distribution().total(), errors, (float)this.CF);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

