/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class REPTree
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Drawable,
AdditionalMeasureProducer,
Sourcable,
PartitionGenerator,
Randomizable {
    static final long serialVersionUID = -9216785998198681299L;
    protected ZeroR m_zeroR;
    protected Tree m_Tree = null;
    protected int m_NumFolds = 3;
    protected int m_Seed = 1;
    protected boolean m_NoPruning = false;
    protected double m_MinNum = 2.0;
    protected double m_MinVarianceProp = 0.001;
    protected int m_MaxDepth = -1;
    protected double m_InitialCount = 0.0;
    protected boolean m_SpreadInitialCount = false;
    private static long PRINTED_NODES = 0L;

    public String globalInfo() {
        return "Fast decision tree learner. Builds a decision/regression tree using information gain/variance and prunes it using reduced-error pruning (with backfitting).  Only sorts values for numeric attributes once. Missing values are dealt with by splitting the corresponding instances into pieces (i.e. as in C4.5).";
    }

    public String noPruningTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getNoPruning() {
        return this.m_NoPruning;
    }

    public void setNoPruning(boolean newNoPruning) {
        this.m_NoPruning = newNoPruning;
    }

    public String minNumTipText() {
        return "The minimum total weight of the instances in a leaf.";
    }

    public double getMinNum() {
        return this.m_MinNum;
    }

    public void setMinNum(double newMinNum) {
        this.m_MinNum = newMinNum;
    }

    public String minVariancePropTipText() {
        return "The minimum proportion of the variance on all the data that needs to be present at a node in order for splitting to be performed in regression trees.";
    }

    public double getMinVarianceProp() {
        return this.m_MinVarianceProp;
    }

    public void setMinVarianceProp(double newMinVarianceProp) {
        this.m_MinVarianceProp = newMinVarianceProp;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int newNumFolds) {
        this.m_NumFolds = newNumFolds;
    }

    public String maxDepthTipText() {
        return "The maximum tree depth (-1 for no restriction).";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int newMaxDepth) {
        this.m_MaxDepth = newMaxDepth;
    }

    public String initialCountTipText() {
        return "Initial class value count.";
    }

    public double getInitialCount() {
        return this.m_InitialCount;
    }

    public void setInitialCount(double newInitialCount) {
        this.m_InitialCount = newInitialCount;
    }

    public String spreadInitialCountTipText() {
        return "Spread initial count across all values instead of using the count per value.";
    }

    public boolean getSpreadInitialCount() {
        return this.m_SpreadInitialCount;
    }

    public void setSpreadInitialCount(boolean newSpreadInitialCount) {
        this.m_SpreadInitialCount = newSpreadInitialCount;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tSet minimum number of instances per leaf (default 2).", "M", 1, "-M <minimum number of instances>"));
        newVector.addElement(new Option("\tSet minimum numeric class variance proportion\n\tof train variance for split (default 1e-3).", "V", 1, "-V <minimum variance for split>"));
        newVector.addElement(new Option("\tNumber of folds for reduced error pruning (default 3).", "N", 1, "-N <number of folds>"));
        newVector.addElement(new Option("\tSeed for random data shuffling (default 1).", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tNo pruning.", "P", 0, "-P"));
        newVector.addElement(new Option("\tMaximum tree depth (default -1, no maximum)", "L", 1, "-L"));
        newVector.addElement(new Option("\tInitial class value count (default 0)", "I", 1, "-I"));
        newVector.addElement(new Option("\tSpread initial count over all class values (i.e. don't use 1 per value)", "R", 0, "-R"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-M");
        options.add("" + (int)this.getMinNum());
        options.add("-V");
        options.add("" + this.getMinVarianceProp());
        options.add("-N");
        options.add("" + this.getNumFolds());
        options.add("-S");
        options.add("" + this.getSeed());
        options.add("-L");
        options.add("" + this.getMaxDepth());
        if (this.getNoPruning()) {
            options.add("-P");
        }
        options.add("-I");
        options.add("" + this.getInitialCount());
        if (this.getSpreadInitialCount()) {
            options.add("-R");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String minNumString = Utils.getOption('M', options);
        this.m_MinNum = minNumString.length() != 0 ? (double)Integer.parseInt(minNumString) : 2.0;
        String minVarString = Utils.getOption('V', options);
        this.m_MinVarianceProp = minVarString.length() != 0 ? Double.parseDouble(minVarString) : 0.001;
        String numFoldsString = Utils.getOption('N', options);
        this.m_NumFolds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? Integer.parseInt(seedString) : 1;
        this.m_NoPruning = Utils.getFlag('P', options);
        String depthString = Utils.getOption('L', options);
        this.m_MaxDepth = depthString.length() != 0 ? Integer.parseInt(depthString) : -1;
        String initialCountString = Utils.getOption('I', options);
        this.m_InitialCount = initialCountString.length() != 0 ? Double.parseDouble(initialCountString) : 0.0;
        this.m_SpreadInitialCount = Utils.getFlag('R', options);
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    public int numNodes() {
        return this.m_Tree.numNodes();
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureTreeSize");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureTreeSize")) {
            return this.numNodes();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (REPTree)");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        Random random = new Random(this.m_Seed);
        this.m_zeroR = null;
        if (data.numAttributes() == 1) {
            this.m_zeroR = new ZeroR();
            this.m_zeroR.buildClassifier(data);
            return;
        }
        data.randomize(random);
        if (data.classAttribute().isNominal()) {
            data.stratify(this.m_NumFolds);
        }
        Instances train = null;
        Instances prune = null;
        if (!this.m_NoPruning) {
            train = data.trainCV(this.m_NumFolds, 0, random);
            prune = data.testCV(this.m_NumFolds, 0);
        } else {
            train = data;
        }
        int[][][] sortedIndices = new int[1][train.numAttributes()][0];
        double[][][] weights = new double[1][train.numAttributes()][0];
        double[] vals = new double[train.numInstances()];
        for (int j = 0; j < train.numAttributes(); ++j) {
            int i;
            if (Thread.interrupted()) {
                throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
            }
            if (j == train.classIndex()) continue;
            weights[0][j] = new double[train.numInstances()];
            if (train.attribute(j).isNominal()) {
                Instance inst;
                int i2;
                sortedIndices[0][j] = new int[train.numInstances()];
                int count = 0;
                for (i2 = 0; i2 < train.numInstances(); ++i2) {
                    inst = train.instance(i2);
                    if (inst.isMissing(j)) continue;
                    sortedIndices[0][j][count] = i2;
                    weights[0][j][count] = inst.weight();
                    ++count;
                }
                for (i2 = 0; i2 < train.numInstances(); ++i2) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
                    }
                    inst = train.instance(i2);
                    if (!inst.isMissing(j)) continue;
                    sortedIndices[0][j][count] = i2;
                    weights[0][j][count] = inst.weight();
                    ++count;
                }
                continue;
            }
            for (i = 0; i < train.numInstances(); ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Thread got interrupted, thus, kill WEKA.");
                }
                Instance inst = train.instance(i);
                vals[i] = inst.value(j);
            }
            sortedIndices[0][j] = Utils.sort(vals);
            for (i = 0; i < train.numInstances(); ++i) {
                weights[0][j][i] = train.instance(sortedIndices[0][j][i]).weight();
            }
        }
        double[] classProbs = new double[train.numClasses()];
        double totalWeight = 0.0;
        double totalSumSquared = 0.0;
        for (int i = 0; i < train.numInstances(); ++i) {
            Instance inst = train.instance(i);
            if (data.classAttribute().isNominal()) {
                int n = (int)inst.classValue();
                classProbs[n] = classProbs[n] + inst.weight();
                totalWeight += inst.weight();
                continue;
            }
            classProbs[0] = classProbs[0] + inst.classValue() * inst.weight();
            totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
            totalWeight += inst.weight();
        }
        this.m_Tree = new Tree();
        double trainVariance = 0.0;
        if (data.classAttribute().isNumeric()) {
            trainVariance = this.m_Tree.singleVariance(classProbs[0], totalSumSquared, totalWeight) / totalWeight;
            classProbs[0] = classProbs[0] / totalWeight;
        }
        this.m_Tree.buildTree(sortedIndices, weights, train, totalWeight, classProbs, new Instances(train, 0), this.m_MinNum, this.m_MinVarianceProp * trainVariance, 0, this.m_MaxDepth);
        if (!this.m_NoPruning) {
            this.m_Tree.insertHoldOutSet(prune);
            this.m_Tree.reducedErrorPrune();
            this.m_Tree.backfitHoldOutSet();
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_zeroR != null) {
            return this.m_zeroR.distributionForInstance(instance);
        }
        return this.m_Tree.distributionForInstance(instance);
    }

    protected static long nextID() {
        return PRINTED_NODES++;
    }

    protected static void resetID() {
        PRINTED_NODES = 0L;
    }

    @Override
    public String toSource(String className) throws Exception {
        if (this.m_Tree == null) {
            throw new Exception("REPTree: No model built yet.");
        }
        StringBuffer[] source = this.m_Tree.toSource(className, this.m_Tree);
        return "class " + className + " {\n\n  public static double classify(Object [] i)\n    throws Exception {\n\n    double p = Double.NaN;\n" + source[0] + "    return p;\n  }\n" + source[1] + "}\n";
    }

    @Override
    public int graphType() {
        return 1;
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Tree == null) {
            throw new Exception("REPTree: No model built yet.");
        }
        StringBuffer resultBuff = new StringBuffer();
        this.m_Tree.toGraph(resultBuff, 0, null);
        String result = "digraph Tree {\nedge [style=bold]\n" + resultBuff.toString() + "\n}\n";
        return result;
    }

    public String toString() {
        if (this.m_zeroR != null) {
            return "No attributes other than class. Using ZeroR.\n\n" + this.m_zeroR.toString();
        }
        if (this.m_Tree == null) {
            return "REPTree: No model built yet.";
        }
        return "\nREPTree\n============\n" + this.m_Tree.toString(0, null) + "\n\nSize of the tree : " + this.numNodes();
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance instance) throws Exception {
        if (this.m_zeroR != null) {
            double[] m = new double[]{instance.weight()};
            return m;
        }
        double[] a = new double[this.numElements()];
        LinkedList<Double> queueOfWeights = new LinkedList<Double>();
        LinkedList<Tree> queueOfNodes = new LinkedList<Tree>();
        queueOfWeights.add(instance.weight());
        queueOfNodes.add(this.m_Tree);
        int index = 0;
        while (!queueOfNodes.isEmpty()) {
            a[index++] = (Double)queueOfWeights.poll();
            Tree node = (Tree)queueOfNodes.poll();
            if (node.m_Attribute <= -1) continue;
            double[] weights = new double[node.m_Successors.length];
            if (instance.isMissing(node.m_Attribute)) {
                System.arraycopy(node.m_Prop, 0, weights, 0, node.m_Prop.length);
            } else if (node.m_Info.attribute(node.m_Attribute).isNominal()) {
                weights[(int)instance.value((int)node.m_Attribute)] = 1.0;
            } else if (instance.value(node.m_Attribute) < node.m_SplitPoint) {
                weights[0] = 1.0;
            } else {
                weights[1] = 1.0;
            }
            for (int i = 0; i < node.m_Successors.length; ++i) {
                queueOfNodes.add(node.m_Successors[i]);
                queueOfWeights.add(a[index - 1] * weights[i]);
            }
        }
        return a;
    }

    @Override
    public int numElements() throws Exception {
        if (this.m_zeroR != null) {
            return 1;
        }
        return this.numNodes();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        REPTree.runClassifier(new REPTree(), argv);
    }

    protected class Tree
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -1635481717888437935L;
        protected Instances m_Info = null;
        protected Tree[] m_Successors;
        protected int m_Attribute = -1;
        protected double m_SplitPoint = Double.NaN;
        protected double[] m_Prop = null;
        protected double[] m_ClassProbs = null;
        protected double[] m_Distribution = null;
        protected double[] m_HoldOutDist = null;
        protected double m_HoldOutError = 0.0;

        protected Tree() {
        }

        protected double[] distributionForInstance(Instance instance) throws Exception {
            double[] returnedDist = null;
            if (this.m_Attribute > -1) {
                if (instance.isMissing(this.m_Attribute)) {
                    returnedDist = new double[this.m_Info.numClasses()];
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        double[] help = this.m_Successors[i].distributionForInstance(instance);
                        if (help == null) continue;
                        for (int j = 0; j < help.length; ++j) {
                            int n = j;
                            returnedDist[n] = returnedDist[n] + this.m_Prop[i] * help[j];
                        }
                    }
                } else {
                    returnedDist = this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
                }
            }
            if (this.m_Attribute == -1 || returnedDist == null) {
                if (this.m_ClassProbs == null) {
                    return this.m_ClassProbs;
                }
                return (double[])this.m_ClassProbs.clone();
            }
            return returnedDist;
        }

        public final String sourceExpression(int index) {
            StringBuffer expr = null;
            if (index < 0) {
                return "i[" + this.m_Attribute + "] == null";
            }
            if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                expr = new StringBuffer("i[");
                expr.append(this.m_Attribute).append("]");
                expr.append(".equals(\"").append(this.m_Info.attribute(this.m_Attribute).value(index)).append("\")");
            } else {
                expr = new StringBuffer("");
                if (index == 0) {
                    expr.append("((Double)i[").append(this.m_Attribute).append("]).doubleValue() < ").append(this.m_SplitPoint);
                } else {
                    expr.append("true");
                }
            }
            return expr.toString();
        }

        public StringBuffer[] toSource(String className, Tree parent) throws Exception {
            StringBuffer[] result = new StringBuffer[2];
            double[] currentProbs = this.m_ClassProbs == null ? parent.m_ClassProbs : this.m_ClassProbs;
            long printID = REPTree.nextID();
            if (this.m_Attribute == -1) {
                result[0] = new StringBuffer("\tp = ");
                if (this.m_Info.classAttribute().isNumeric()) {
                    result[0].append(currentProbs[0]);
                } else {
                    result[0].append(Utils.maxIndex(currentProbs));
                }
                result[0].append(";\n");
                result[1] = new StringBuffer("");
            } else {
                StringBuffer text = new StringBuffer("");
                StringBuffer atEnd = new StringBuffer("");
                text.append("  static double N").append(Integer.toHexString(this.hashCode()) + printID).append("(Object []i) {\n").append("    double p = Double.NaN;\n");
                text.append("    /* " + this.m_Info.attribute(this.m_Attribute).name() + " */\n");
                text.append("    if (" + this.sourceExpression(-1) + ") {\n").append("      p = ");
                if (this.m_Info.classAttribute().isNumeric()) {
                    text.append(currentProbs[0] + ";\n");
                } else {
                    text.append(Utils.maxIndex(currentProbs) + ";\n");
                }
                text.append("    } ");
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    text.append("else if (" + this.sourceExpression(i) + ") {\n");
                    if (this.m_Successors[i].m_Attribute == -1) {
                        double[] successorProbs = this.m_Successors[i].m_ClassProbs;
                        if (successorProbs == null) {
                            successorProbs = this.m_ClassProbs;
                        }
                        text.append("      p = ");
                        if (this.m_Info.classAttribute().isNumeric()) {
                            text.append(successorProbs[0] + ";\n");
                        } else {
                            text.append(Utils.maxIndex(successorProbs) + ";\n");
                        }
                    } else {
                        StringBuffer[] sub = this.m_Successors[i].toSource(className, this);
                        text.append("" + sub[0]);
                        atEnd.append("" + sub[1]);
                    }
                    text.append("    } ");
                    if (i != this.m_Successors.length - 1) continue;
                    text.append("\n");
                }
                text.append("    return p;\n  }\n");
                result[0] = new StringBuffer("    p = " + className + ".N");
                result[0].append(Integer.toHexString(this.hashCode()) + printID).append("(i);\n");
                result[1] = text.append("" + atEnd);
            }
            return result;
        }

        protected int toGraph(StringBuffer text, int num, Tree parent) throws Exception {
            ++num;
            if (this.m_Attribute == -1) {
                text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + Utils.backQuoteChars(this.leafString(parent)) + "\"shape=box]\n");
            } else {
                text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + Utils.backQuoteChars(this.m_Info.attribute(this.m_Attribute).name()) + "\"]\n");
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    text.append("N" + Integer.toHexString(this.hashCode()) + "->N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"");
                    if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                        if (i == 0) {
                            text.append(" < " + Utils.doubleToString(this.m_SplitPoint, REPTree.this.getNumDecimalPlaces()));
                        } else {
                            text.append(" >= " + Utils.doubleToString(this.m_SplitPoint, REPTree.this.getNumDecimalPlaces()));
                        }
                    } else {
                        text.append(" = " + Utils.backQuoteChars(this.m_Info.attribute(this.m_Attribute).value(i)));
                    }
                    text.append("\"]\n");
                    num = this.m_Successors[i].toGraph(text, num, this);
                }
            }
            return num;
        }

        protected String leafString(Tree parent) throws Exception {
            if (this.m_Info.classAttribute().isNumeric()) {
                double classMean = this.m_ClassProbs == null ? parent.m_ClassProbs[0] : this.m_ClassProbs[0];
                StringBuffer buffer = new StringBuffer();
                buffer.append(" : " + Utils.doubleToString(classMean, REPTree.this.getNumDecimalPlaces()));
                double avgError = 0.0;
                if (this.m_Distribution[1] > 0.0) {
                    avgError = this.m_Distribution[0] / this.m_Distribution[1];
                }
                buffer.append(" (" + Utils.doubleToString(this.m_Distribution[1], REPTree.this.getNumDecimalPlaces()) + "/" + Utils.doubleToString(avgError, REPTree.this.getNumDecimalPlaces()) + ")");
                avgError = 0.0;
                if (this.m_HoldOutDist[0] > 0.0) {
                    avgError = this.m_HoldOutError / this.m_HoldOutDist[0];
                }
                buffer.append(" [" + Utils.doubleToString(this.m_HoldOutDist[0], REPTree.this.getNumDecimalPlaces()) + "/" + Utils.doubleToString(avgError, REPTree.this.getNumDecimalPlaces()) + "]");
                return buffer.toString();
            }
            int maxIndex = this.m_ClassProbs == null ? Utils.maxIndex(parent.m_ClassProbs) : Utils.maxIndex(this.m_ClassProbs);
            return " : " + this.m_Info.classAttribute().value(maxIndex) + " (" + Utils.doubleToString(Utils.sum(this.m_Distribution), REPTree.this.getNumDecimalPlaces()) + "/" + Utils.doubleToString(Utils.sum(this.m_Distribution) - this.m_Distribution[maxIndex], REPTree.this.getNumDecimalPlaces()) + ") [" + Utils.doubleToString(Utils.sum(this.m_HoldOutDist), REPTree.this.getNumDecimalPlaces()) + "/" + Utils.doubleToString(Utils.sum(this.m_HoldOutDist) - this.m_HoldOutDist[maxIndex], REPTree.this.getNumDecimalPlaces()) + "]";
        }

        protected String toString(int level, Tree parent) {
            try {
                StringBuffer text = new StringBuffer();
                if (this.m_Attribute == -1) {
                    return this.leafString(parent);
                }
                if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        text.append("\n");
                        for (int j = 0; j < level; ++j) {
                            text.append("|   ");
                        }
                        text.append(this.m_Info.attribute(this.m_Attribute).name() + " = " + this.m_Info.attribute(this.m_Attribute).value(i));
                        text.append(this.m_Successors[i].toString(level + 1, this));
                    }
                } else {
                    int j;
                    text.append("\n");
                    for (j = 0; j < level; ++j) {
                        text.append("|   ");
                    }
                    text.append(this.m_Info.attribute(this.m_Attribute).name() + " < " + Utils.doubleToString(this.m_SplitPoint, REPTree.this.getNumDecimalPlaces()));
                    text.append(this.m_Successors[0].toString(level + 1, this));
                    text.append("\n");
                    for (j = 0; j < level; ++j) {
                        text.append("|   ");
                    }
                    text.append(this.m_Info.attribute(this.m_Attribute).name() + " >= " + Utils.doubleToString(this.m_SplitPoint, REPTree.this.getNumDecimalPlaces()));
                    text.append(this.m_Successors[1].toString(level + 1, this));
                }
                return text.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Decision tree: tree can't be printed";
            }
        }

        protected void buildTree(int[][][] sortedIndices, double[][][] weights, Instances data, double totalWeight, double[] classProbs, Instances header, double minNum, double minVariance, int depth, int maxDepth) throws Exception {
            int i;
            this.m_Info = header;
            this.m_HoldOutDist = data.classAttribute().isNumeric() ? new double[2] : new double[data.numClasses()];
            int helpIndex = 0;
            if (data.classIndex() == 0) {
                helpIndex = 1;
            }
            if (sortedIndices[0][helpIndex].length == 0) {
                this.m_Distribution = data.classAttribute().isNumeric() ? new double[2] : new double[data.numClasses()];
                this.m_ClassProbs = null;
                sortedIndices[0] = null;
                weights[0] = null;
                return;
            }
            double priorVar = 0.0;
            if (data.classAttribute().isNumeric()) {
                double totalSum = 0.0;
                double totalSumSquared = 0.0;
                double totalSumOfWeights = 0.0;
                for (int i2 = 0; i2 < sortedIndices[0][helpIndex].length; ++i2) {
                    Instance inst = data.instance(sortedIndices[0][helpIndex][i2]);
                    totalSum += inst.classValue() * weights[0][helpIndex][i2];
                    totalSumSquared += inst.classValue() * inst.classValue() * weights[0][helpIndex][i2];
                    totalSumOfWeights += weights[0][helpIndex][i2];
                }
                priorVar = this.singleVariance(totalSum, totalSumSquared, totalSumOfWeights);
            }
            this.m_ClassProbs = new double[classProbs.length];
            System.arraycopy(classProbs, 0, this.m_ClassProbs, 0, classProbs.length);
            if (totalWeight < 2.0 * minNum || data.classAttribute().isNominal() && Utils.eq(this.m_ClassProbs[Utils.maxIndex(this.m_ClassProbs)], Utils.sum(this.m_ClassProbs)) || data.classAttribute().isNumeric() && priorVar / totalWeight < minVariance || REPTree.this.m_MaxDepth >= 0 && depth >= maxDepth) {
                this.m_Attribute = -1;
                if (data.classAttribute().isNominal()) {
                    this.m_Distribution = new double[this.m_ClassProbs.length];
                    for (int i3 = 0; i3 < this.m_ClassProbs.length; ++i3) {
                        this.m_Distribution[i3] = this.m_ClassProbs[i3];
                    }
                    this.doSmoothing();
                    Utils.normalize(this.m_ClassProbs);
                } else {
                    this.m_Distribution = new double[2];
                    this.m_Distribution[0] = priorVar;
                    this.m_Distribution[1] = totalWeight;
                }
                sortedIndices[0] = null;
                weights[0] = null;
                return;
            }
            double[] vals = new double[data.numAttributes()];
            double[][][] dists = new double[data.numAttributes()][0][0];
            double[][] props = new double[data.numAttributes()][0];
            double[][] totalSubsetWeights = new double[data.numAttributes()][0];
            double[] splits = new double[data.numAttributes()];
            if (data.classAttribute().isNominal()) {
                for (i = 0; i < data.numAttributes(); ++i) {
                    if (i == data.classIndex()) continue;
                    splits[i] = this.distribution(props, dists, i, sortedIndices[0][i], weights[0][i], totalSubsetWeights, data);
                    vals[i] = this.gain(dists[i], this.priorVal(dists[i]));
                }
            } else {
                for (i = 0; i < data.numAttributes(); ++i) {
                    if (i == data.classIndex()) continue;
                    splits[i] = this.numericDistribution(props, dists, i, sortedIndices[0][i], weights[0][i], totalSubsetWeights, data, vals);
                }
            }
            this.m_Attribute = Utils.maxIndex(vals);
            int numAttVals = dists[this.m_Attribute].length;
            int count = 0;
            for (int i4 = 0; i4 < numAttVals; ++i4) {
                if (totalSubsetWeights[this.m_Attribute][i4] >= minNum) {
                    ++count;
                }
                if (count > 1) break;
            }
            if (Utils.gr(vals[this.m_Attribute], 0.0) && count > 1) {
                this.m_SplitPoint = splits[this.m_Attribute];
                this.m_Prop = props[this.m_Attribute];
                double[][] attSubsetDists = dists[this.m_Attribute];
                double[] attTotalSubsetWeights = totalSubsetWeights[this.m_Attribute];
                vals = null;
                dists = null;
                props = null;
                totalSubsetWeights = null;
                splits = null;
                int[][][][] subsetIndices = new int[numAttVals][1][data.numAttributes()][0];
                double[][][][] subsetWeights = new double[numAttVals][1][data.numAttributes()][0];
                this.splitData(subsetIndices, subsetWeights, this.m_Attribute, this.m_SplitPoint, sortedIndices[0], weights[0], data);
                sortedIndices[0] = null;
                weights[0] = null;
                this.m_Successors = new Tree[numAttVals];
                for (int i5 = 0; i5 < numAttVals; ++i5) {
                    this.m_Successors[i5] = new Tree();
                    this.m_Successors[i5].buildTree(subsetIndices[i5], subsetWeights[i5], data, attTotalSubsetWeights[i5], attSubsetDists[i5], header, minNum, minVariance, depth + 1, maxDepth);
                    attSubsetDists[i5] = null;
                }
            } else {
                this.m_Attribute = -1;
                sortedIndices[0] = null;
                weights[0] = null;
            }
            if (data.classAttribute().isNominal()) {
                this.m_Distribution = new double[this.m_ClassProbs.length];
                for (int i6 = 0; i6 < this.m_ClassProbs.length; ++i6) {
                    this.m_Distribution[i6] = this.m_ClassProbs[i6];
                }
                this.doSmoothing();
                Utils.normalize(this.m_ClassProbs);
            } else {
                this.m_Distribution = new double[2];
                this.m_Distribution[0] = priorVar;
                this.m_Distribution[1] = totalWeight;
            }
        }

        protected void doSmoothing() {
            double val = REPTree.this.m_InitialCount;
            if (REPTree.this.m_SpreadInitialCount) {
                val /= (double)this.m_ClassProbs.length;
            }
            int i = 0;
            while (i < this.m_ClassProbs.length) {
                int n = i++;
                this.m_ClassProbs[n] = this.m_ClassProbs[n] + val;
            }
        }

        protected int numNodes() {
            if (this.m_Attribute == -1) {
                return 1;
            }
            int size = 1;
            for (Tree m_Successor : this.m_Successors) {
                size += m_Successor.numNodes();
            }
            return size;
        }

        protected void splitData(int[][][][] subsetIndices, double[][][][] subsetWeights, int att, double splitPoint, int[][] sortedIndices, double[][] weights, Instances data) throws Exception {
            for (int i = 0; i < data.numAttributes(); ++i) {
                int j;
                int k;
                int[] num;
                if (i == data.classIndex()) continue;
                if (data.attribute(att).isNominal()) {
                    num = new int[data.attribute(att).numValues()];
                    for (k = 0; k < num.length; ++k) {
                        subsetIndices[k][0][i] = new int[sortedIndices[i].length];
                        subsetWeights[k][0][i] = new double[sortedIndices[i].length];
                    }
                    for (j = 0; j < sortedIndices[i].length; ++j) {
                        Instance inst = data.instance(sortedIndices[i][j]);
                        if (inst.isMissing(att)) {
                            for (int k2 = 0; k2 < num.length; ++k2) {
                                if (!(this.m_Prop[k2] > 0.0)) continue;
                                subsetIndices[k2][0][i][num[k2]] = sortedIndices[i][j];
                                subsetWeights[k2][0][i][num[k2]] = this.m_Prop[k2] * weights[i][j];
                                int n = k2;
                                num[n] = num[n] + 1;
                            }
                            continue;
                        }
                        int subset = (int)inst.value(att);
                        subsetIndices[subset][0][i][num[subset]] = sortedIndices[i][j];
                        subsetWeights[subset][0][i][num[subset]] = weights[i][j];
                        int n = subset;
                        num[n] = num[n] + 1;
                    }
                } else {
                    num = new int[2];
                    for (k = 0; k < 2; ++k) {
                        subsetIndices[k][0][i] = new int[sortedIndices[i].length];
                        subsetWeights[k][0][i] = new double[weights[i].length];
                    }
                    for (j = 0; j < sortedIndices[i].length; ++j) {
                        Instance inst = data.instance(sortedIndices[i][j]);
                        if (inst.isMissing(att)) {
                            for (int k3 = 0; k3 < num.length; ++k3) {
                                if (!(this.m_Prop[k3] > 0.0)) continue;
                                subsetIndices[k3][0][i][num[k3]] = sortedIndices[i][j];
                                subsetWeights[k3][0][i][num[k3]] = this.m_Prop[k3] * weights[i][j];
                                int n = k3;
                                num[n] = num[n] + 1;
                            }
                            continue;
                        }
                        int subset = inst.value(att) < splitPoint ? 0 : 1;
                        subsetIndices[subset][0][i][num[subset]] = sortedIndices[i][j];
                        subsetWeights[subset][0][i][num[subset]] = weights[i][j];
                        int n = subset;
                        num[n] = num[n] + 1;
                    }
                }
                for (k = 0; k < num.length; ++k) {
                    int[] copy = new int[num[k]];
                    System.arraycopy(subsetIndices[k][0][i], 0, copy, 0, num[k]);
                    subsetIndices[k][0][i] = copy;
                    double[] copyWeights = new double[num[k]];
                    System.arraycopy(subsetWeights[k][0][i], 0, copyWeights, 0, num[k]);
                    subsetWeights[k][0][i] = copyWeights;
                }
            }
        }

        protected double distribution(double[][] props, double[][][] dists, int att, int[] sortedIndices, double[] weights, double[][] subsetWeights, Instances data) throws Exception {
            int k;
            int i;
            double splitPoint = Double.NaN;
            Attribute attribute = data.attribute(att);
            double[][] dist = null;
            if (attribute.isNominal()) {
                Instance inst;
                dist = new double[attribute.numValues()][data.numClasses()];
                for (i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                    double[] dArray = dist[(int)inst.value(att)];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + weights[i];
                }
            } else {
                Instance inst;
                Instance inst2;
                double[][] currDist = new double[2][data.numClasses()];
                dist = new double[2][data.numClasses()];
                for (int j = 0; j < sortedIndices.length && !(inst2 = data.instance(sortedIndices[j])).isMissing(att); ++j) {
                    double[] dArray = currDist[1];
                    int n = (int)inst2.classValue();
                    dArray[n] = dArray[n] + weights[j];
                }
                double priorVal = this.priorVal(currDist);
                System.arraycopy(currDist[1], 0, dist[1], 0, dist[1].length);
                double currSplit = data.instance(sortedIndices[0]).value(att);
                double bestVal = -1.7976931348623157E308;
                for (i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                    double currVal;
                    if (inst.value(att) > currSplit && (currVal = this.gain(currDist, priorVal)) > bestVal) {
                        bestVal = currVal;
                        splitPoint = (inst.value(att) + currSplit) / 2.0;
                        if (splitPoint <= currSplit) {
                            splitPoint = inst.value(att);
                        }
                        for (int j = 0; j < currDist.length; ++j) {
                            System.arraycopy(currDist[j], 0, dist[j], 0, dist[j].length);
                        }
                    }
                    currSplit = inst.value(att);
                    double[] dArray = currDist[0];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + weights[i];
                    double[] dArray2 = currDist[1];
                    int n2 = (int)inst.classValue();
                    dArray2[n2] = dArray2[n2] - weights[i];
                }
            }
            props[att] = new double[dist.length];
            for (k = 0; k < props[att].length; ++k) {
                props[att][k] = Utils.sum(dist[k]);
            }
            if (!(Utils.sum(props[att]) > 0.0)) {
                for (k = 0; k < props[att].length; ++k) {
                    props[att][k] = 1.0 / (double)props[att].length;
                }
            } else {
                Utils.normalize(props[att]);
            }
            while (i < sortedIndices.length) {
                Instance inst = data.instance(sortedIndices[i]);
                for (int j = 0; j < dist.length; ++j) {
                    double[] dArray = dist[j];
                    int n = (int)inst.classValue();
                    dArray[n] = dArray[n] + props[att][j] * weights[i];
                }
                ++i;
            }
            subsetWeights[att] = new double[dist.length];
            for (int j = 0; j < dist.length; ++j) {
                double[] dArray = subsetWeights[att];
                int n = j;
                dArray[n] = dArray[n] + Utils.sum(dist[j]);
            }
            dists[att] = dist;
            return splitPoint;
        }

        protected double numericDistribution(double[][] props, double[][][] dists, int att, int[] sortedIndices, double[] weights, double[][] subsetWeights, Instances data, double[] vals) throws Exception {
            int k;
            int i;
            double splitPoint = Double.NaN;
            Attribute attribute = data.attribute(att);
            double[][] dist = null;
            double[] sums = null;
            double[] sumSquared = null;
            double[] sumOfWeights = null;
            double totalSum = 0.0;
            double totalSumSquared = 0.0;
            double totalSumOfWeights = 0.0;
            if (attribute.isNominal()) {
                Instance inst;
                sums = new double[attribute.numValues()];
                sumSquared = new double[attribute.numValues()];
                sumOfWeights = new double[attribute.numValues()];
                for (i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                    int attVal;
                    int n = attVal = (int)inst.value(att);
                    sums[n] = sums[n] + inst.classValue() * weights[i];
                    int n2 = attVal;
                    sumSquared[n2] = sumSquared[n2] + inst.classValue() * inst.classValue() * weights[i];
                    int n3 = attVal;
                    sumOfWeights[n3] = sumOfWeights[n3] + weights[i];
                }
                totalSum = Utils.sum(sums);
                totalSumSquared = Utils.sum(sumSquared);
                totalSumOfWeights = Utils.sum(sumOfWeights);
            } else {
                Instance inst;
                Instance inst2;
                sums = new double[2];
                sumSquared = new double[2];
                sumOfWeights = new double[2];
                double[] currSums = new double[2];
                double[] currSumSquared = new double[2];
                double[] currSumOfWeights = new double[2];
                for (int j = 0; j < sortedIndices.length && !(inst2 = data.instance(sortedIndices[j])).isMissing(att); ++j) {
                    currSums[1] = currSums[1] + inst2.classValue() * weights[j];
                    currSumSquared[1] = currSumSquared[1] + inst2.classValue() * inst2.classValue() * weights[j];
                    currSumOfWeights[1] = currSumOfWeights[1] + weights[j];
                }
                totalSum = currSums[1];
                totalSumSquared = currSumSquared[1];
                totalSumOfWeights = currSumOfWeights[1];
                sums[1] = currSums[1];
                sumSquared[1] = currSumSquared[1];
                sumOfWeights[1] = currSumOfWeights[1];
                double currSplit = data.instance(sortedIndices[0]).value(att);
                double bestVal = Double.MAX_VALUE;
                for (i = 0; i < sortedIndices.length && !(inst = data.instance(sortedIndices[i])).isMissing(att); ++i) {
                    double currVal;
                    if (inst.value(att) > currSplit && (currVal = this.variance(currSums, currSumSquared, currSumOfWeights)) < bestVal) {
                        bestVal = currVal;
                        splitPoint = (inst.value(att) + currSplit) / 2.0;
                        if (splitPoint <= currSplit) {
                            splitPoint = inst.value(att);
                        }
                        for (int j = 0; j < 2; ++j) {
                            sums[j] = currSums[j];
                            sumSquared[j] = currSumSquared[j];
                            sumOfWeights[j] = currSumOfWeights[j];
                        }
                    }
                    currSplit = inst.value(att);
                    double classVal = inst.classValue() * weights[i];
                    double classValSquared = inst.classValue() * classVal;
                    currSums[0] = currSums[0] + classVal;
                    currSumSquared[0] = currSumSquared[0] + classValSquared;
                    currSumOfWeights[0] = currSumOfWeights[0] + weights[i];
                    currSums[1] = currSums[1] - classVal;
                    currSumSquared[1] = currSumSquared[1] - classValSquared;
                    currSumOfWeights[1] = currSumOfWeights[1] - weights[i];
                }
            }
            props[att] = new double[sums.length];
            for (k = 0; k < props[att].length; ++k) {
                props[att][k] = sumOfWeights[k];
            }
            if (!(Utils.sum(props[att]) > 0.0)) {
                for (k = 0; k < props[att].length; ++k) {
                    props[att][k] = 1.0 / (double)props[att].length;
                }
            } else {
                Utils.normalize(props[att]);
            }
            while (i < sortedIndices.length) {
                Instance inst = data.instance(sortedIndices[i]);
                for (int j = 0; j < sums.length; ++j) {
                    int n = j;
                    sums[n] = sums[n] + props[att][j] * inst.classValue() * weights[i];
                    int n4 = j;
                    sumSquared[n4] = sumSquared[n4] + props[att][j] * inst.classValue() * inst.classValue() * weights[i];
                    int n5 = j;
                    sumOfWeights[n5] = sumOfWeights[n5] + props[att][j] * weights[i];
                }
                totalSum += inst.classValue() * weights[i];
                totalSumSquared += inst.classValue() * inst.classValue() * weights[i];
                totalSumOfWeights += weights[i];
                ++i;
            }
            dist = new double[sums.length][data.numClasses()];
            for (int j = 0; j < sums.length; ++j) {
                dist[j][0] = sumOfWeights[j] > 0.0 ? sums[j] / sumOfWeights[j] : totalSum / totalSumOfWeights;
            }
            double priorVar = this.singleVariance(totalSum, totalSumSquared, totalSumOfWeights);
            double var = this.variance(sums, sumSquared, sumOfWeights);
            double gain = priorVar - var;
            subsetWeights[att] = sumOfWeights;
            dists[att] = dist;
            vals[att] = gain;
            return splitPoint;
        }

        protected double variance(double[] s, double[] sS, double[] sumOfWeights) {
            double var = 0.0;
            for (int i = 0; i < s.length; ++i) {
                if (!(sumOfWeights[i] > 0.0)) continue;
                var += this.singleVariance(s[i], sS[i], sumOfWeights[i]);
            }
            return var;
        }

        protected double singleVariance(double s, double sS, double weight) {
            return sS - s * s / weight;
        }

        protected double priorVal(double[][] dist) throws InterruptedException {
            return ContingencyTables.entropyOverColumns(dist);
        }

        protected double gain(double[][] dist, double priorVal) {
            return priorVal - ContingencyTables.entropyConditionedOnRows(dist);
        }

        protected double reducedErrorPrune() throws Exception {
            if (this.m_Attribute == -1) {
                return this.m_HoldOutError;
            }
            double errorTree = 0.0;
            for (Tree m_Successor : this.m_Successors) {
                errorTree += m_Successor.reducedErrorPrune();
            }
            if (errorTree >= this.m_HoldOutError) {
                this.m_Attribute = -1;
                this.m_Successors = null;
                return this.m_HoldOutError;
            }
            return errorTree;
        }

        protected void insertHoldOutSet(Instances data) throws Exception {
            for (int i = 0; i < data.numInstances(); ++i) {
                this.insertHoldOutInstance(data.instance(i), data.instance(i).weight(), this);
            }
        }

        protected void insertHoldOutInstance(Instance inst, double weight, Tree parent) throws Exception {
            if (inst.classAttribute().isNominal()) {
                int n = (int)inst.classValue();
                this.m_HoldOutDist[n] = this.m_HoldOutDist[n] + weight;
                int predictedClass = 0;
                predictedClass = this.m_ClassProbs == null ? Utils.maxIndex(parent.m_ClassProbs) : Utils.maxIndex(this.m_ClassProbs);
                if (predictedClass != (int)inst.classValue()) {
                    this.m_HoldOutError += weight;
                }
            } else {
                this.m_HoldOutDist[0] = this.m_HoldOutDist[0] + weight;
                this.m_HoldOutDist[1] = this.m_HoldOutDist[1] + weight * inst.classValue();
                double diff = 0.0;
                diff = this.m_ClassProbs == null ? parent.m_ClassProbs[0] - inst.classValue() : this.m_ClassProbs[0] - inst.classValue();
                this.m_HoldOutError += diff * diff * weight;
            }
            if (this.m_Attribute != -1) {
                if (inst.isMissing(this.m_Attribute)) {
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        if (!(this.m_Prop[i] > 0.0)) continue;
                        this.m_Successors[i].insertHoldOutInstance(inst, weight * this.m_Prop[i], this);
                    }
                } else if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                    this.m_Successors[(int)inst.value(this.m_Attribute)].insertHoldOutInstance(inst, weight, this);
                } else if (inst.value(this.m_Attribute) < this.m_SplitPoint) {
                    this.m_Successors[0].insertHoldOutInstance(inst, weight, this);
                } else {
                    this.m_Successors[1].insertHoldOutInstance(inst, weight, this);
                }
            }
        }

        protected void backfitHoldOutSet() throws Exception {
            if (this.m_Info.classAttribute().isNominal()) {
                if (this.m_ClassProbs == null) {
                    this.m_ClassProbs = new double[this.m_Info.numClasses()];
                }
                System.arraycopy(this.m_Distribution, 0, this.m_ClassProbs, 0, this.m_Info.numClasses());
                for (int i = 0; i < this.m_HoldOutDist.length; ++i) {
                    int n = i;
                    this.m_ClassProbs[n] = this.m_ClassProbs[n] + this.m_HoldOutDist[i];
                }
                if (Utils.sum(this.m_ClassProbs) > 0.0) {
                    this.doSmoothing();
                    Utils.normalize(this.m_ClassProbs);
                } else {
                    this.m_ClassProbs = null;
                }
            } else {
                double sumOfWeightsTrainAndHoldout = this.m_Distribution[1] + this.m_HoldOutDist[0];
                if (sumOfWeightsTrainAndHoldout <= 0.0) {
                    return;
                }
                if (this.m_ClassProbs == null) {
                    this.m_ClassProbs = new double[1];
                } else {
                    this.m_ClassProbs[0] = this.m_ClassProbs[0] * this.m_Distribution[1];
                }
                this.m_ClassProbs[0] = this.m_ClassProbs[0] + this.m_HoldOutDist[1];
                this.m_ClassProbs[0] = this.m_ClassProbs[0] / sumOfWeightsTrainAndHoldout;
            }
            if (this.m_Attribute != -1) {
                for (Tree m_Successor : this.m_Successors) {
                    m_Successor.backfitHoldOutSet();
                }
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision$");
        }
    }
}

