/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropyBasedSplitCrit;
import weka.core.ContingencyTables;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class EntropySplitCrit
extends EntropyBasedSplitCrit {
    private static final long serialVersionUID = 5986252682266803935L;

    @Override
    public final double splitCritValue(Distribution bags) {
        return this.newEnt(bags);
    }

    @Override
    public final double splitCritValue(Distribution train, Distribution test) {
        int j;
        double result = 0.0;
        int numClasses = 0;
        for (j = 0; j < test.numClasses(); ++j) {
            if (!Utils.gr(train.perClass(j), 0.0) && !Utils.gr(test.perClass(j), 0.0)) continue;
            ++numClasses;
        }
        for (int i = 0; i < test.numBags(); ++i) {
            if (!Utils.gr(test.perBag(i), 0.0)) continue;
            for (j = 0; j < test.numClasses(); ++j) {
                if (!Utils.gr(test.perClassPerBag(i, j), 0.0)) continue;
                result -= test.perClassPerBag(i, j) * Math.log(train.perClassPerBag(i, j) + 1.0);
            }
            result += test.perBag(i) * Math.log(train.perBag(i) + (double)numClasses);
        }
        return result / ContingencyTables.log2;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

