/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.EM;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class DensityBasedClustererSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    private static final long serialVersionUID = 5124501059135692160L;
    protected boolean m_removeClassColumn = true;
    protected DensityBasedClusterer m_clusterer = new EM();
    protected ClusterEvaluation m_Evaluation;
    protected String[] m_additionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected int m_numberAdditionalMeasures = 0;
    protected String m_result = null;
    protected String m_clustererOptions = "";
    protected String m_clustererVersion = "";
    protected boolean m_NoSizeDetermination;
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 9;

    public DensityBasedClustererSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return " A SplitEvaluator that produces results for a density based clusterer. ";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSkips the determination of sizes (train/test/clusterer)\n\t(default: sizes are determined)", "no-size", 0, "-no-size"));
        newVector.addElement(new Option("\tThe full class name of the density based clusterer.\n\teg: weka.clusterers.EM", "W", 1, "-W <class name>"));
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_clusterer.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_clusterer)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_NoSizeDetermination = Utils.getFlag("no-size", options);
        String cName = Utils.getOption('W', options);
        if (cName.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        this.setClusterer((DensityBasedClusterer)AbstractClusterer.forName(cName, null));
        if (this.getClusterer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getClusterer())).setOptions(Utils.partitionOptions(options));
            this.updateOptions();
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] clustererOptions = new String[]{};
        if (this.m_clusterer != null && this.m_clusterer instanceof OptionHandler) {
            clustererOptions = ((OptionHandler)((Object)this.m_clusterer)).getOptions();
        }
        if (this.getClusterer() != null) {
            result.add("-W");
            result.add(this.getClusterer().getClass().getName());
        }
        if (this.getNoSizeDetermination()) {
            result.add("-no-size");
        }
        result.add("--");
        result.addAll(Arrays.asList(clustererOptions));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_additionalMeasures = additionalMeasures;
        if (this.m_additionalMeasures != null && this.m_additionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_additionalMeasures.length];
            if (this.m_clusterer instanceof AdditionalMeasureProducer) {
                Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).enumerateMeasures();
                while (en.hasMoreElements()) {
                    String mname = en.nextElement();
                    for (int j = 0; j < this.m_additionalMeasures.length; ++j) {
                        if (mname.compareToIgnoreCase(this.m_additionalMeasures[j]) != 0) continue;
                        this.m_doesProduce[j] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_clusterer instanceof AdditionalMeasureProducer) {
            Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_clusterer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("DensityBasedClustererSplitEvaluator: Can't return value for : " + additionalMeasureName + ". " + this.m_clusterer.getClass().getName() + " is not an AdditionalMeasureProducer");
    }

    @Override
    public Object[] getKeyTypes() {
        Object[] keyTypes = new Object[]{"", "", ""};
        return keyTypes;
    }

    @Override
    public String[] getKeyNames() {
        String[] keyNames = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return keyNames;
    }

    @Override
    public Object[] getKey() {
        Object[] key = new Object[]{this.m_clusterer.getClass().getName(), this.m_clustererOptions, this.m_clustererVersion};
        return key;
    }

    @Override
    public Object[] getResultTypes() {
        int addm = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int overall_length = 9 + addm;
        Object[] resultTypes = new Object[overall_length];
        Double doub = new Double(0.0);
        int current = 0;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        for (int i = 0; i < addm; ++i) {
            resultTypes[current++] = doub;
        }
        if (current != overall_length) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return resultTypes;
    }

    @Override
    public String[] getResultNames() {
        int addm = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int overall_length = 9 + addm;
        String[] resultNames = new String[overall_length];
        int current = 0;
        resultNames[current++] = "Number_of_training_instances";
        resultNames[current++] = "Number_of_testing_instances";
        resultNames[current++] = "Log_likelihood";
        resultNames[current++] = "Number_of_clusters";
        resultNames[current++] = "Time_training";
        resultNames[current++] = "Time_testing";
        resultNames[current++] = "Serialized_Model_Size";
        resultNames[current++] = "Serialized_Train_Set_Size";
        resultNames[current++] = "Serialized_Test_Set_Size";
        for (int i = 0; i < addm; ++i) {
            resultNames[current++] = this.m_additionalMeasures[i];
        }
        if (current != overall_length) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return resultNames;
    }

    @Override
    public Object[] getResult(Instances train, Instances test) throws Exception {
        if (this.m_clusterer == null) {
            throw new Exception("No clusterer has been specified");
        }
        int addm = this.m_additionalMeasures != null ? this.m_additionalMeasures.length : 0;
        int overall_length = 9 + addm;
        if (this.m_removeClassColumn && train.classIndex() != -1) {
            Remove r = new Remove();
            r.setAttributeIndicesArray(new int[]{train.classIndex()});
            r.setInvertSelection(false);
            r.setInputFormat(train);
            train = Filter.useFilter(train, r);
            test = Filter.useFilter(test, r);
        }
        train.setClassIndex(-1);
        test.setClassIndex(-1);
        ClusterEvaluation eval = new ClusterEvaluation();
        Object[] result = new Object[overall_length];
        long trainTimeStart = System.currentTimeMillis();
        this.m_clusterer.buildClusterer(train);
        double numClusters = this.m_clusterer.numberOfClusters();
        eval.setClusterer(this.m_clusterer);
        long trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        long testTimeStart = System.currentTimeMillis();
        eval.evaluateClusterer(test);
        long testTimeElapsed = System.currentTimeMillis() - testTimeStart;
        int current = 0;
        result[current++] = new Double(train.numInstances());
        result[current++] = new Double(test.numInstances());
        result[current++] = new Double(eval.getLogLikelihood());
        result[current++] = new Double(numClusters);
        result[current++] = new Double((double)trainTimeElapsed / 1000.0);
        result[current++] = new Double((double)testTimeElapsed / 1000.0);
        if (this.m_NoSizeDetermination) {
            result[current++] = -1.0;
            result[current++] = -1.0;
            result[current++] = -1.0;
        } else {
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(this.m_clusterer);
            result[current++] = new Double(bastream.size());
            bastream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(train);
            result[current++] = new Double(bastream.size());
            bastream = new ByteArrayOutputStream();
            oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(test);
            result[current++] = new Double(bastream.size());
        }
        for (int i = 0; i < addm; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double dv = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(this.m_additionalMeasures[i]);
                    Double value = new Double(dv);
                    result[current++] = value;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            result[current++] = null;
        }
        if (current != overall_length) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        this.m_Evaluation = eval;
        return result;
    }

    public String removeClassColumnTipText() {
        return "Remove the class column (if set) from the data.";
    }

    public void setRemoveClassColumn(boolean r) {
        this.m_removeClassColumn = r;
    }

    public boolean getRemoveClassColumn() {
        return this.m_removeClassColumn;
    }

    public String clustererTipText() {
        return "The density based clusterer to use.";
    }

    public DensityBasedClusterer getClusterer() {
        return this.m_clusterer;
    }

    public void setClusterer(DensityBasedClusterer newClusterer) {
        this.m_clusterer = newClusterer;
        this.updateOptions();
    }

    public boolean getNoSizeDetermination() {
        return this.m_NoSizeDetermination;
    }

    public void setNoSizeDetermination(boolean value) {
        this.m_NoSizeDetermination = value;
    }

    public String noSizeDeterminationTipText() {
        return "If enabled, the size determination for train/test/clusterer is skipped.";
    }

    protected void updateOptions() {
        this.m_clustererOptions = this.m_clusterer instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_clusterer)).getOptions()) : "";
        if (this.m_clusterer instanceof Serializable) {
            ObjectStreamClass obs = ObjectStreamClass.lookup(this.m_clusterer.getClass());
            this.m_clustererVersion = "" + obs.getSerialVersionUID();
        } else {
            this.m_clustererVersion = "";
        }
    }

    public void setClustererName(String newClustererName) throws Exception {
        try {
            this.setClusterer((DensityBasedClusterer)Class.forName(newClustererName).newInstance());
        }
        catch (Exception ex) {
            throw new Exception("Can't find Clusterer with class name: " + newClustererName);
        }
    }

    @Override
    public String getRawResultOutput() {
        StringBuffer result = new StringBuffer();
        if (this.m_clusterer == null) {
            return "<null> clusterer";
        }
        result.append(this.toString());
        result.append("Clustering model: \n" + this.m_clusterer.toString() + '\n');
        if (this.m_result != null && this.m_doesProduce != null) {
            for (int i = 0; i < this.m_doesProduce.length; ++i) {
                if (!this.m_doesProduce[i]) continue;
                try {
                    double dv = ((AdditionalMeasureProducer)((Object)this.m_clusterer)).getMeasure(this.m_additionalMeasures[i]);
                    Double value = new Double(dv);
                    result.append(this.m_additionalMeasures[i] + " : " + value + '\n');
                    continue;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        }
        return result.toString();
    }

    public String toString() {
        String result = "DensityBasedClustererSplitEvaluator: ";
        if (this.m_clusterer == null) {
            return result + "<null> clusterer";
        }
        return result + this.m_clusterer.getClass().getName() + " " + this.m_clustererOptions + "(version " + this.m_clustererVersion + ")";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

