/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleStreamFilter;

public class NumericCleaner
extends SimpleStreamFilter
implements WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = -352890679895066592L;
    protected double m_MinThreshold = -1.7976931348623157E308;
    protected double m_MinDefault = -1.7976931348623157E308;
    protected double m_MaxThreshold = Double.MAX_VALUE;
    protected double m_MaxDefault = Double.MAX_VALUE;
    protected double m_CloseTo = 0.0;
    protected double m_CloseToDefault = 0.0;
    protected double m_CloseToTolerance = 1.0E-6;
    protected Range m_Cols = new Range("first-last");
    protected boolean m_IncludeClass = false;
    protected int m_Decimals = -1;

    @Override
    public String globalInfo() {
        return "A filter that 'cleanses' the numeric data from values that are too small, too big or very close to a certain value, and sets these values to a pre-defined default.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(11);
        result.addElement(new Option("\tThe minimum threshold below which values are replaced by the corresponding default.\n\t(default -Double.MAX_VALUE)", "min", 1, "-min <double>"));
        result.addElement(new Option("\tThe replacement for values smaller than the minimum threshold.\n\t(default -Double.MAX_VALUE)", "min-default", 1, "-min-default <double>"));
        result.addElement(new Option("\tThe maximum threshold above which values are replaced by the corresponding default.\n\t(default Double.MAX_VALUE)", "max", 1, "-max <double>"));
        result.addElement(new Option("\tThe replacement for values larger than the maximum threshold.\n\t(default Double.MAX_VALUE)", "max-default", 1, "-max-default <double>"));
        result.addElement(new Option("\tThe value with respect to which closeness is determined. (default 0)", "closeto", 1, "-closeto <double>"));
        result.addElement(new Option("\tThe replacement for values that are too close to '-closeto'.\n\t(default 0)", "closeto-default", 1, "-closeto-default <double>"));
        result.addElement(new Option("\tThe tolerance for testing whether a value is too close.\n\t(default 1E-6)", "closeto-tolerance", 1, "-closeto-tolerance <double>"));
        result.addElement(new Option("\tThe number of decimals to round to, -1 means no rounding at all.\n\t(default -1)", "decimals", 1, "-decimals <int>"));
        result.addElement(new Option("\tThe list of columns to cleanse, e.g., first-last or first-3,5-last.\n\t(default first-last)", "R", 1, "-R <col1,col2,...>"));
        result.addElement(new Option("\tInverts the matching sense.", "V", 0, "-V"));
        result.addElement(new Option("\tWhether to include the class in the cleansing.\n\tThe class column will always be skipped if this flag is not\n\tpresent. (default no)", "include-class", 0, "-include-class"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>(20);
        result.add("-min");
        result.add("" + this.m_MinThreshold);
        result.add("-min-default");
        result.add("" + this.m_MinDefault);
        result.add("-max");
        result.add("" + this.m_MaxThreshold);
        result.add("-max-default");
        result.add("" + this.m_MaxDefault);
        result.add("-closeto");
        result.add("" + this.m_CloseTo);
        result.add("-closeto-default");
        result.add("" + this.m_CloseToDefault);
        result.add("-closeto-tolerance");
        result.add("" + this.m_CloseToTolerance);
        result.add("-R");
        result.add("" + this.m_Cols.getRanges());
        if (this.m_Cols.getInvert()) {
            result.add("-V");
        }
        if (this.m_IncludeClass) {
            result.add("-include-class");
        }
        result.add("-decimals");
        result.add("" + this.getDecimals());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("min", options);
        if (tmpStr.length() != 0) {
            this.setMinThreshold(Double.parseDouble(tmpStr));
        } else {
            this.setMinThreshold(-1.7976931348623157E308);
        }
        tmpStr = Utils.getOption("min-default", options);
        if (tmpStr.length() != 0) {
            this.setMinDefault(Double.parseDouble(tmpStr));
        } else {
            this.setMinDefault(-1.7976931348623157E308);
        }
        tmpStr = Utils.getOption("max", options);
        if (tmpStr.length() != 0) {
            this.setMaxThreshold(Double.parseDouble(tmpStr));
        } else {
            this.setMaxThreshold(Double.MAX_VALUE);
        }
        tmpStr = Utils.getOption("max-default", options);
        if (tmpStr.length() != 0) {
            this.setMaxDefault(Double.parseDouble(tmpStr));
        } else {
            this.setMaxDefault(Double.MAX_VALUE);
        }
        tmpStr = Utils.getOption("closeto", options);
        if (tmpStr.length() != 0) {
            this.setCloseTo(Double.parseDouble(tmpStr));
        } else {
            this.setCloseTo(0.0);
        }
        tmpStr = Utils.getOption("closeto-default", options);
        if (tmpStr.length() != 0) {
            this.setCloseToDefault(Double.parseDouble(tmpStr));
        } else {
            this.setCloseToDefault(0.0);
        }
        tmpStr = Utils.getOption("closeto-tolerance", options);
        if (tmpStr.length() != 0) {
            this.setCloseToTolerance(Double.parseDouble(tmpStr));
        } else {
            this.setCloseToTolerance(1.0E-6);
        }
        tmpStr = Utils.getOption("R", options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag("V", options));
        this.setIncludeClass(Utils.getFlag("include-class", options));
        tmpStr = Utils.getOption("decimals", options);
        if (tmpStr.length() != 0) {
            this.setDecimals(Integer.parseInt(tmpStr));
        } else {
            this.setDecimals(-1);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_Cols.setUpper(inputFormat.numAttributes() - 1);
        return new Instances(inputFormat);
    }

    @Override
    protected Instance process(Instance instance) throws Exception {
        double[] result = new double[instance.numAttributes()];
        double factor = this.m_Decimals > -1 ? StrictMath.pow(10.0, this.m_Decimals) : 1.0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            result[i] = instance.value(i);
            if (!instance.attribute(i).isNumeric() || !this.m_Cols.isInRange(i) || instance.classIndex() == i && !this.m_IncludeClass) continue;
            if (result[i] < this.m_MinThreshold) {
                if (this.getDebug()) {
                    System.out.println("Too small: " + result[i] + " -> " + this.m_MinDefault);
                }
                result[i] = this.m_MinDefault;
            } else if (result[i] > this.m_MaxThreshold) {
                if (this.getDebug()) {
                    System.out.println("Too big: " + result[i] + " -> " + this.m_MaxDefault);
                }
                result[i] = this.m_MaxDefault;
            } else if (result[i] - this.m_CloseTo < this.m_CloseToTolerance && this.m_CloseTo - result[i] < this.m_CloseToTolerance && result[i] != this.m_CloseTo) {
                if (this.getDebug()) {
                    System.out.println("Too close: " + result[i] + " -> " + this.m_CloseToDefault);
                }
                result[i] = this.m_CloseToDefault;
            }
            if (this.m_Decimals <= -1 || Utils.isMissingValue(result[i])) continue;
            double val = result[i];
            result[i] = val = (double)StrictMath.round(val * factor) / factor;
        }
        return instance.copy(result);
    }

    public String minThresholdTipText() {
        return "The minimum threshold below which values are replaced by the corresponding default.";
    }

    public double getMinThreshold() {
        return this.m_MinThreshold;
    }

    public void setMinThreshold(double value) {
        this.m_MinThreshold = value;
    }

    public String minDefaultTipText() {
        return "The replacement for values smaller than the minimum threshold.";
    }

    public double getMinDefault() {
        return this.m_MinDefault;
    }

    public void setMinDefault(double value) {
        this.m_MinDefault = value;
    }

    public String maxThresholdTipText() {
        return "The maximum threshold above which values are replaced by the corresponding default.";
    }

    public double getMaxThreshold() {
        return this.m_MaxThreshold;
    }

    public void setMaxThreshold(double value) {
        this.m_MaxThreshold = value;
    }

    public String maxDefaultTipText() {
        return "The replacement for values larger than the maximum threshold.";
    }

    public double getMaxDefault() {
        return this.m_MaxDefault;
    }

    public void setMaxDefault(double value) {
        this.m_MaxDefault = value;
    }

    public String closeToTipText() {
        return "The value with respect to which closeness is determined.";
    }

    public double getCloseTo() {
        return this.m_CloseTo;
    }

    public void setCloseTo(double value) {
        this.m_CloseTo = value;
    }

    public String closeToDefaultTipText() {
        return "The replacement for values that are too close.";
    }

    public double getCloseToDefault() {
        return this.m_CloseToDefault;
    }

    public void setCloseToDefault(double value) {
        this.m_CloseToDefault = value;
    }

    public String closeToToleranceTipText() {
        return "The tolerance for testing whether a value is too close.";
    }

    public double getCloseToTolerance() {
        return this.m_CloseToTolerance;
    }

    public void setCloseToTolerance(double value) {
        this.m_CloseToTolerance = value;
    }

    public String attributeIndicesTipText() {
        return "The selection of columns to use in the cleansing process, first and last are valid indices.";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public String invertSelectionTipText() {
        return "If enabled, the selection of the columns is inverted.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public String includeClassTipText() {
        return "If disabled, the class attribute will be left out of the cleaning process.";
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public void setIncludeClass(boolean value) {
        this.m_IncludeClass = value;
    }

    public String decimalsTipText() {
        return "The number of decimals to round to, -1 means no rounding at all.";
    }

    public int getDecimals() {
        return this.m_Decimals;
    }

    public void setDecimals(int value) {
        this.m_Decimals = value;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        NumericCleaner.runFilter(new NumericCleaner(), args);
    }
}

