/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.SVD;
import no.uib.cipr.matrix.SymmDenseEVD;
import no.uib.cipr.matrix.UpperSymmDenseMatrix;
import no.uib.cipr.matrix.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.instance.Resample;

public class Nystroem
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    static final long serialVersionUID = -251931442147263433L;
    public static double SMALL = 1.0E-6;
    protected Filter m_Filter = new Resample();
    protected Kernel m_Kernel;
    protected boolean m_useSVD;
    protected Instances m_Sample;
    protected Matrix m_WeightingMatrix;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.setMinimumNumberInstances(0);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @OptionMetadata(displayName="Use SVD and not eigendecomposition", description="Whether to use singular value decomposition instead of eigendecomposition.", displayOrder=3, commandLineParamName="use-svd", commandLineParamSynopsis="-use-svd", commandLineParamIsFlag=true)
    public boolean getUseSVD() {
        return this.m_useSVD;
    }

    public void setUseSVD(boolean flag) {
        this.m_useSVD = flag;
    }

    @OptionMetadata(displayName="Filter for sampling instances", description="The filter to use, which should be a filter that takes a sample of instances.", displayOrder=2, commandLineParamName="F", commandLineParamSynopsis="-F <filter specification>")
    public Filter getFilter() {
        return this.m_Filter;
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public void setKernel(Kernel value) {
        this.m_Kernel = value;
    }

    @OptionMetadata(displayName="Kernel function", description="The kernel function to use.", displayOrder=1, commandLineParamName="K", commandLineParamSynopsis="-K <kernel specification>")
    public Kernel getKernel() {
        return this.m_Kernel;
    }

    public Nystroem() {
        ((Resample)this.m_Filter).setNoReplacement(true);
        ((Resample)this.m_Filter).setSampleSizePercent(10.0);
        this.m_Kernel = new PolyKernel();
    }

    @Override
    public String globalInfo() {
        return "Implements the Nystroem method for feature extraction using a kernel function.\n\nFor more information on the algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tianbao Yang and Yu-Feng Li and Mehrdad Mahdavi and Rong Jin and Zhi-Hua Zhou");
        result.setValue(TechnicalInformation.Field.TITLE, "Nystr\"{o}m Method vs Random Fourier Features: A Theoretical and Empirical Comparison");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc 26th Annual Conference on Neural Information Processing Systems");
        result.setValue(TechnicalInformation.Field.PAGES, "485--493");
        result.setValue(TechnicalInformation.Field.YEAR, "2012");
        result.setValue(TechnicalInformation.Field.URL, "http://papers.nips.cc/paper/4588-nystrom-method-vs-random-fourier-features-a-theoretical-and-empirical-comparison");
        return result;
    }

    @Override
    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        UpperSymmDenseMatrix dhatr;
        double[] e;
        Filter filter = Filter.makeCopy(this.getFilter());
        filter.setInputFormat(inputFormat);
        this.m_Sample = Filter.useFilter(inputFormat, filter);
        this.m_Kernel = Kernel.makeCopy(this.m_Kernel);
        this.m_Kernel.buildKernel(this.m_Sample);
        int m = this.m_Sample.numInstances();
        int n = inputFormat.numInstances();
        UpperSymmDenseMatrix khatM = new UpperSymmDenseMatrix(m);
        for (int i2 = 0; i2 < m; ++i2) {
            for (int j = i2; j < m; ++j) {
                khatM.set(i2, j, this.m_Kernel.eval(i2, j, this.m_Sample.instance(i2)));
            }
        }
        this.m_Kernel.clean();
        if (this.m_Debug) {
            DenseMatrix kbM = new DenseMatrix(n, m);
            for (int i3 = 0; i3 < n; ++i3) {
                for (int j = 0; j < m; ++j) {
                    kbM.set(i3, j, this.m_Kernel.eval(-1, j, inputFormat.instance(i3)));
                }
            }
            SVD svd = SVD.factorize((Matrix)khatM);
            double[] singularValues = svd.getS();
            UpperSymmDenseMatrix sigmaI = new UpperSymmDenseMatrix(m);
            for (int i4 = 0; i4 < singularValues.length; ++i4) {
                if (!(singularValues[i4] > SMALL)) continue;
                sigmaI.set(i4, i4, 1.0 / singularValues[i4]);
            }
            System.err.println("U :\n" + svd.getU());
            System.err.println("Vt :\n" + svd.getVt());
            System.err.println("Reciprocal of singular values :\n" + sigmaI);
            Matrix pseudoInverse = svd.getU().mult((Matrix)sigmaI, (Matrix)new DenseMatrix(m, m)).mult((Matrix)svd.getVt(), (Matrix)new DenseMatrix(m, m));
            Matrix khatr = kbM.mult(pseudoInverse, (Matrix)new DenseMatrix(n, m)).mult(kbM.transpose((Matrix)new DenseMatrix(m, n)), (Matrix)new DenseMatrix(n, n));
            System.err.println("Reduced rank matrix: \n" + khatr);
        }
        if (this.getUseSVD()) {
            SVD svd = SVD.factorize((Matrix)khatM);
            e = svd.getS();
            dhatr = new UpperSymmDenseMatrix(e.length);
            for (i = 0; i < e.length; ++i) {
                if (!(Math.sqrt(e[i]) > SMALL)) continue;
                dhatr.set(i, i, 1.0 / Math.sqrt(e[i]));
            }
            if (this.m_Debug) {
                System.err.println("U matrix :\n" + svd.getU());
                System.err.println("Vt matrix :\n" + svd.getVt());
                System.err.println("Singluar values \n" + Utils.arrayToString(svd.getS()));
                System.err.println("Reciprocal of square root of singular values :\n" + dhatr);
            }
            this.m_WeightingMatrix = dhatr.mult((Matrix)svd.getVt(), (Matrix)new DenseMatrix(m, m));
        } else {
            SymmDenseEVD evd = SymmDenseEVD.factorize((Matrix)khatM);
            e = evd.getEigenvalues();
            dhatr = new UpperSymmDenseMatrix(e.length);
            for (i = 0; i < e.length; ++i) {
                if (!(Math.sqrt(e[i]) > SMALL)) continue;
                dhatr.set(i, i, 1.0 / Math.sqrt(e[i]));
            }
            if (this.m_Debug) {
                System.err.println("Eigenvector matrix :\n" + evd.getEigenvectors());
                System.err.println("Eigenvalues \n" + Utils.arrayToString(evd.getEigenvalues()));
                System.err.println("Reciprocal of square root of eigenvalues :\n" + dhatr);
            }
            this.m_WeightingMatrix = dhatr.mult(evd.getEigenvectors().transpose(), (Matrix)new DenseMatrix(m, m));
        }
        if (this.m_Debug) {
            System.err.println("Weighting matrix: \n" + this.m_WeightingMatrix);
        }
        boolean hasClass = inputFormat.classIndex() >= 0;
        ArrayList<Attribute> atts = new ArrayList<Attribute>(m + (hasClass ? 1 : 0));
        for (int i5 = 0; i5 < m; ++i5) {
            atts.add(new Attribute("z" + (i5 + 1)));
        }
        if (hasClass) {
            atts.add((Attribute)inputFormat.classAttribute().copy());
        }
        Instances d = new Instances(inputFormat.relationName(), atts, 0);
        if (hasClass) {
            d.setClassIndex(d.numAttributes() - 1);
        }
        return d;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances transformed = this.getOutputFormat();
        boolean hasClass = instances.classIndex() >= 0;
        int m = this.m_Sample.numInstances();
        for (Instance inst : instances) {
            DenseVector n = new DenseVector(m);
            for (int i = 0; i < m; ++i) {
                n.set(i, this.m_Kernel.eval(-1, i, inst));
            }
            Vector newInst = this.m_WeightingMatrix.mult((Vector)n, (Vector)new DenseVector(m));
            double[] newVals = new double[m + (hasClass ? 1 : 0)];
            for (int i = 0; i < m; ++i) {
                newVals[i] = newInst.get(i);
            }
            if (hasClass) {
                newVals[transformed.classIndex()] = inst.classValue();
            }
            transformed.add(new DenseInstance(inst.weight(), newVals));
        }
        return transformed;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] argv) {
        Nystroem.runFilter(new Nystroem(), argv);
    }
}

