package ai.lilystyle.analytics_android;

import android.os.Build;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

final class Constants {
    final static String LOG_TAG = "Lily_AI";
    final static String META_BASE_URL_KEY = "ai.lily.analytics.endpoint";
    final static String META_API_TOKEN_KEY = "ai.lily.analytics.api_token";
    final static String META_API_KEY_KEY = "ai.lily.analytics.api_key";
    final static String PREFS_FILE_NAME = "ai.lily.analytics.preferences";
    final static String UUID_PREF_NAME = "ai.lily.analytics.uuid";
    final static String SESSION_ID_PREF_NAME = "ai.lily.analytics.session_id";
    final static String SESSION_START_PREF_NAME = "ai.lily.analytics.session_start";
    final static String SESSION_LAST_EVENT_PREF_NAME = "ai.lily.analytics.session_last_event";
    final static String SESSION_DURATION = "ai.lily.analytics.session_duration";
    final static String LAST_TRACKED_ID = "ai.lily.analytics.last_tracked_id";
    final static String TRACKED_DATA_STORAGE_DIR = "ai.lily.analytics.storage_data_%d";
    final static int THREAD_POOL_SIZE = 3;
    final static String THREAD_NAME = "LilyAI-Worker-%d";

    final static int HTTP_CONNECT_TIMEOUT = 10;
    final static int HTTP_READ_TIMEOUT = 10;
    final static int HTTP_WRITE_TIMEOUT = 30;

    final static long DEFAULT_SESSION_DURATION = 30 * 60000L;

    final static Map<String, String> defaultHeaders = new HashMap<>();

    static {
        defaultHeaders.put("uagent", String.format(Locale.getDefault(), "ai.lily.analytics_android v1.0 device: (%s, %s, %s), os: %s (SDK: %d)",
                Build.BRAND, Build.MODEL, Build.DEVICE, Build.DISPLAY, Build.VERSION.SDK_INT));
    }

    private Constants() {}
}
