package ai.lilystyle.analytics_android;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

final class RequestsHelper {
    private RequestsHelper() {}

    static Response postPixel(String baseUrl, TrackingData data, OkHttpClient client) throws IOException {
        RequestBody body = RequestBody.create(data.data, MediaType.get("application/json; charset=utf-8"));
        Request.Builder requestBuilder = new Request.Builder().url(baseUrl)
                .post(body);
        for (String name : data.headers.keySet()) {
            if (name != null) {
                String value = data.headers.get(name);
                if (value != null) {
                    requestBuilder.header(name, value);
                }
            }
        }
        return client.newCall(requestBuilder.build()).execute();
    }

    static OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder()
                .connectTimeout(Constants.HTTP_CONNECT_TIMEOUT, TimeUnit.SECONDS)
                .readTimeout(Constants.HTTP_READ_TIMEOUT, TimeUnit.SECONDS)
                .writeTimeout(Constants.HTTP_WRITE_TIMEOUT, TimeUnit.SECONDS)
                .addInterceptor(new Interceptor() {
                    @NotNull
                    @Override
                    public Response intercept(@NotNull Chain chain) throws IOException {
                        Request.Builder builder = chain.request().newBuilder();
                        for (String header : Constants.defaultHeaders.keySet()) {
                            String value = Constants.defaultHeaders.get(header);
                            if (value != null) {
                                builder.header(header, value);
                            }
                        }
                        builder.header("ts", String.valueOf(System.currentTimeMillis()));
                        return chain.proceed(builder.build());
                    }
                });

        //okhttp3.logging.HttpLoggingInterceptor logger = new okhttp3.logging.HttpLoggingInterceptor();
        //logger.setLevel(okhttp3.logging.HttpLoggingInterceptor.Level.BODY);
        //builder.addInterceptor(logger);

        return builder.build();
    }
}
