package ai.lilystyle.analytics_android;

import org.json.JSONObject;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class TrackingData implements Serializable {
    final long id;
    final Map<String, String> headers;
    final String data;

    TrackingData(long id, Map<String, String> headers, JSONObject data) {
        this.id = id;
        this.headers = new HashMap<>();
        this.headers.putAll(headers);
        this.data = data.toString();
    }

    @Override
    public int hashCode() {
        return Long.valueOf(id).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof TrackingData) ? id == ((TrackingData) obj).id : super.equals(obj);
    }
}
