package ai.lilystyle.analytics_android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;

import java.util.UUID;

final class Utils {
    private Utils() {}

    static String getMetadataString(Context context, String key) {
        if (context == null) return null;

        context = context.getApplicationContext();
        try {
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = app.metaData;
            return bundle.getString(key);
        } catch (PackageManager.NameNotFoundException ignored) {}

        return null;
    }

    static String getUUID(SharedPreferences prefs, boolean tryRestore) {
        String uuid = "";
        try {
            uuid = prefs.getString(Constants.UUID_PREF_NAME, uuid);
        } catch (Exception ignored) {}
        if (tryRestore && !uuid.isEmpty()) {
            return uuid;
        }

        uuid = generateUUID();

        updateUUID(prefs, uuid);

        return uuid;
    }

    private static String generateUUID() {
        UUID randomUUID = UUID.randomUUID();
        long msb = randomUUID.getMostSignificantBits() ^ System.currentTimeMillis() ^ ((long) (Build.BRAND+Build.MODEL).hashCode());
        long lsb = randomUUID.getLeastSignificantBits() ^ SystemClock.uptimeMillis() ^ ((long) (Build.DISPLAY+Build.DEVICE).hashCode());

        return new UUID(msb, lsb).toString();
    }

    static void updateUUID(SharedPreferences prefs, String uuid) {
        prefs.edit().putString(Constants.UUID_PREF_NAME, uuid).apply();
    }
}
