package ai.lilystyle.analytics_android;

import org.json.JSONObject;

import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

class Worker implements Runnable {
    private final OkHttpClient okHttpClient;
    private final String baseUrl;
    private final TrackingData data;
    private final WorkerListener listener;
    private final LilyAiListener lilyAiListener;
    private final boolean isFromRetry;

    Worker(String baseUrl, TrackingData data, boolean isFromRetry, OkHttpClient okHttpClient, WorkerListener listener, LilyAiListener lilyAiListener) {
        this.okHttpClient = okHttpClient;
        this.baseUrl = baseUrl;
        this.data = data;
        this.listener = listener;
        this.lilyAiListener = lilyAiListener;
        this.isFromRetry = isFromRetry;
    }

    @Override
    public void run() {
        try (Response response = RequestsHelper.postPixel(baseUrl, data, okHttpClient)) {
            ResponseBody body = response.body();
            if (body == null) {
                listener.onError(data, isFromRetry, response.code(), null, lilyAiListener);
            } else {
                JSONObject responseData = new JSONObject(body.string());
                if (responseData.has("success")) {
                    if (responseData.getBoolean("success")) {
                        listener.onSuccess(data, isFromRetry, lilyAiListener);
                        return;
                    }
                }
                listener.onError(data, isFromRetry, response.code(), responseData.getString("message"), lilyAiListener);
            }
        } catch (Exception e) {
            listener.onError(data, isFromRetry, 0, e.getMessage(), lilyAiListener);
        }
    }
}
