package ai.lilystyle.analytics_android.data;

import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * DataFactory is a helper class for creating typical data structures for tracking.
 *
 * Please refer to the main document to get the meaning of each field
 *
 * Usage example:
 * <pre>
 * {@code
 * JSONObject data = DataFactory.createProductListView()
 *     .setProductCategory("Skirts")
 *     .setSortType("Low To High")
 *     .addFilterBy(DataFactory.createFilterBy()
 *             .setFilterCategory("Cut")
 *             .addFilterValues("Skinny Leg"))
 *     .setRecommendationRequestID("fsdkjk23432")
 *     .addProduct(DataFactory.createProduct()
 *             .setSkuId("45790432")
 *             .setSize("xs")
 *             .setPrice(24)
 *             .setSalePrice(20.99)
 *             .setCurrencyCode("USD")
 *             .setPosition(1)
 *             .setBadgeName("Favorites")
 *             .setFavoriteCount(10))
 *     .addProduct(DataFactory.createProduct()
 *             .setSkuId("9848545")
 *             .setSize("xs")
 *             .setPrice(24)
 *             .setSalePrice(20.99)
 *             .setCurrencyCode("USD")
 *             .setPosition(2)
 *             .setBadgeName("New Arrival")
 *             .setFavoriteCount(10))
 *     .set("custom_field", "MY_VALUE")
 *     .build();
 *
 * lilyAi.track(data, listener);
 * }
 * </pre>
 */
public class DataFactory {
    private DataFactory() {}

    public static BaseMessageBuilder createBaseMessage() {
        return new BaseMessageBuilder();
    }

    public static FilterByBuilder createFilterBy() {
        return new FilterByBuilder();
    }

    public static ProductBuilder createProduct() {
        return new ProductBuilder();
    }

    public static ProductListViewBuilder createProductListView() {
        return new ProductListViewBuilder();
    }

    public static ProductSearchBuilder createProductSearch() {
        return new ProductSearchBuilder();
    }

    public static NotifyBuilder createNotify() {
        return new NotifyBuilder();
    }

    public static SaveSearchClickBuilder createSaveSearchClick() {
        return new SaveSearchClickBuilder();
    }

    public static SavedSearchUpdateBuilder createSavedSearchUpdate() {
        return new SavedSearchUpdateBuilder();
    }

    public static ProductClickBuilder createProductClick() {
        return new ProductClickBuilder();
    }

    public static ProductViewBuilder createProductView() {
        return new ProductViewBuilder();
    }

    public static AddToCartBuilder createAddToCart() {
        return new AddToCartBuilder();
    }

    public static RemoveFromCartBuilder createRemoveFromCart() {
        return new RemoveFromCartBuilder();
    }

    public static CheckoutInitiateBuilder createCheckoutInitiate() {
        return new CheckoutInitiateBuilder();
    }

    public static OrderCompleteBuilder createOrderComplete() {
        return new OrderCompleteBuilder();
    }

    public static ProductAddToWishlistBuilder createProductAddToWishlist() {
        return new ProductAddToWishlistBuilder();
    }

    public static EmailSignUpBuilder createEmailSignUp() {
        return new EmailSignUpBuilder();
    }

    public static SortSelectBuilder createSortSelect() {
        return new SortSelectBuilder();
    }

    public static GetNotifiedClickBuilder createGetNotifiedClick() {
        return new GetNotifiedClickBuilder();
    }

    public static SearchDeleteBuilder createSearchDelete() {
        return new SearchDeleteBuilder();
    }

    public static StyleIconFollowBuilder createStyleIconFollow() {
        return new StyleIconFollowBuilder();
    }

    public static GetRescueBoxClickBuilder createGetRescueBoxClick() {
        return new GetRescueBoxClickBuilder();
    }

    public static GetSimilarProductClickBuilder createGetSimilarProductClick() {
        return new GetSimilarProductClickBuilder();
    }

    public static AnswerBuilder createAnswer() {
        return new AnswerBuilder();
    }

    public static GoodyBoxQuizStepCompletedBuilder createGoodyBoxQuizStepCompleted() {
        return new GoodyBoxQuizStepCompletedBuilder();
    }

    public static GetGoodyBoxClickBuilder createGetGoodyBoxClick() {
        return new GetGoodyBoxClickBuilder();
    }




    public static class GetGoodyBoxClickBuilder extends BaseMessageBuilder {
        GetGoodyBoxClickBuilder() {
            super();
            set("event", "GetGoodyBoxClick");
            setHitTimestamp(System.currentTimeMillis());
        }

        public GetGoodyBoxClickBuilder setBoxID(String gbxid) {
            return (GetGoodyBoxClickBuilder) set("gbxid", gbxid);
        }
    }

    public static class GoodyBoxQuizStepCompletedBuilder extends BaseMessageBuilder {
        GoodyBoxQuizStepCompletedBuilder() {
            super();
            set("event", "GoodyBoxQuizStepCompleted");
            setHitTimestamp(System.currentTimeMillis());
        }

        public GoodyBoxQuizStepCompletedBuilder setQuizID(int quid) {
            return (GoodyBoxQuizStepCompletedBuilder) set("quid", quid);
        }

        public GoodyBoxQuizStepCompletedBuilder addAnswer(AnswerBuilder answer) {
            return (GoodyBoxQuizStepCompletedBuilder) addToArray("answers", answer.build());
        }
    }

    public static class AnswerBuilder extends BaseMessageBuilder {
        public AnswerBuilder setOptionID(int optid) {
            return (AnswerBuilder) set("optid", optid);
        }

        public AnswerBuilder setOptionScale(int optstr) {
            return (AnswerBuilder) set("optstr", optstr);
        }

        public AnswerBuilder setText(String opttxt) {
            return (AnswerBuilder) set("opttxt", opttxt);
        }
    }

    public static class GetSimilarProductClickBuilder extends ProductBuilder {
        GetSimilarProductClickBuilder() {
            super();
            set("event", "GetSimilarProductClick");
            setHitTimestamp(System.currentTimeMillis());
        }
    }

    public static class GetRescueBoxClickBuilder extends BaseMessageBuilder {
        GetRescueBoxClickBuilder() {
            super();
            set("event", "GetRescueBoxClick");
            setHitTimestamp(System.currentTimeMillis());
        }

        public GetRescueBoxClickBuilder setBoxID(String rbxid) {
            return (GetRescueBoxClickBuilder) set("rbxid", rbxid);
        }

        public GetRescueBoxClickBuilder setQuantity(int qty) {
            return (GetRescueBoxClickBuilder) set("qty", qty);
        }

        public GetRescueBoxClickBuilder setPrice(double price) {
            return (GetRescueBoxClickBuilder) set("pr", price);
        }

        public GetRescueBoxClickBuilder setCurrencyCode(String cur) {
            return (GetRescueBoxClickBuilder) set("cur", cur);
        }

        public GetRescueBoxClickBuilder setSize(String sz) {
            return (GetRescueBoxClickBuilder) set("sz", sz);
        }
    }

    public static class StyleIconFollowBuilder extends BaseMessageBuilder {
        StyleIconFollowBuilder() {
            super();
            set("event", "StyleIconFollow");
            setHitTimestamp(System.currentTimeMillis());
        }

        public StyleIconFollowBuilder setStyleIconID(String sicid) {
            return (StyleIconFollowBuilder) set("sicid", sicid);
        }

        public StyleIconFollowBuilder setStyleIconName(String sicnm) {
            return (StyleIconFollowBuilder) set("sicnm", sicnm);
        }

        public StyleIconFollowBuilder addNotify(NotifyBuilder snotify) {
            return (StyleIconFollowBuilder) addToArray("snotify", snotify.build());
        }
    }

    public static class SearchDeleteBuilder extends BaseMessageBuilder {
        SearchDeleteBuilder() {
            super();
            set("event", "SearchDelete");
            setHitTimestamp(System.currentTimeMillis());
        }

        public SearchDeleteBuilder setSearchId(String seid) {
            return (SearchDeleteBuilder) set("seid", seid);
        }
    }

    public static class GetNotifiedClickBuilder extends ProductBuilder {
        GetNotifiedClickBuilder() {
            super();
            set("event", "GetNotifiedClick");
            setHitTimestamp(System.currentTimeMillis());
        }

        public GetNotifiedClickBuilder setProductListingName(String linm) {
            return (GetNotifiedClickBuilder) set("linm", linm);
        }

        public GetNotifiedClickBuilder setRecommendationRequestID(String rtkn) {
            return (GetNotifiedClickBuilder) set("rtkn", rtkn);
        }
    }

    public static class SortSelectBuilder extends BaseMessageBuilder {
        SortSelectBuilder() {
            super();
            set("event", "SortSelect");
            setHitTimestamp(System.currentTimeMillis());
        }

        public SortSelectBuilder setProductCategory(String pcat) {
            return (SortSelectBuilder) set("pcat", pcat);
        }

        public SortSelectBuilder setSortType(String sort) {
            return (SortSelectBuilder) set("sort", sort);
        }
    }

    public static class EmailSignUpBuilder extends BaseMessageBuilder {
        EmailSignUpBuilder() {
            super();
            set("event", "EmailSignUp");
            setHitTimestamp(System.currentTimeMillis());
        }

        public EmailSignUpBuilder setHashedUserEmail(String uem) {
            return (EmailSignUpBuilder) set("uem", uem);
        }

        public EmailSignUpBuilder setUserID(String uid) {
            return (EmailSignUpBuilder) set("uid", uid);
        }
    }

    public static class ProductAddToWishlistBuilder extends ProductBuilder {
        ProductAddToWishlistBuilder() {
            super();
            set("event", "ProductAddToWishlist");
            setHitTimestamp(System.currentTimeMillis());
        }

        public ProductAddToWishlistBuilder setWishlistName(String wlist) {
            return (ProductAddToWishlistBuilder) set("wlist", wlist);
        }

        public ProductAddToWishlistBuilder setProductListingName(String linm) {
            return (ProductAddToWishlistBuilder) set("linm", linm);
        }

        public ProductAddToWishlistBuilder setRecommendationRequestID(String rtkn) {
            return (ProductAddToWishlistBuilder) set("rtkn", rtkn);
        }
    }

    public static class OrderCompleteBuilder extends BaseMessageBuilder {
        OrderCompleteBuilder() {
            super();
            set("event", "OrderComplete");
            setHitTimestamp(System.currentTimeMillis());
        }

        public OrderCompleteBuilder setTransactionID(String tnid) {
            return (OrderCompleteBuilder) set("tnid", tnid);
        }

        public OrderCompleteBuilder setTotalPrice(double total) {
            return (OrderCompleteBuilder) set("total", total);
        }

        public OrderCompleteBuilder setTotalDiscount(double dct) {
            return (OrderCompleteBuilder) set("dct", dct);
        }

        public OrderCompleteBuilder setCheckoutMode(String ckmode) {
            return (OrderCompleteBuilder) set("ckmode", ckmode);
        }

        public OrderCompleteBuilder setRecommendationRequestID(String rtkn) {
            return (OrderCompleteBuilder) set("rtkn", rtkn);
        }

        public OrderCompleteBuilder addProduct(ProductBuilder product) {
            return (OrderCompleteBuilder) addToArray("products", product.build());
        }
    }

    public static class CheckoutInitiateBuilder extends BaseMessageBuilder {
        CheckoutInitiateBuilder() {
            super();
            set("event", "CheckoutInitiate");
            setHitTimestamp(System.currentTimeMillis());
        }

        public CheckoutInitiateBuilder setTransactionID(String tnid) {
            return (CheckoutInitiateBuilder) set("tnid", tnid);
        }

        public CheckoutInitiateBuilder setTotalPrice(double total) {
            return (CheckoutInitiateBuilder) set("total", total);
        }

        public CheckoutInitiateBuilder setTotalDiscount(double dct) {
            return (CheckoutInitiateBuilder) set("dct", dct);
        }

        public CheckoutInitiateBuilder setPromo(String promo) {
            return (CheckoutInitiateBuilder) set("promo", promo);
        }

        public CheckoutInitiateBuilder setRecommendationRequestID(String rtkn) {
            return (CheckoutInitiateBuilder) set("rtkn", rtkn);
        }

        public CheckoutInitiateBuilder setProductListingName(String linm) {
            return (CheckoutInitiateBuilder) set("linm", linm);
        }

        public CheckoutInitiateBuilder addProduct(ProductBuilder product) {
            return (CheckoutInitiateBuilder) addToArray("products", product.build());
        }
    }

    public static class RemoveFromCartBuilder extends ProductBuilder {
        RemoveFromCartBuilder() {
            super();
            set("event", "RemoveFromCart");
            setHitTimestamp(System.currentTimeMillis());
        }
    }

    public static class AddToCartBuilder extends ProductBuilder {
        AddToCartBuilder() {
            super();
            set("event", "AddToCart");
            setHitTimestamp(System.currentTimeMillis());
        }

        public AddToCartBuilder setProductListingName(String linm) {
            return (AddToCartBuilder) set("linm", linm);
        }

        public AddToCartBuilder setRecommendationRequestID(String rtkn) {
            return (AddToCartBuilder) set("rtkn", rtkn);
        }
    }

    public static class ProductViewBuilder extends ProductBuilder {
        ProductViewBuilder() {
            super();
            set("event", "ProductView");
            setHitTimestamp(System.currentTimeMillis());
        }

        public ProductViewBuilder setProductListingName(String linm) {
            return (ProductViewBuilder) set("linm", linm);
        }

        public ProductViewBuilder setRecommendationRequestID(String rtkn) {
            return (ProductViewBuilder) set("rtkn", rtkn);
        }
    }

    public static class ProductClickBuilder extends ProductBuilder {
        ProductClickBuilder() {
            super();
            set("event", "ProductClick");
            setHitTimestamp(System.currentTimeMillis());
        }

        public ProductClickBuilder setProductListingName(String linm) {
            return (ProductClickBuilder) set("linm", linm);
        }

        public ProductClickBuilder setRecommendationRequestID(String rtkn) {
            return (ProductClickBuilder) set("rtkn", rtkn);
        }
    }

    public static class SavedSearchUpdateBuilder extends BaseMessageBuilder {
        SavedSearchUpdateBuilder() {
            super();
            set("event", "SavedSearchUpdate");
            setHitTimestamp(System.currentTimeMillis());
        }

        public SavedSearchUpdateBuilder setSearchName(String ss) {
            return (SavedSearchUpdateBuilder) set("ss", ss);
        }

        public SavedSearchUpdateBuilder addFilterBy(FilterByBuilder filtersby) {
            return (SavedSearchUpdateBuilder) addToArray("filtersby", filtersby.build());
        }

        public SavedSearchUpdateBuilder addNotify(NotifyBuilder snotify) {
            return (SavedSearchUpdateBuilder) addToArray("snotify", snotify.build());
        }
    }

    public static class SaveSearchClickBuilder extends BaseMessageBuilder {
        SaveSearchClickBuilder() {
            super();
            set("event", "SaveSearchClick");
            setHitTimestamp(System.currentTimeMillis());
        }

        public SaveSearchClickBuilder setSearchName(String ssnm) {
            return (SaveSearchClickBuilder) set("ssnm", ssnm);
        }

        public SaveSearchClickBuilder addFilterBy(FilterByBuilder filtersby) {
            return (SaveSearchClickBuilder) addToArray("filtersby", filtersby.build());
        }

        public SaveSearchClickBuilder addNotify(NotifyBuilder snotify) {
            return (SaveSearchClickBuilder) addToArray("snotify", snotify.build());
        }
    }

    public static class NotifyBuilder extends BaseMessageBuilder {
        public NotifyBuilder setType(String snftype) {
            return (NotifyBuilder) set("snftype", snftype);
        }

        public NotifyBuilder setOption(boolean snfval) {
            return (NotifyBuilder) set("snfval", snfval ? "yes" : "no");
        }
    }

    public static class ProductSearchBuilder extends BaseMessageBuilder {
        ProductSearchBuilder() {
            super();
            set("event", "ProductsSearch");
            setHitTimestamp(System.currentTimeMillis());
        }

        public ProductSearchBuilder setQuery(String qry) {
            return (ProductSearchBuilder) set("qry", qry);
        }

        public ProductSearchBuilder addFilterBy(FilterByBuilder filtersby) {
            return (ProductSearchBuilder) addToArray("filtersby", filtersby.build());
        }
    }

    public static class ProductListViewBuilder extends BaseMessageBuilder {
        ProductListViewBuilder() {
            super();
            set("event", "ProductListView");
            setHitTimestamp(System.currentTimeMillis());
        }

        public ProductListViewBuilder setProductCategory(String pcat) {
            return (ProductListViewBuilder) set("pcat", pcat);
        }

        public ProductListViewBuilder addFilterBy(FilterByBuilder filtersby) {
            return (ProductListViewBuilder) addToArray("filtersby", filtersby.build());
        }

        public ProductListViewBuilder addProduct(ProductBuilder product) {
            return (ProductListViewBuilder) addToArray("products", product.build());
        }

        public ProductListViewBuilder setSortType(String sort) {
            return (ProductListViewBuilder) set("sort", sort);
        }

        public ProductListViewBuilder setProductListingName(String linm) {
            return (ProductListViewBuilder) set("linm", linm);
        }

        public ProductListViewBuilder setRecommendationRequestID(String rtkn) {
            return (ProductListViewBuilder) set("rtkn", rtkn);
        }
    }

    public static class ProductBuilder extends BaseMessageBuilder {
        public ProductBuilder setSkuId(String skid) {
            return (ProductBuilder) set("skid", skid);
        }

        public ProductBuilder setVariantId(String varid) {
            return (ProductBuilder) set("varid", varid);
        }

        public ProductBuilder setSize(String sz) {
            return (ProductBuilder) set("sz", sz);
        }

        public ProductBuilder setPrice(double pr) {
            return (ProductBuilder) set("pr", pr);
        }

        public ProductBuilder setSalePrice(double spr) {
            return (ProductBuilder) set("spr", spr);
        }

        public ProductBuilder setCurrencyCode(String cur) {
            return (ProductBuilder) set("cur", cur);
        }

        public ProductBuilder setPromo(String promo) {
            return (ProductBuilder) set("promo", promo);
        }

        public ProductBuilder setAvailabilityStatus(String pavs) {
            return (ProductBuilder) set("pavs", pavs);
        }

        public ProductBuilder setBadgeName(String bdg) {
            return (ProductBuilder) set("bdg", bdg);
        }

        public ProductBuilder setFavoriteCount(int fvct) {
            return (ProductBuilder) set("fvct", fvct);
        }

        public ProductBuilder setPosition(int pos) {
            return (ProductBuilder) set("pos", pos);
        }

        public ProductBuilder setRemainingTime(String rtime) {
            return (ProductBuilder) set("rtime", rtime);
        }

        public ProductBuilder setQuantity(int qty) {
            return (ProductBuilder) set("qty", qty);
        }
    }

    public static class FilterByBuilder extends BaseMessageBuilder {
        public FilterByBuilder setFilterCategory(String fcat) {
            return (FilterByBuilder) set("fcat", fcat);
        }

        public FilterByBuilder addFilterValues(String... fval) {
            if (fval != null) {
                for (String v : fval) {
                    addToArray("fval", v);
                }
            }
            return this;
        }
    }

    public static class BaseMessageBuilder {
        private static final String LOG_TAG = "Lily_AI.datafactory";
        private JSONObject data = new JSONObject();

        BaseMessageBuilder() {}

        public JSONObject build() {
            return data;
        }

        public BaseMessageBuilder set(String key, String value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, double value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, long value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, int value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, boolean value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, JSONObject value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, JSONArray value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder set(String key, Object value) {
            try {
                data.put(key, value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder addToArray(String key, Object value) {
            try {
                JSONArray arr;
                if (data.has(key)) {
                    arr = data.getJSONArray(key);
                } else {
                    arr = new JSONArray();
                    data.put(key, arr);
                }
                arr.put(value);
            } catch (JSONException e) {
                Log.e(LOG_TAG, e.getMessage(), e);
            }
            return this;
        }

        public BaseMessageBuilder setHitTimestamp(long hts) {
            return set("hts", hts);
        }
    }
}
