/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.common;

import ai.lum.common.TryWithResources$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import scala.Serializable;

public final class Serializer$ {
    public static final Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public <A> void serialize(A obj, OutputStream outputStream) {
        TryWithResources$.MODULE$.using(new ObjectOutputStream(outputStream), new Serializable(obj){
            public static final long serialVersionUID = 0L;
            private final Object obj$1;

            public final void apply(ObjectOutputStream oos) {
                oos.writeObject(this.obj$1);
            }
            {
                this.obj$1 = obj$1;
            }
        });
    }

    public <A> void serialize(A obj, File file) {
        TryWithResources$.MODULE$.using(new FileOutputStream(file), new Serializable(obj){
            public static final long serialVersionUID = 0L;
            private final Object obj$2;

            public final void apply(FileOutputStream fos) {
                Serializer$.MODULE$.serialize(this.obj$2, fos);
            }
            {
                this.obj$2 = obj$2;
            }
        });
    }

    public <A> void serialize(A obj, String filename) {
        TryWithResources$.MODULE$.using(new FileOutputStream(filename), new Serializable(obj){
            public static final long serialVersionUID = 0L;
            private final Object obj$4;

            public final void apply(FileOutputStream fos) {
                Serializer$.MODULE$.serialize(this.obj$4, fos);
            }
            {
                this.obj$4 = obj$4;
            }
        });
    }

    public <A> byte[] serialize(A obj) {
        return (byte[])TryWithResources$.MODULE$.using(new ByteArrayOutputStream(), new Serializable(obj){
            public static final long serialVersionUID = 0L;
            private final Object obj$3;

            public final byte[] apply(ByteArrayOutputStream baos) {
                Serializer$.MODULE$.serialize(this.obj$3, baos);
                return baos.toByteArray();
            }
            {
                this.obj$3 = obj$3;
            }
        });
    }

    public <A> A deserialize(InputStream inputStream) {
        return this.deserialize(inputStream, this.getClass().getClassLoader());
    }

    public <A> A deserialize(InputStream inputStream, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new ClassLoaderObjectInputStream(classLoader, inputStream), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final A apply(ClassLoaderObjectInputStream ois) {
                return (A)ois.readObject();
            }
        });
    }

    public <A> A deserialize(File file) {
        return this.deserialize(file, this.getClass().getClassLoader());
    }

    public <A> A deserialize(File file, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new FileInputStream(file), new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader classLoader$3;

            public final A apply(FileInputStream fis) {
                return Serializer$.MODULE$.deserialize(fis, this.classLoader$3);
            }
            {
                this.classLoader$3 = classLoader$3;
            }
        });
    }

    public <A> A deserialize(String filename) {
        return this.deserialize(filename, this.getClass().getClassLoader());
    }

    public <A> A deserialize(String filename, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new FileInputStream(filename), new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader classLoader$2;

            public final A apply(FileInputStream fis) {
                return Serializer$.MODULE$.deserialize(fis, this.classLoader$2);
            }
            {
                this.classLoader$2 = classLoader$2;
            }
        });
    }

    public <A> A deserialize(byte[] bytes) {
        return this.deserialize(bytes, this.getClass().getClassLoader());
    }

    public <A> A deserialize(byte[] bytes, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new ByteArrayInputStream(bytes), new Serializable(classLoader){
            public static final long serialVersionUID = 0L;
            private final ClassLoader classLoader$1;

            public final A apply(ByteArrayInputStream bais) {
                return Serializer$.MODULE$.deserialize(bais, this.classLoader$1);
            }
            {
                this.classLoader$1 = classLoader$1;
            }
        });
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

