/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.common;

import ai.lum.common.TryWithResources$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public final class Serializer$ {
    public static Serializer$ MODULE$;

    static {
        new Serializer$();
    }

    public <A> void serialize(A obj, OutputStream outputStream) {
        TryWithResources$.MODULE$.using(new ObjectOutputStream(outputStream), (Function1 & java.io.Serializable & Serializable)oos -> {
            oos.writeObject(obj);
            return BoxedUnit.UNIT;
        });
    }

    public <A> void serialize(A obj, File file) {
        TryWithResources$.MODULE$.using(new FileOutputStream(file), (Function1 & java.io.Serializable & Serializable)fos -> {
            Serializer$.MODULE$.serialize(obj, fos);
            return BoxedUnit.UNIT;
        });
    }

    public <A> void serialize(A obj, String filename) {
        TryWithResources$.MODULE$.using(new FileOutputStream(filename), (Function1 & java.io.Serializable & Serializable)fos -> {
            Serializer$.MODULE$.serialize(obj, fos);
            return BoxedUnit.UNIT;
        });
    }

    public <A> byte[] serialize(A obj) {
        return (byte[])TryWithResources$.MODULE$.using(new ByteArrayOutputStream(), (Function1 & java.io.Serializable & Serializable)baos -> {
            MODULE$.serialize(obj, (OutputStream)baos);
            return baos.toByteArray();
        });
    }

    public <A> A deserialize(InputStream inputStream) {
        return this.deserialize(inputStream, this.getClass().getClassLoader());
    }

    public <A> A deserialize(InputStream inputStream, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new ClassLoaderObjectInputStream(classLoader, inputStream), (Function1 & java.io.Serializable & Serializable)ois -> ois.readObject());
    }

    public <A> A deserialize(File file) {
        return this.deserialize(file, this.getClass().getClassLoader());
    }

    public <A> A deserialize(File file, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new FileInputStream(file), (Function1 & java.io.Serializable & Serializable)fis -> MODULE$.deserialize((InputStream)fis, classLoader));
    }

    public <A> A deserialize(String filename) {
        return this.deserialize(filename, this.getClass().getClassLoader());
    }

    public <A> A deserialize(String filename, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new FileInputStream(filename), (Function1 & java.io.Serializable & Serializable)fis -> MODULE$.deserialize((InputStream)fis, classLoader));
    }

    public <A> A deserialize(byte[] bytes) {
        return this.deserialize(bytes, this.getClass().getClassLoader());
    }

    public <A> A deserialize(byte[] bytes, ClassLoader classLoader) {
        return (A)TryWithResources$.MODULE$.using(new ByteArrayInputStream(bytes), (Function1 & java.io.Serializable & Serializable)bais -> MODULE$.deserialize((InputStream)bais, classLoader));
    }

    private Serializer$() {
        MODULE$ = this;
    }
}

