/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.componently.utils;

import ai.mantik.componently.utils.SecretReader;
import ai.mantik.componently.utils.UnresolvedSecretException;
import com.typesafe.config.ConfigFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;

public final class SecretReader$ {
    public static SecretReader$ MODULE$;
    private final String PlainPrefix;
    private final String FilePrefix;
    private final String EnvPrefix;

    static {
        new SecretReader$();
    }

    public String PlainPrefix() {
        return this.PlainPrefix;
    }

    public String FilePrefix() {
        return this.FilePrefix;
    }

    public String EnvPrefix() {
        return this.EnvPrefix;
    }

    public SecretReader fixed(String value) {
        return new SecretReader(value){
            private final String value$1;

            public String read() {
                return this.value$1;
            }
            {
                this.value$1 = value$1;
                super("", ConfigFactory.empty());
            }
        };
    }

    public Option<String> readSecretFromString(String value, String configKey) {
        Some some;
        String string = value;
        if (string.startsWith(this.PlainPrefix())) {
            some = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix(this.PlainPrefix()));
        } else if (string.startsWith(this.FilePrefix())) {
            Path path = Paths.get(new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix(this.FilePrefix()), new String[0]);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new UnresolvedSecretException(new StringBuilder(41).append("File ").append(path).append(" is not a regular file, configKey = ").append(configKey).toString());
            }
            byte[] content = Files.readAllBytes(path);
            some = new Some((Object)new String(content, StandardCharsets.UTF_8));
        } else if (string.startsWith(this.EnvPrefix())) {
            String envName = new StringOps(Predef$.MODULE$.augmentString(value)).stripPrefix(this.EnvPrefix());
            String content = System.getenv(envName);
            if (content == null) {
                throw new UnresolvedSecretException(new StringBuilder(54).append("Environment variable ").append(envName).append(" could not be found, configKey = ").append(configKey).toString());
            }
            some = new Some((Object)content);
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private SecretReader$() {
        MODULE$ = this;
        this.PlainPrefix = "plain:";
        this.FilePrefix = "file:";
        this.EnvPrefix = "env:";
    }
}

