/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.componently.rpc;

import akka.util.ByteString;
import akka.util.ByteString$;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public final class RpcConversions$ {
    public static final RpcConversions$ MODULE$ = new RpcConversions$();

    public ByteString decodeByteString(com.google.protobuf.ByteString bs) {
        return ByteString$.MODULE$.fromArrayUnsafe(bs.toByteArray());
    }

    public com.google.protobuf.ByteString encodeByteString(ByteString bs) {
        return (com.google.protobuf.ByteString)bs.asByteBuffers().foldLeft((Object)com.google.protobuf.ByteString.EMPTY, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            com.google.protobuf.ByteString c = (com.google.protobuf.ByteString)tuple2._1();
            ByteBuffer n = (ByteBuffer)tuple2._2();
            com.google.protobuf.ByteString byteString = c.concat(com.google.protobuf.ByteString.copyFrom((ByteBuffer)n));
            return byteString;
        });
    }

    public String encodeOptionalString(Option<String> s) {
        return (String)s.getOrElse((Function0 & Serializable)() -> "");
    }

    public Option<String> decodeOptionalString(String str) {
        return str.isEmpty() ? None$.MODULE$ : new Some((Object)str);
    }

    public Timestamp encodeInstant(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public Instant decodeInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public StatusRuntimeException encodeError(Throwable e, Status.Code code) {
        String description = e.getMessage();
        Status status = code.toStatus().withDescription(description).withCause(e);
        return new StatusRuntimeException(status);
    }

    private RpcConversions$() {
    }
}

