/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.run;

import ai.mantik.ds.DataType;
import ai.mantik.ds.element.Bundle$;
import ai.mantik.ds.element.ValueEncoder$;
import ai.mantik.ds.operations.BinaryFunction;
import ai.mantik.ds.operations.BinaryFunction$;
import ai.mantik.ds.operations.BinaryOperation;
import ai.mantik.ds.sql.Alias;
import ai.mantik.ds.sql.AnonymousInput;
import ai.mantik.ds.sql.ArrayGetExpression;
import ai.mantik.ds.sql.BinaryOperationExpression;
import ai.mantik.ds.sql.CastExpression;
import ai.mantik.ds.sql.ColumnExpression;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.ConstantExpression;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.Join;
import ai.mantik.ds.sql.MultiQuery;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.SelectProjection;
import ai.mantik.ds.sql.SingleQuery;
import ai.mantik.ds.sql.SizeExpression;
import ai.mantik.ds.sql.Split;
import ai.mantik.ds.sql.StructAccessExpression;
import ai.mantik.ds.sql.Union;
import ai.mantik.ds.sql.run.DataSource;
import ai.mantik.ds.sql.run.JoinCompiler$;
import ai.mantik.ds.sql.run.OpCode;
import ai.mantik.ds.sql.run.OpCode$And$;
import ai.mantik.ds.sql.run.OpCode$ArrayGet$;
import ai.mantik.ds.sql.run.OpCode$ArraySize$;
import ai.mantik.ds.sql.run.OpCode$IsNull$;
import ai.mantik.ds.sql.run.OpCode$Neg$;
import ai.mantik.ds.sql.run.OpCode$Or$;
import ai.mantik.ds.sql.run.OpCode$PackNullable$;
import ai.mantik.ds.sql.run.OpCode$Pop$;
import ai.mantik.ds.sql.run.OpCode$ReturnOnFalse$;
import ai.mantik.ds.sql.run.Program;
import ai.mantik.ds.sql.run.Program$;
import ai.mantik.ds.sql.run.SelectProgram;
import ai.mantik.ds.sql.run.SingleTableGeneratorProgram;
import ai.mantik.ds.sql.run.SplitProgram;
import ai.mantik.ds.sql.run.TableGeneratorProgram;
import ai.mantik.ds.sql.run.UnionProgram;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Compiler$ {
    public static Compiler$ MODULE$;

    static {
        new Compiler$();
    }

    public Either<String, SingleTableGeneratorProgram> compile(Query query) {
        Object object;
        block6: {
            Query query2;
            while (true) {
                if ((query2 = query) instanceof AnonymousInput) {
                    AnonymousInput anonymousInput = (AnonymousInput)query2;
                    object = package$.MODULE$.Right().apply((Object)new DataSource(anonymousInput.slot(), query.resultingTabularType()));
                    break block6;
                }
                if (query2 instanceof Select) {
                    Select select = (Select)query2;
                    object = this.compile(select);
                    break block6;
                }
                if (query2 instanceof Union) {
                    Union union = (Union)query2;
                    object = this.compile(union);
                    break block6;
                }
                if (!(query2 instanceof Alias)) break;
                Alias alias = (Alias)query2;
                query = alias.query();
            }
            if (query2 instanceof Join) {
                Join join = (Join)query2;
                object = JoinCompiler$.MODULE$.compile(join);
            } else {
                throw new MatchError((Object)query2);
            }
        }
        return object;
    }

    public Either<String, TableGeneratorProgram> compile(MultiQuery multiQuery) {
        Either either;
        MultiQuery multiQuery2 = multiQuery;
        if (multiQuery2 instanceof SingleQuery) {
            SingleQuery singleQuery = (SingleQuery)multiQuery2;
            either = this.compile(singleQuery.query());
        } else if (multiQuery2 instanceof Split) {
            Split split = (Split)multiQuery2;
            either = this.compile(split.query()).map((Function1 & Serializable & scala.Serializable)underlying -> new SplitProgram((SingleTableGeneratorProgram)underlying, split.fractions(), split.shuffleSeed()));
        } else {
            throw new MatchError((Object)multiQuery2);
        }
        return either;
    }

    public Either<String, SelectProgram> compile(Select select) {
        return this.compile(select.input()).flatMap((Function1 & Serializable & scala.Serializable)input -> MODULE$.compileSelectors(select.selection()).flatMap((Function1 & Serializable & scala.Serializable)selector -> MODULE$.compileProjector(select.projections()).map((Function1 & Serializable & scala.Serializable)projector -> new SelectProgram((Option<SingleTableGeneratorProgram>)new Some(input), (Option<Program>)selector, (Option<Program>)projector, select.resultingTabularType()))));
    }

    public Either<String, UnionProgram> compile(Union union) {
        return ((Either)implicits$.MODULE$.toTraverseOps(union.flat().map((Function1 & Serializable & scala.Serializable)query -> MODULE$.compile((Query)query), Vector$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)compiledInputs -> new UnionProgram((Vector<SingleTableGeneratorProgram>)compiledInputs, union.all(), union.resultingTabularType(), true));
    }

    public Either<String, Option<Program>> compileSelectors(Vector<Condition> selection) {
        if (selection.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        Either maybeSubLists = (Either)implicits$.MODULE$.toTraverseOps(selection.map((Function1 & Serializable & scala.Serializable)condition -> MODULE$.compileCondition((Condition)condition), Vector$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
        return maybeSubLists.map((Function1 & Serializable & scala.Serializable)subLists -> {
            Vector<OpCode> allInOne = MODULE$.combineConditions((Vector<Vector<OpCode>>)subLists);
            return new Some((Object)Program$.MODULE$.fromOps(allInOne));
        });
    }

    private Vector<OpCode> combineConditions(Vector<Vector<OpCode>> subLists) {
        Builder resultBuilder = package$.MODULE$.Vector().newBuilder();
        this.add$1(subLists.toList(), resultBuilder);
        return (Vector)resultBuilder.result();
    }

    public Either<String, Option<Program>> compileProjector(Option<Vector<SelectProjection>> projections) {
        Vector projections2;
        Option<Vector<SelectProjection>> option = projections;
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Vector vector = projections2 = (Vector)some.value();
        Vector usedProjections = vector;
        Either maybeSubLists = (Either)implicits$.MODULE$.toTraverseOps(usedProjections.map((Function1 & Serializable & scala.Serializable)projection -> MODULE$.compileExpression(projection.expression()), Vector$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
        return maybeSubLists.map((Function1 & Serializable & scala.Serializable)projectionOpCodes -> {
            Vector allInOne = (Vector)projectionOpCodes.toVector().flatten((Function1)Predef$.MODULE$.$conforms());
            return new Some((Object)Program$.MODULE$.fromOps((Vector<OpCode>)allInOne));
        });
    }

    public Either<String, Vector<OpCode>> compileCondition(Condition condition) {
        Either either;
        Condition condition2 = condition;
        if (condition2 instanceof Condition.Not) {
            Condition.Not not = (Condition.Not)condition2;
            either = this.compileCondition(not.predicate()).map((Function1 & Serializable & scala.Serializable)base -> (Vector)base.$colon$plus((Object)OpCode$Neg$.MODULE$, Vector$.MODULE$.canBuildFrom()));
        } else if (condition2 instanceof Condition.Equals) {
            Condition.Equals equals = (Condition.Equals)condition2;
            either = this.compileExpression(equals.left()).flatMap((Function1 & Serializable & scala.Serializable)a -> MODULE$.compileExpression(equals.right()).map((Function1 & Serializable & scala.Serializable)b -> (Vector)((Vector)a.$plus$plus((GenTraversableOnce)b, Vector$.MODULE$.canBuildFrom())).$colon$plus((Object)new OpCode.Equals(equals.left().dataType()), Vector$.MODULE$.canBuildFrom())));
        } else if (condition2 instanceof Condition.WrappedExpression) {
            Condition.WrappedExpression wrappedExpression = (Condition.WrappedExpression)condition2;
            either = this.compileExpression(wrappedExpression.expression());
        } else if (condition2 instanceof Condition.And) {
            Condition.And and = (Condition.And)condition2;
            either = this.compileExpression(and.left()).flatMap((Function1 & Serializable & scala.Serializable)a -> MODULE$.compileExpression(and.right()).map((Function1 & Serializable & scala.Serializable)b -> (Vector)((Vector)a.$plus$plus((GenTraversableOnce)b, Vector$.MODULE$.canBuildFrom())).$colon$plus((Object)OpCode$And$.MODULE$, Vector$.MODULE$.canBuildFrom())));
        } else if (condition2 instanceof Condition.Or) {
            Condition.Or or = (Condition.Or)condition2;
            either = this.compileExpression(or.left()).flatMap((Function1 & Serializable & scala.Serializable)a -> MODULE$.compileExpression(or.right()).map((Function1 & Serializable & scala.Serializable)b -> (Vector)((Vector)a.$plus$plus((GenTraversableOnce)b, Vector$.MODULE$.canBuildFrom())).$colon$plus((Object)OpCode$Or$.MODULE$, Vector$.MODULE$.canBuildFrom())));
        } else if (condition2 instanceof Condition.IsNull) {
            Condition.IsNull isNull = (Condition.IsNull)condition2;
            either = this.compileExpression(isNull.expression()).map((Function1 & Serializable & scala.Serializable)base -> (Vector)base.$colon$plus((Object)OpCode$IsNull$.MODULE$, Vector$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)condition2);
        }
        return either;
    }

    public Either<String, Vector<OpCode>> compileExpression(Expression expression) {
        Either<String, Vector<OpCode>> either;
        Expression expression2 = expression;
        if (expression2 instanceof Condition) {
            Condition condition = (Condition)expression2;
            either = this.compileCondition(condition);
        } else if (expression2 instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)expression2;
            either = package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode.Constant[]{new OpCode.Constant(constantExpression.value())})));
        } else if (expression2 instanceof ColumnExpression) {
            ColumnExpression columnExpression = (ColumnExpression)expression2;
            either = package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode.Get[]{new OpCode.Get(columnExpression.columnId())})));
        } else if (expression2 instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression2;
            DataType fromType = castExpression.expression().dataType();
            DataType toType = castExpression.dataType();
            OpCode.Cast castOp = new OpCode.Cast(fromType, toType);
            either = this.compileExpression(castExpression.expression()).map((Function1 & Serializable & scala.Serializable)base -> (Vector)base.$colon$plus((Object)castOp, Vector$.MODULE$.canBuildFrom()));
        } else if (expression2 instanceof BinaryOperationExpression) {
            BinaryOperationExpression binaryOperationExpression = (BinaryOperationExpression)expression2;
            either = this.compileExpression(binaryOperationExpression.left()).flatMap((Function1 & Serializable & scala.Serializable)leftOps -> MODULE$.compileExpression(binaryOperationExpression.right()).flatMap((Function1 & Serializable & scala.Serializable)rightOps -> MODULE$.binaryOperation(binaryOperationExpression.op(), binaryOperationExpression.dataType()).map((Function1 & Serializable & scala.Serializable)op -> (Vector)((Vector)leftOps.$plus$plus((GenTraversableOnce)rightOps, Vector$.MODULE$.canBuildFrom())).$colon$plus(op, Vector$.MODULE$.canBuildFrom()))));
        } else if (expression2 instanceof ArrayGetExpression) {
            ArrayGetExpression arrayGetExpression = (ArrayGetExpression)expression2;
            either = this.compileOperationWithPotentialNullableArguments((Vector<OpCode>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode$ArrayGet$[]{OpCode$ArrayGet$.MODULE$}))), false, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{arrayGetExpression.array(), arrayGetExpression.index()}));
        } else if (expression2 instanceof SizeExpression) {
            SizeExpression sizeExpression = (SizeExpression)expression2;
            either = this.compileOperationWithPotentialNullableArguments((Vector<OpCode>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode$ArraySize$[]{OpCode$ArraySize$.MODULE$}))), true, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{sizeExpression.expression()}));
        } else if (expression2 instanceof StructAccessExpression) {
            Either<String, Vector<OpCode>> either2;
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression2;
            Option<Object> option = structAccessExpression.underlyingStruct().lookupFieldIndex(structAccessExpression.name());
            if (None$.MODULE$.equals(option)) {
                either2 = package$.MODULE$.Left().apply((Object)new StringBuilder(16).append("Field ").append(structAccessExpression.name()).append(" not found").toString());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                int fieldIndex = BoxesRunTime.unboxToInt((Object)some.value());
                boolean needNullWrap = structAccessExpression.expression().dataType().isNullable() && !structAccessExpression.underlyingField().isNullable();
                either2 = this.compileOperationWithPotentialNullableArguments((Vector<OpCode>)((Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode.StructGet[]{new OpCode.StructGet(fieldIndex)}))), needNullWrap, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{structAccessExpression.expression()}));
            } else {
                throw new MatchError(option);
            }
            either = either2;
        } else {
            throw new MatchError((Object)expression2);
        }
        return either;
    }

    private Either<String, Vector<OpCode>> compileOperationWithPotentialNullableArguments(Vector<OpCode> operation, boolean opNeedsPotentialNullWrap, Seq<Expression> arguments) {
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)arguments.map((Function1 & Serializable & scala.Serializable)expression -> MODULE$.compileExpression((Expression)expression), Seq$.MODULE$.canBuildFrom())).toVector(), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)argumentOpCodes -> {
            Seq argumentsNullable = (Seq)arguments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Compiler$.$anonfun$compileOperationWithPotentialNullableArguments$3(x$1)), Seq$.MODULE$.canBuildFrom());
            boolean containsNullable = argumentsNullable.contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Builder resultBuilder = package$.MODULE$.Vector().newBuilder();
            IntRef offset = IntRef.create((int)0);
            if (containsNullable && opNeedsPotentialNullWrap) {
                resultBuilder.$plus$eq((Object)OpCode$PackNullable$.MODULE$);
                ++offset.elem;
            }
            resultBuilder.$plus$plus$eq((TraversableOnce)operation.reverse());
            offset.elem += operation.size();
            ((IterableLike)((SeqLike)((IterableLike)argumentOpCodes.zip((GenIterable)argumentsNullable, Vector$.MODULE$.canBuildFrom())).zipWithIndex(Vector$.MODULE$.canBuildFrom())).reverse()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Compiler$.$anonfun$compileOperationWithPotentialNullableArguments$4(resultBuilder, offset, x0$1);
                return BoxedUnit.UNIT;
            });
            Vector result = (Vector)((SeqLike)resultBuilder.result()).reverse();
            return result;
        });
    }

    private Either<String, OpCode> binaryOperation(BinaryOperation op, DataType dt) {
        Left left;
        Either<String, BinaryFunction> either = BinaryFunction$.MODULE$.findBinaryFunction(op, dt);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            String error = (String)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else if (either instanceof Right) {
            left = package$.MODULE$.Right().apply((Object)new OpCode.BinaryOp(dt, op));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private final void add$1(List pending, Builder resultBuilder$1) {
        block5: {
            List list;
            while (true) {
                boolean bl = false;
                .colon.colon colon2 = null;
                list = pending;
                if (list instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list;
                    Vector last = (Vector)colon2.head();
                    List list2 = colon2.tl$access$1();
                    if (Nil$.MODULE$.equals(list2)) {
                        resultBuilder$1.$plus$plus$eq((TraversableOnce)last);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                }
                if (!bl) break;
                Vector notLast = (Vector)colon2.head();
                List rest = colon2.tl$access$1();
                resultBuilder$1.$plus$plus$eq((TraversableOnce)notLast);
                resultBuilder$1.$plus$plus$eq((TraversableOnce)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode[]{OpCode$ReturnOnFalse$.MODULE$, OpCode$Pop$.MODULE$})));
                pending = rest;
            }
            if (Nil$.MODULE$.equals(list)) {
                resultBuilder$1.$plus$plus$eq((TraversableOnce)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OpCode.Constant[]{new OpCode.Constant(Bundle$.MODULE$.fundamental(BoxesRunTime.boxToBoolean((boolean)true), ValueEncoder$.MODULE$.boolEncoder()))})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)list);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$compileOperationWithPotentialNullableArguments$3(Expression x$1) {
        return x$1.dataType().isNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$compileOperationWithPotentialNullableArguments$4(Builder resultBuilder$2, IntRef offset$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Vector opCodes = (Vector)tuple22._1();
        boolean isNullable = tuple22._2$mcZ$sp();
        if (isNullable) {
            resultBuilder$2.$plus$eq((Object)new OpCode.UnpackNullableJump(offset$1.elem, idx));
            ++offset$1.elem;
        }
        resultBuilder$2.$plus$plus$eq((TraversableOnce)opCodes.reverse());
        offset$1.elem += opCodes.size();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Compiler$() {
        MODULE$ = this;
    }
}

