/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.element;

import ai.mantik.ds.ArrayT;
import ai.mantik.ds.DataType;
import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.Image;
import ai.mantik.ds.Nullable;
import ai.mantik.ds.Struct;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.Tensor;
import ai.mantik.ds.element.ArrayElement;
import ai.mantik.ds.element.Element;
import ai.mantik.ds.element.EmbeddedTabularElement;
import ai.mantik.ds.element.ImageElement;
import ai.mantik.ds.element.NullElement$;
import ai.mantik.ds.element.NullableElement;
import ai.mantik.ds.element.Primitive;
import ai.mantik.ds.element.PrimitiveEncoder;
import ai.mantik.ds.element.PrimitiveEncoder$;
import ai.mantik.ds.element.SomeElement;
import ai.mantik.ds.element.StructElement;
import ai.mantik.ds.element.TabularRow;
import ai.mantik.ds.element.TensorElement;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ElementOrdering$ {
    public static ElementOrdering$ MODULE$;

    static {
        new ElementOrdering$();
    }

    public Ordering<Element> elementOrdering(DataType dataType) {
        Ordering<Element> ordering;
        DataType dataType2 = dataType;
        if (dataType2 instanceof FundamentalType) {
            FundamentalType fundamentalType = (FundamentalType)dataType2;
            ordering = this.castToElement(this.fundamentalOrdering(PrimitiveEncoder$.MODULE$.lookup(fundamentalType)));
        } else if (dataType2 instanceof TabularData) {
            TabularData tabularData = (TabularData)dataType2;
            ordering = this.castToElement(this.embeddedTabularOrdering(tabularData));
        } else if (dataType2 instanceof Image) {
            Image image = (Image)dataType2;
            ordering = this.castToElement(this.imageOrdering(image));
        } else if (dataType2 instanceof Tensor) {
            Tensor tensor = (Tensor)dataType2;
            ordering = this.castToElement(this.tensorOrdering(tensor));
        } else if (dataType2 instanceof Nullable) {
            Nullable nullable = (Nullable)dataType2;
            ordering = this.castToElement(this.nullableOrdering(nullable));
        } else if (dataType2 instanceof ArrayT) {
            ArrayT arrayT = (ArrayT)dataType2;
            ordering = this.castToElement(this.arrayOrdering(arrayT));
        } else if (dataType2 instanceof Struct) {
            Struct struct = (Struct)dataType2;
            ordering = this.castToElement(this.structOrdering(struct));
        } else {
            throw new MatchError((Object)dataType2);
        }
        return ordering;
    }

    private <T extends Element> Ordering<Element> castToElement(Ordering<T> ordering) {
        return ordering.on((Function1 & Serializable & scala.Serializable)x$1 -> x$1);
    }

    public Ordering<TabularRow> tableRowOrdering(TabularData tabularData) {
        return this.tupleOrdering((Iterable<DataType>)tabularData.columns().values()).on((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columns());
    }

    public Ordering<IndexedSeq<Element>> tupleOrdering(Iterable<DataType> dataTypes) {
        Vector subOrderings = ((TraversableOnce)dataTypes.map((Function1 & Serializable & scala.Serializable)dataType -> MODULE$.elementOrdering((DataType)dataType), Iterable$.MODULE$.canBuildFrom())).toVector();
        return new Ordering<IndexedSeq<Element>>(subOrderings){
            private final Vector subOrderings$1;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<IndexedSeq<Element>> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, IndexedSeq<Element>> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(IndexedSeq<Element> x, IndexedSeq<Element> y) {
                return ElementOrdering$.MODULE$.ai$mantik$ds$element$ElementOrdering$$elementWiseCompare(x, y, this.subOrderings$1);
            }
            {
                this.subOrderings$1 = subOrderings$1;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public <T> int ai$mantik$ds$element$ElementOrdering$$elementWiseCompare(Iterable<T> left, Iterable<T> right, Iterable<Ordering<T>> subOrderings) {
        Iterator lit = left.iterator();
        Iterator rit = right.iterator();
        Iterator sit = subOrderings.iterator();
        while (lit.hasNext() && rit.hasNext() && sit.hasNext()) {
            Ordering so = (Ordering)sit.next();
            int subResult = so.compare(lit.next(), rit.next());
            if (subResult == 0) continue;
            return subResult;
        }
        return 0;
    }

    private Ordering<EmbeddedTabularElement> embeddedTabularOrdering(TabularData tabularData) {
        Ordering<TabularRow> rowOrdering = this.tableRowOrdering(tabularData);
        Ordering seqOrdering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Implicits$.MODULE$.seqDerivedOrdering(rowOrdering));
        return seqOrdering.on((Function1 & Serializable & scala.Serializable)x -> x.rows());
    }

    private Ordering<ImageElement> imageOrdering(Image image) {
        Ordering bsOrdering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Implicits$.MODULE$.seqDerivedOrdering((Ordering)Ordering.Byte$.MODULE$));
        return package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ElementOrdering$.$anonfun$imageOrdering$1(bsOrdering, x0$1, x1$1)));
    }

    private Ordering<TensorElement<?>> tensorOrdering(Tensor tensor) {
        PrimitiveEncoder<? extends FundamentalType> pe = PrimitiveEncoder$.MODULE$.lookup(tensor.componentType());
        Ordering<Object> elementOrdering = pe.ordering();
        Ordering indexedSeqOrdering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Implicits$.MODULE$.seqDerivedOrdering(elementOrdering));
        return package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ElementOrdering$.$anonfun$tensorOrdering$1(indexedSeqOrdering, x0$1, x1$1)));
    }

    private Ordering<NullableElement> nullableOrdering(Nullable nullable) {
        Ordering<Element> underlying = this.elementOrdering(nullable.underlying());
        return package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ElementOrdering$.$anonfun$nullableOrdering$1(underlying, x0$1, x1$1)));
    }

    private Ordering<ArrayElement> arrayOrdering(ArrayT list) {
        Ordering<Element> underlying = this.elementOrdering(list.underlying());
        Ordering indexedSeqOrdering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Implicits$.MODULE$.seqDerivedOrdering(underlying));
        return indexedSeqOrdering.on((Function1 & Serializable & scala.Serializable)x$3 -> x$3.elements());
    }

    private Ordering<StructElement> structOrdering(Struct namedTuple) {
        return this.tupleOrdering((Iterable<DataType>)namedTuple.fields().values()).on((Function1 & Serializable & scala.Serializable)x$4 -> x$4.elements());
    }

    private <_> Ordering<Primitive<?>> fundamentalOrdering(PrimitiveEncoder<?> primitiveEncoder) {
        Ordering<Object> po = primitiveEncoder.ordering();
        return package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ElementOrdering$.$anonfun$fundamentalOrdering$1(po, x0$1, x1$1)));
    }

    public static final /* synthetic */ boolean $anonfun$imageOrdering$1(Ordering bsOrdering$1, ImageElement x0$1, ImageElement x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ImageElement left = (ImageElement)tuple2._1();
        ImageElement right = (ImageElement)tuple2._2();
        ByteString leftBytes = left.bytes();
        ByteString rightBytes = right.bytes();
        boolean bl = bsOrdering$1.lt((Object)leftBytes, (Object)rightBytes);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$tensorOrdering$1(Ordering indexedSeqOrdering$1, TensorElement x0$1, TensorElement x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TensorElement left = (TensorElement)tuple2._1();
        TensorElement right = (TensorElement)tuple2._2();
        TensorElement leftTensorElement = left;
        TensorElement rightTensorElement = right;
        boolean bl = indexedSeqOrdering$1.lt(leftTensorElement.elements(), rightTensorElement.elements());
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$nullableOrdering$1(Ordering underlying$1, NullableElement x0$1, NullableElement x1$1) {
        NullableElement nullableElement;
        NullableElement nullableElement2;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            NullableElement nullableElement3 = (NullableElement)tuple2._1();
            NullableElement nullableElement4 = (NullableElement)tuple2._2();
            if (NullElement$.MODULE$.equals(nullableElement3) && NullElement$.MODULE$.equals(nullableElement4)) {
                return false;
            }
        }
        if (tuple2 != null && NullElement$.MODULE$.equals(nullableElement2 = (NullableElement)tuple2._1())) {
            return true;
        }
        if (tuple2 != null && NullElement$.MODULE$.equals(nullableElement = (NullableElement)tuple2._2())) {
            return false;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        NullableElement nullableElement5 = (NullableElement)tuple2._1();
        NullableElement nullableElement6 = (NullableElement)tuple2._2();
        if (!(nullableElement5 instanceof SomeElement)) throw new MatchError((Object)tuple2);
        SomeElement someElement = (SomeElement)nullableElement5;
        Element a = someElement.x();
        if (!(nullableElement6 instanceof SomeElement)) throw new MatchError((Object)tuple2);
        SomeElement someElement2 = (SomeElement)nullableElement6;
        Element b = someElement2.x();
        return underlying$1.lt((Object)a, (Object)b);
    }

    public static final /* synthetic */ boolean $anonfun$fundamentalOrdering$1(Ordering po$1, Primitive x0$1, Primitive x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Primitive l = (Primitive)tuple2._1();
        Primitive r = (Primitive)tuple2._2();
        boolean bl = po$1.lt(l.x(), r.x());
        return bl;
    }

    private ElementOrdering$() {
        MODULE$ = this;
    }
}

