/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.run;

import ai.mantik.ds.DataType;
import ai.mantik.ds.Nullable$;
import ai.mantik.ds.sql.ColumnExpression;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.Condition$;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.ExpressionTransformation$;
import ai.mantik.ds.sql.Join;
import ai.mantik.ds.sql.JoinCondition;
import ai.mantik.ds.sql.JoinCondition$Cross$;
import ai.mantik.ds.sql.JoinType;
import ai.mantik.ds.sql.JoinType$Outer$;
import ai.mantik.ds.sql.QueryColumn;
import ai.mantik.ds.sql.QueryTabularType;
import ai.mantik.ds.sql.builder.CastBuilder$;
import ai.mantik.ds.sql.run.JoinConditionAnalyzer;
import ai.mantik.ds.sql.run.JoinConditionAnalyzer$Analysis$;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BitSet;
import scala.collection.BitSet$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JoinConditionAnalyzer$ {
    public static JoinConditionAnalyzer$ MODULE$;

    static {
        new JoinConditionAnalyzer$();
    }

    public Either<String, JoinConditionAnalyzer.Analysis> analyze(Join join) {
        Either<String, JoinConditionAnalyzer.Analysis> either;
        JoinCondition joinCondition = join.condition();
        if (JoinCondition$Cross$.MODULE$.equals(joinCondition)) {
            either = package$.MODULE$.Right().apply((Object)new JoinConditionAnalyzer.Analysis(JoinConditionAnalyzer$Analysis$.MODULE$.apply$default$1(), JoinConditionAnalyzer$Analysis$.MODULE$.apply$default$2()));
        } else if (joinCondition instanceof JoinCondition.Using) {
            JoinCondition.Using using = (JoinCondition.Using)joinCondition;
            Vector<JoinCondition.UsingColumn> columns = using.columns();
            either = this.analyzeUsing(join, columns);
        } else if (joinCondition instanceof JoinCondition.On) {
            JoinCondition.On on = (JoinCondition.On)joinCondition;
            Condition on2 = on.expression();
            either = this.analyzeOn(join, on2);
        } else {
            throw new MatchError((Object)joinCondition);
        }
        return either;
    }

    private Either<String, JoinConditionAnalyzer.Analysis> analyzeUsing(Join join, Vector<JoinCondition.UsingColumn> columns) {
        return ((Either)implicits$.MODULE$.toTraverseOps(columns.map((Function1 & Serializable & scala.Serializable)column -> {
            JoinType joinType = join.joinType();
            JoinType$Outer$ joinType$Outer$ = JoinType$Outer$.MODULE$;
            boolean forceNullability = !(joinType != null ? !joinType.equals(joinType$Outer$) : joinType$Outer$ != null);
            QueryTabularType qual$1 = join.left().resultingQueryType();
            String x$1 = column.name();
            boolean x$2 = column.caseSensitive();
            boolean x$3 = qual$1.lookupColumn$default$3();
            return qual$1.lookupColumn(x$1, x$2, x$3).flatMap((Function1 & Serializable & scala.Serializable)left -> {
                QueryTabularType qual$2 = join.right().resultingQueryType();
                String x$4 = column.name();
                boolean x$52 = column.caseSensitive();
                boolean x$6 = qual$2.lookupColumn$default$3();
                return qual$2.lookupColumn(x$4, x$52, x$6).map((Function1 & Serializable & scala.Serializable)right -> {
                    ColumnExpression leftExp = new ColumnExpression(left._1$mcI$sp(), ((QueryColumn)left._2()).dataType());
                    ColumnExpression rightExp = new ColumnExpression(right._1$mcI$sp(), ((QueryColumn)right._2()).dataType());
                    return new Tuple3(right, (Object)leftExp, (Object)rightExp);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
                    Tuple3 tuple3 = x$5;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Tuple2 right = (Tuple2)tuple3._1();
                    ColumnExpression leftExp = (ColumnExpression)tuple3._2();
                    ColumnExpression rightExp = (ColumnExpression)tuple3._3();
                    Either either = CastBuilder$.MODULE$.comparisonType(leftExp, rightExp).map((Function1 & Serializable & scala.Serializable)commonType -> {
                        DataType commonTypeMaybeNullable = forceNullability ? Nullable$.MODULE$.makeNullable((DataType)commonType) : commonType;
                        return new Tuple2(commonType, (Object)commonTypeMaybeNullable);
                    }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                        Tuple2 tuple2 = x$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        DataType commonTypeMaybeNullable = (DataType)tuple2._2();
                        Either either = CastBuilder$.MODULE$.wrapType(leftExp, commonTypeMaybeNullable).flatMap((Function1 & Serializable & scala.Serializable)leftCasted -> CastBuilder$.MODULE$.wrapType(rightExp, commonTypeMaybeNullable).map((Function1 & Serializable & scala.Serializable)rightCasted -> new JoinConditionAnalyzer.Comparison(commonTypeMaybeNullable, (Expression)leftCasted, (Expression)rightCasted, (Option<Tuple2<Object, Object>>)new Some((Object)new Tuple2.mcII.sp(left._1$mcI$sp(), right._1$mcI$sp())))));
                        return either;
                    });
                    return either;
                });
            });
        }, Vector$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)triples -> new JoinConditionAnalyzer.Analysis((Vector<JoinConditionAnalyzer.Comparison>)triples, (Option<Condition>)None$.MODULE$));
    }

    public Either<String, JoinConditionAnalyzer.Analysis> analyzeOn(Join join, Condition on) {
        return this.normalForm(on).map((Function1 & Serializable & scala.Serializable)conditions -> {
            None$ none$;
            Vector splitted = (Vector)conditions.map((Function1 & Serializable & scala.Serializable)condition -> {
                Right right;
                Some some;
                Tuple2 tuple2;
                Option<Tuple2<Expression, Expression>> option = MODULE$.extractLeftRightCondition(join, (Condition)condition);
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Expression left = (Expression)tuple2._1();
                    Expression right2 = (Expression)tuple2._2();
                    right = package$.MODULE$.Left().apply((Object)new JoinConditionAnalyzer.Comparison(left.dataType(), left, right2, (Option<Tuple2<Object, Object>>)None$.MODULE$));
                } else if (None$.MODULE$.equals(option)) {
                    right = package$.MODULE$.Right().apply(condition);
                } else {
                    throw new MatchError(option);
                }
                return right;
            }, Vector$.MODULE$.canBuildFrom());
            Vector comparisons = (Vector)splitted.collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Either<JoinConditionAnalyzer.Comparison, Condition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Left) {
                        Left left = (Left)A1;
                        JoinConditionAnalyzer.Comparison x = (JoinConditionAnalyzer.Comparison)left.value();
                        object = x;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Either<JoinConditionAnalyzer.Comparison, Condition> x1) {
                    Either<JoinConditionAnalyzer.Comparison, Condition> either = x1;
                    boolean bl = either instanceof Left;
                    return bl;
                }
            }, Vector$.MODULE$.canBuildFrom());
            Vector filter = (Vector)splitted.collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Either<JoinConditionAnalyzer.Comparison, Condition>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Right) {
                        Right right = (Right)A1;
                        Condition filterCondition = (Condition)right.value();
                        object = filterCondition;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Either<JoinConditionAnalyzer.Comparison, Condition> x2) {
                    Either<JoinConditionAnalyzer.Comparison, Condition> either = x2;
                    boolean bl = either instanceof Right;
                    return bl;
                }
            }, Vector$.MODULE$.canBuildFrom());
            int n = filter.size();
            switch (n) {
                case 0: {
                    none$ = None$.MODULE$;
                    break;
                }
                case 1: {
                    none$ = new Some(filter.head());
                    break;
                }
                default: {
                    none$ = new Some(filter.tail().foldLeft(filter.head(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Condition c = (Condition)tuple2._1();
                        Condition n = (Condition)tuple2._2();
                        Condition.And and = new Condition.And(c, n);
                        return and;
                    }));
                    break;
                }
            }
            None$ combinedFilter = none$;
            return new JoinConditionAnalyzer.Analysis((Vector<JoinConditionAnalyzer.Comparison>)comparisons, (Option<Condition>)combinedFilter);
        });
    }

    private Option<Tuple2<Expression, Expression>> extractLeftRightCondition(Join join, Condition condition) {
        None$ none$;
        int leftSize = join.left().resultingTabularType().columns().size();
        Condition condition2 = condition;
        if (condition2 instanceof Condition.Equals) {
            Condition.Equals equals = (Condition.Equals)condition2;
            Expression leftEq = equals.left();
            Expression rightEq = equals.right();
            BitSet leftEqDependencies = JoinConditionAnalyzer$.dependencies$1(leftEq);
            BitSet rightEqDependencies = JoinConditionAnalyzer$.dependencies$1(rightEq);
            boolean leftEqIsFromLeftQueryOnly = leftEqDependencies.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dependencyId -> JoinConditionAnalyzer$.isFromLeftQuery$1(dependencyId, leftSize));
            boolean leftEqIsFromRightQueryOnly = leftEqDependencies.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x -> !JoinConditionAnalyzer$.isFromLeftQuery$1(x, leftSize));
            boolean rightEqIsFromLeftQueryOnly = rightEqDependencies.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)dependencyId -> JoinConditionAnalyzer$.isFromLeftQuery$1(dependencyId, leftSize));
            boolean rightEqIsFromRightQueryOnly = rightEqDependencies.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x -> !JoinConditionAnalyzer$.isFromLeftQuery$1(x, leftSize));
            none$ = leftEqIsFromLeftQueryOnly && rightEqIsFromRightQueryOnly ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leftEq), (Object)JoinConditionAnalyzer$.translateToRightPerspective$1(rightEq, leftSize))) : (leftEqIsFromRightQueryOnly && rightEqIsFromLeftQueryOnly ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rightEq), (Object)JoinConditionAnalyzer$.translateToRightPerspective$1(leftEq, leftSize))) : None$.MODULE$);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Either<String, Vector<Condition>> normalForm(Condition expression) {
        Either either;
        Condition condition = expression;
        if (condition instanceof Condition.And) {
            Condition.And and = (Condition.And)condition;
            Condition left = and.left();
            Condition right = and.right();
            either = this.normalForm(left).flatMap((Function1 & Serializable & scala.Serializable)leftNf -> MODULE$.normalForm(right).map((Function1 & Serializable & scala.Serializable)rightNf -> (Vector)leftNf.$plus$plus((GenTraversableOnce)rightNf, Vector$.MODULE$.canBuildFrom())));
        } else {
            Condition condition2 = condition;
            Condition condition3 = Condition$.MODULE$.boolValue(true);
            either = !(condition2 != null ? !condition2.equals(condition3) : condition3 != null) ? package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().empty()) : package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{condition})));
        }
        return either;
    }

    private static final BitSet dependencies$1(Expression expression) {
        return ExpressionTransformation$.MODULE$.foldTree(expression, BitSet$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                BitSet current = (BitSet)tuple2._1();
                Expression expression = (Expression)tuple2._2();
                if (expression instanceof ColumnExpression) {
                    ColumnExpression columnExpression = (ColumnExpression)expression;
                    int id = columnExpression.columnId();
                    return (BitSet)current.$plus((Object)BoxesRunTime.boxToInteger((int)id));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            BitSet current = (BitSet)tuple2._1();
            return current;
        });
    }

    private static final boolean isFromLeftQuery$1(int dependencyId, int leftSize$1) {
        return dependencyId < leftSize$1;
    }

    private static final Expression translateToRightPerspective$1(Expression expression, int leftSize$1) {
        return ExpressionTransformation$.MODULE$.deepMap(expression, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression;
            Expression expression2 = x0$1;
            if (expression2 instanceof ColumnExpression) {
                ColumnExpression columnExpression = (ColumnExpression)expression2;
                expression = columnExpression.copy(columnExpression.columnId() - leftSize$1, columnExpression.copy$default$2());
            } else {
                expression = expression2;
            }
            return expression;
        });
    }

    private JoinConditionAnalyzer$() {
        MODULE$ = this;
    }
}

