/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.converter;

import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.FundamentalType$Int8$;
import ai.mantik.ds.FundamentalType$Uint8$;
import ai.mantik.ds.Image;
import ai.mantik.ds.ImageChannel;
import ai.mantik.ds.ImageChannel$Black$;
import ai.mantik.ds.ImageChannel$Blue$;
import ai.mantik.ds.ImageChannel$Green$;
import ai.mantik.ds.ImageChannel$Red$;
import ai.mantik.ds.ImageFormat;
import ai.mantik.ds.ImageFormat$Plain$;
import ai.mantik.ds.element.ImageElement;
import akka.util.ByteIterator;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea!B\n\u0015\u0001Qa\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u000b%\u0002A\u0011\u0001\u0016\t\u000f9\u0002!\u0019!C\u0005_!1\u0001\b\u0001Q\u0001\nABQ!\u000f\u0001\u0005\u0002iBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004O\u0001\u0001\u0006I\u0001\u0011\u0005\t\u001f\u0002A)\u0019!C\u0001u!A\u0001\u000b\u0001EC\u0002\u0013\u0005!\b\u0003\u0005R\u0001!\u0015\r\u0011\"\u0001S\u0011!I\u0006\u0001#b\u0001\n\u0013Q\u0004\"\u0002.\u0001\t\u0013Y\u0006\"\u0002/\u0001\t\u0003i\u0006\"B8\u0001\t\u0013\u0001\b\"\u0002:\u0001\t\u0013\u0019\b\"B;\u0001\t\u00131\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0005Y\u0011UO\u001a4fe\u0016$\u0017*\\1hK\u000e{gN^3si\u0016\u0014(BA\u000b\u0017\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u00181\u0005\u0011Am\u001d\u0006\u00033i\ta!\\1oi&\\'\"A\u000e\u0002\u0005\u0005L7C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u0006)\u0011.\\1hK\u000e\u0001\u0001C\u0001\u0014(\u001b\u00051\u0012B\u0001\u0015\u0017\u0005\u0015IU.Y4f\u0003\u0019a\u0014N\\5u}Q\u00111&\f\t\u0003Y\u0001i\u0011\u0001\u0006\u0005\u0006G\t\u0001\r!J\u0001\u0007Y><w-\u001a:\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u000bMdg\r\u000e6\u000b\u0003U\n1a\u001c:h\u0013\t9$G\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003%\u0019\u0017M\u001c%b]\u0012dW-F\u0001<!\tqB(\u0003\u0002>?\t9!i\\8mK\u0006t\u0017\u0001C2iC:tW\r\\:\u0016\u0003\u0001\u00032!\u0011%L\u001d\t\u0011e\t\u0005\u0002D?5\tAI\u0003\u0002FI\u00051AH]8pizJ!aR\u0010\u0002\rA\u0013X\rZ3g\u0013\tI%JA\u0002TKRT!aR\u0010\u0011\u0005\u0019b\u0015BA'\u0017\u00051IU.Y4f\u0007\"\fgN\\3m\u0003%\u0019\u0007.\u00198oK2\u001c\b%A\u0006jg\nc\u0017mY6P]2L\u0018!C5t%\u001e\u0014wJ\u001c7z\u0003M\u0019\u0018N\\4mK\u000e{W\u000e]8oK:$H+\u001f9f+\u0005\u0019\u0006c\u0001\u0010U-&\u0011Qk\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019:\u0016B\u0001-\u0017\u0005=1UO\u001c3b[\u0016tG/\u00197UsB,\u0017AD2b]\"\u000bg\u000e\u001a7f)f\u0004Xm]\u0001\u0012G\u0006t\u0007*\u00198eY\u0016\u001c\u0005.\u00198oK2\u001cH#A\u001e\u0002\u000f\r|gN^3siR\u0011al\u001a\t\u0003?\u0016l\u0011\u0001\u0019\u0006\u0003G\u0005T!AY2\u0002\u0007\u0005<HOC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019\u0004'!\u0004\"vM\u001a,'/\u001a3J[\u0006<W\rC\u0003i\u001b\u0001\u0007\u0011.A\u0005j[\u0006<W\rR1uCB\u0011!.\\\u0007\u0002W*\u0011ANF\u0001\bK2,W.\u001a8u\u0013\tq7N\u0001\u0007J[\u0006<W-\u00127f[\u0016tG/A\u000bd_:4XM\u001d;He\u0006L8kY1mKVKg\u000e\u001e\u001d\u0015\u0005y\u000b\b\"\u00025\u000f\u0001\u0004I\u0017aD2p]Z,'\u000f\u001e*hEVKg\u000e\u001e\u001d\u0015\u0005y#\b\"\u00025\u0010\u0001\u0004I\u0017A\u00034jY2\u0014\u0016m\u001d;feR\u0019qO_@\u0011\u0005yA\u0018BA= \u0005\u0011)f.\u001b;\t\u000bm\u0004\u0002\u0019\u0001?\u0002\rI\f7\u000f^3s!\tyV0\u0003\u0002\u007fA\nqqK]5uC\ndWMU1ti\u0016\u0014\b\"\u00025\u0011\u0001\u0004I\u0017a\u00054jY2\u0014\u0016m\u001d;fe\u001e\u0013X-_:dC2,G#B<\u0002\u0006\u0005\u001d\u0001\"B>\u0012\u0001\u0004a\b\"\u00025\u0012\u0001\u0004I\u0017!\u00044jY2\u0014\u0016m\u001d;feJ;'\rF\u0003x\u0003\u001b\ty\u0001C\u0003|%\u0001\u0007A\u0010C\u0003i%\u0001\u0007\u0011\u000e")
public class BufferedImageConverter {
    private boolean isBlackOnly;
    private boolean isRgbOnly;
    private Option<FundamentalType> singleComponentType;
    private boolean canHandleTypes;
    private final Image image;
    private final Logger logger;
    private final scala.collection.immutable.Set<ImageChannel> channels;
    private volatile byte bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canHandle() {
        if (this.image.width() <= 0) return false;
        if (this.image.height() <= 1) return false;
        if (!this.canHandleChannels()) return false;
        if (!this.canHandleTypes()) return false;
        ImageFormat imageFormat = this.image.format();
        ImageFormat$Plain$ imageFormat$Plain$ = ImageFormat$Plain$.MODULE$;
        if (imageFormat != null) {
            if (!imageFormat.equals(imageFormat$Plain$)) return false;
            return true;
        }
        if (imageFormat$Plain$ == null) return true;
        return false;
    }

    private scala.collection.immutable.Set<ImageChannel> channels() {
        return this.channels;
    }

    private boolean isBlackOnly$lzycompute() {
        BufferedImageConverter bufferedImageConverter = this;
        synchronized (bufferedImageConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                scala.collection.immutable.Set<ImageChannel> set = this.channels();
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ImageChannel$Black$[]{ImageChannel$Black$.MODULE$}));
                this.isBlackOnly = !(set != null ? !set.equals(object) : object != null);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isBlackOnly;
    }

    public boolean isBlackOnly() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.isBlackOnly$lzycompute() : this.isBlackOnly;
    }

    private boolean isRgbOnly$lzycompute() {
        BufferedImageConverter bufferedImageConverter = this;
        synchronized (bufferedImageConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isRgbOnly = !this.channels().contains((Object)ImageChannel$Black$.MODULE$) && this.channels().nonEmpty() && this.channels().diff((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ImageChannel[]{ImageChannel$Red$.MODULE$, ImageChannel$Green$.MODULE$, ImageChannel$Blue$.MODULE$}))).isEmpty();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isRgbOnly;
    }

    public boolean isRgbOnly() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isRgbOnly$lzycompute() : this.isRgbOnly;
    }

    private Option<FundamentalType> singleComponentType$lzycompute() {
        BufferedImageConverter bufferedImageConverter = this;
        synchronized (bufferedImageConverter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                None$ none$;
                SeqOps seqOps;
                Seq seq = (Seq)((IterableOnceOps)this.image.components().values().map((Function1 & Serializable)x$1 -> x$1.componentType())).toSeq().distinct();
                if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    FundamentalType singleType = (FundamentalType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    none$ = new Some((Object)singleType);
                } else {
                    none$ = None$.MODULE$;
                }
                this.singleComponentType = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.singleComponentType;
    }

    public Option<FundamentalType> singleComponentType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.singleComponentType$lzycompute() : this.singleComponentType;
    }

    /*
     * Unable to fully structure code
     */
    private boolean canHandleTypes$lzycompute() {
        block5: {
            var2_1 = this;
            synchronized (var2_1) {
                if ((byte)(this.bitmap$0 & 8) != 0) break block5;
                var3_2 = false;
                var4_3 = null;
                var5_4 = this.singleComponentType();
                if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
                var3_2 = true;
                var4_3 = (Some)var5_4;
                var6_5 = (FundamentalType)var4_3.value();
                if (FundamentalType$Uint8$.MODULE$.equals(var6_5)) {
                    var1_6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var1_6 = var3_2 != false && FundamentalType$Int8$.MODULE$.equals(var7_7 = (FundamentalType)var4_3.value()) != false;
                }
                this.canHandleTypes = var1_6;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canHandleTypes;
    }

    private boolean canHandleTypes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.canHandleTypes$lzycompute() : this.canHandleTypes;
    }

    private boolean canHandleChannels() {
        return this.isBlackOnly() || this.isRgbOnly();
    }

    public BufferedImage convert(ImageElement imageData) {
        int n;
        long t0 = System.currentTimeMillis();
        Predef$.MODULE$.require(this.canHandle(), (Function0 & Serializable)() -> "This image can't be handled");
        if (this.isBlackOnly() && this.singleComponentType().contains((Object)FundamentalType$Uint8$.MODULE$)) {
            return this.convertGrayScaleUint8(imageData);
        }
        if (this.isRgbOnly()) {
            scala.collection.immutable.Set<ImageChannel> set = this.channels();
            Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{ImageChannel$Red$.MODULE$, ImageChannel$Green$.MODULE$, ImageChannel$Blue$.MODULE$}));
            if (!(set != null ? !set.equals(object) : object != null)) {
                if (this.singleComponentType().contains((Object)FundamentalType$Uint8$.MODULE$) || this.singleComponentType().contains((Object)FundamentalType$Int8$.MODULE$)) {
                    return this.convertRgbUint8(imageData);
                }
            }
        }
        if (this.isRgbOnly()) {
            n = 1;
        } else if (this.isBlackOnly()) {
            n = 10;
        } else {
            throw new IllegalStateException("Cannot convert this channels, call canHandleChannels first");
        }
        int imageType = n;
        BufferedImage result = new BufferedImage(this.image.width(), this.image.height(), imageType);
        WritableRaster raster = result.getRaster();
        this.fillRaster(raster, imageData);
        result.setData(raster);
        long t1 = System.currentTimeMillis();
        this.logger().debug(new StringBuilder(26).append("Converting image ").append(this.image.width()).append("x").append(this.image.height()).append(" took ").append(t1 - t0).append("ms").toString());
        return result;
    }

    private BufferedImage convertGrayScaleUint8(ImageElement imageData) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{8};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.image.width(), this.image.height());
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        imageData.bytes().copyToArray((Object)buffer.getData());
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage convertRgbUint8(ImageElement imageData) {
        void var2_2;
        Predef$.MODULE$.require(imageData.bytes().length() == this.image.width() * this.image.height() * 3, (Function0 & Serializable)() -> "Pixel data length must match");
        BufferedImage result = new BufferedImage(this.image.width(), this.image.height(), 1);
        DataBufferInt buffer = (DataBufferInt)result.getRaster().getDataBuffer();
        int pixelCount = this.image.width() * this.image.height();
        ByteIterator it = imageData.bytes().iterator();
        int[] resultArray = buffer.getData();
        int byte1Shift = this.shiftForByte$1(0);
        int byte2Shift = this.shiftForByte$1(1);
        int byte3Shift = this.shiftForByte$1(2);
        for (int i = 0; i < pixelCount; ++i) {
            int resultPixel;
            byte pixel1 = it.getByte();
            byte pixel2 = it.getByte();
            byte pixel3 = it.getByte();
            resultArray[i] = resultPixel = (pixel1 << byte1Shift) + (pixel2 << byte2Shift) + (pixel3 << byte3Shift);
        }
        return var2_2;
    }

    private void fillRaster(WritableRaster raster, ImageElement imageData) {
        Predef$.MODULE$.require(this.image.width() >= 0);
        Predef$.MODULE$.require(this.image.height() >= 0);
        if (this.isBlackOnly()) {
            this.fillRasterGreyscale(raster, imageData);
        } else if (this.isRgbOnly()) {
            this.fillRasterRgb(raster, imageData);
        } else {
            throw new IllegalStateException("Should not come here");
        }
    }

    private void fillRasterGreyscale(WritableRaster raster, ImageElement imageData) {
        ByteIterator it = imageData.bytes().iterator();
        for (int y = 0; y < this.image.height(); ++y) {
            for (int x = 0; x < this.image.width(); ++x) {
                raster.setPixel(x, y, new int[]{it.getByte()});
            }
        }
    }

    private void fillRasterRgb(WritableRaster raster, ImageElement imageData) {
        int rgbComponentCount = this.image.components().size();
        Seq referenceOrder = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{ImageChannel$Red$.MODULE$, ImageChannel$Green$.MODULE$, ImageChannel$Blue$.MODULE$}));
        int[] componentTranslation = (int[])((IterableOnceOps)this.image.components().keys().map((Function1 & Serializable)channel -> BoxesRunTime.boxToInteger((int)BufferedImageConverter.$anonfun$fillRasterRgb$1(referenceOrder, channel)))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        int[] buffer = new int[3];
        ByteIterator it = imageData.bytes().iterator();
        for (int y = 0; y < this.image.height(); ++y) {
            for (int x = 0; x < this.image.width(); ++x) {
                BufferedImageConverter.fetcher$1(it, rgbComponentCount, buffer, componentTranslation);
                raster.setPixel(x, y, buffer);
            }
        }
    }

    private final int shiftForByte$1(int id) {
        int n;
        ImageChannel channel = (ImageChannel)this.image.components().keysIterator().toSeq().apply(id);
        ImageChannel imageChannel = channel;
        if (ImageChannel$Red$.MODULE$.equals(imageChannel)) {
            n = 16;
        } else if (ImageChannel$Green$.MODULE$.equals(imageChannel)) {
            n = 8;
        } else if (ImageChannel$Blue$.MODULE$.equals(imageChannel)) {
            n = 0;
        } else {
            throw new IllegalStateException(new StringBuilder(19).append("Unexpected channel ").append(channel).toString());
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$fillRasterRgb$1(Seq referenceOrder$1, ImageChannel channel) {
        return BoxesRunTime.unboxToInt((Object)Predef.Ensuring$.MODULE$.ensuring$extension(Predef$.MODULE$.Ensuring((Object)BoxesRunTime.boxToInteger((int)referenceOrder$1.indexOf((Object)channel))), (Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != -1, (Function0 & Serializable)() -> "Unsupported channel"));
    }

    private static final void fetcher$1(ByteIterator iterator, int rgbComponentCount$1, int[] buffer$1, int[] componentTranslation$1) {
        for (int i = 0; i < rgbComponentCount$1; ++i) {
            byte data = iterator.getByte();
            buffer$1[componentTranslation$1[i]] = data;
        }
    }

    public BufferedImageConverter(Image image) {
        this.image = image;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.channels = image.components().keySet();
    }
}

