/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.element;

import ai.mantik.ds.DataType;
import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.FundamentalType$BoolType$;
import ai.mantik.ds.FundamentalType$Float32$;
import ai.mantik.ds.FundamentalType$Float64$;
import ai.mantik.ds.FundamentalType$Int32$;
import ai.mantik.ds.FundamentalType$Int64$;
import ai.mantik.ds.FundamentalType$Int8$;
import ai.mantik.ds.FundamentalType$StringType$;
import ai.mantik.ds.FundamentalType$VoidType$;
import ai.mantik.ds.Nullable;
import ai.mantik.ds.element.Element;
import ai.mantik.ds.element.NullElement$;
import ai.mantik.ds.element.Primitive;
import ai.mantik.ds.element.SomeElement;
import ai.mantik.ds.element.ValueEncoder;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ValueEncoder$ {
    public static final ValueEncoder$ MODULE$ = new ValueEncoder$();
    private static final ValueEncoder<Object> byteEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$Int8$.MODULE$, (Function1 & Serializable)x -> BoxesRunTime.boxToByte((byte)ValueEncoder$.$anonfun$byteEncoder$1(BoxesRunTime.unboxToByte((Object)x))), (Function1 & Serializable)x -> BoxesRunTime.boxToByte((byte)ValueEncoder$.$anonfun$byteEncoder$2(BoxesRunTime.unboxToByte((Object)x))));
    private static final ValueEncoder<Object> shortEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$Int32$.MODULE$, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$1)), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToShort((short)ValueEncoder$.$anonfun$shortEncoder$2(BoxesRunTime.unboxToInt((Object)x$2))));
    private static final ValueEncoder<Object> charEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$Int32$.MODULE$, (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToChar((Object)x$3)), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToCharacter((char)ValueEncoder$.$anonfun$charEncoder$2(BoxesRunTime.unboxToInt((Object)x$4))));
    private static final ValueEncoder<Object> intEncoder = MODULE$.makePrimitiveValueEncoder((FundamentalType)FundamentalType$Int32$.MODULE$, (Function1)(JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))), (Function1)(JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
    private static final ValueEncoder<Object> longEncoder = MODULE$.makePrimitiveValueEncoder((FundamentalType)FundamentalType$Int64$.MODULE$, (Function1)(JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))), (Function1)(JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))));
    private static final ValueEncoder<Object> floatEncoder = MODULE$.makePrimitiveValueEncoder((FundamentalType)FundamentalType$Float32$.MODULE$, (Function1)(JFunction1.mcFF.sp & Serializable)x -> BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToFloat((float)x))), (Function1)(JFunction1.mcFF.sp & Serializable)x -> BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToFloat((float)x))));
    private static final ValueEncoder<Object> doubleEncoder = MODULE$.makePrimitiveValueEncoder((FundamentalType)FundamentalType$Float64$.MODULE$, (Function1)(JFunction1.mcDD.sp & Serializable)x -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToDouble((double)x))), (Function1)(JFunction1.mcDD.sp & Serializable)x -> BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToDouble((double)x))));
    private static final ValueEncoder<Object> boolEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$BoolType$.MODULE$, (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ValueEncoder$.$anonfun$boolEncoder$1(BoxesRunTime.unboxToBoolean((Object)x))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ValueEncoder$.$anonfun$boolEncoder$2(BoxesRunTime.unboxToBoolean((Object)x))));
    private static final ValueEncoder<String> stringEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$StringType$.MODULE$, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x));
    private static final ValueEncoder<BoxedUnit> unitEncoder = MODULE$.makePrimitiveValueEncoder(FundamentalType$VoidType$.MODULE$, (Function1 & Serializable)x -> {
        Predef$.MODULE$.identity((Object)x);
        return BoxedUnit.UNIT;
    }, (Function1 & Serializable)x -> {
        Predef$.MODULE$.identity((Object)x);
        return BoxedUnit.UNIT;
    });

    private <T, ST, FT extends FundamentalType> ValueEncoder<T> makePrimitiveValueEncoder(FT ft, Function1<T, ST> convert, Function1<ST, T> decode) {
        return new ValueEncoder<T>(ft, convert, decode){
            private final FundamentalType ft$1;
            private final Function1 convert$1;
            private final Function1 decode$1;

            public FT dataType() {
                return (FT)this.ft$1;
            }

            public Element wrap(T x) {
                return new Primitive<Object>(this.convert$1.apply(x));
            }

            public T unwrap(Element in) {
                return (T)this.decode$1.apply(((Primitive)in).x());
            }
            {
                this.ft$1 = ft$1;
                this.convert$1 = convert$1;
                this.decode$1 = decode$1;
            }
        };
    }

    public ValueEncoder<Object> byteEncoder() {
        return byteEncoder;
    }

    public ValueEncoder<Object> shortEncoder() {
        return shortEncoder;
    }

    public ValueEncoder<Object> charEncoder() {
        return charEncoder;
    }

    public ValueEncoder<Object> intEncoder() {
        return intEncoder;
    }

    public ValueEncoder<Object> longEncoder() {
        return longEncoder;
    }

    public ValueEncoder<Object> floatEncoder() {
        return floatEncoder;
    }

    public ValueEncoder<Object> doubleEncoder() {
        return doubleEncoder;
    }

    public ValueEncoder<Object> boolEncoder() {
        return boolEncoder;
    }

    public ValueEncoder<String> stringEncoder() {
        return stringEncoder;
    }

    public ValueEncoder<BoxedUnit> unitEncoder() {
        return unitEncoder;
    }

    public <T> ValueEncoder<Option<T>> optionalEncoder(ValueEncoder<T> subEncoder) {
        return new ValueEncoder<Option<T>>(subEncoder){
            private final ValueEncoder subEncoder$1;

            public DataType dataType() {
                return new Nullable(this.subEncoder$1.dataType());
            }

            public Element wrap(Option<T> x) {
                Product product;
                Option<T> option = x;
                if (None$.MODULE$.equals(option)) {
                    product = NullElement$.MODULE$;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Object value = some.value();
                    product = new SomeElement(this.subEncoder$1.wrap(value));
                } else {
                    throw new MatchError(option);
                }
                return product;
            }

            public Option<T> unwrap(Element in) {
                None$ none$;
                Element element = in;
                if (NullElement$.MODULE$.equals(element)) {
                    none$ = None$.MODULE$;
                } else if (element instanceof SomeElement) {
                    SomeElement someElement = (SomeElement)element;
                    Element value = someElement.x();
                    none$ = new Some(this.subEncoder$1.unwrap(value));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(19).append("Unexpected element ").append(in).toString());
                }
                return none$;
            }
            {
                this.subEncoder$1 = subEncoder$1;
            }
        };
    }

    public <T> Element wrap(T x, ValueEncoder<T> evidence$1) {
        return ((ValueEncoder)Predef$.MODULE$.implicitly(evidence$1)).wrap(x);
    }

    public <T> Element apply(T x, ValueEncoder<T> evidence$2) {
        return this.wrap(x, evidence$2);
    }

    public static final /* synthetic */ byte $anonfun$byteEncoder$1(byte x) {
        return BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToByte((byte)x)));
    }

    public static final /* synthetic */ byte $anonfun$byteEncoder$2(byte x) {
        return BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToByte((byte)x)));
    }

    public static final /* synthetic */ short $anonfun$shortEncoder$2(int x$2) {
        return (short)x$2;
    }

    public static final /* synthetic */ char $anonfun$charEncoder$2(int x$4) {
        return (char)x$4;
    }

    public static final /* synthetic */ boolean $anonfun$boolEncoder$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ boolean $anonfun$boolEncoder$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private ValueEncoder$() {
    }
}

