/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.formats;

import ai.mantik.ds.DataType;
import ai.mantik.ds.Errors;
import ai.mantik.ds.element.RootElement;
import ai.mantik.ds.formats.StreamCodec;
import ai.mantik.ds.formats.StreamCodec$MimeJson$;
import ai.mantik.ds.formats.StreamCodec$MimeMantikBundle$;
import ai.mantik.ds.formats.StreamCodec$MimeMantikBundleJson$;
import ai.mantik.ds.formats.StreamCodec$MimeMsgPack$;
import ai.mantik.ds.formats.json.JsonFormat$;
import ai.mantik.ds.formats.messagepack.MessagePackReaderWriter;
import akka.stream.scaladsl.Flow;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StreamCodec$ {
    public static final StreamCodec$ MODULE$ = new StreamCodec$();
    private static final Seq<StreamCodec.CodecMimeType> MimeTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamCodec.CodecMimeType[]{StreamCodec$MimeJson$.MODULE$, StreamCodec$MimeMantikBundleJson$.MODULE$, StreamCodec$MimeMsgPack$.MODULE$, StreamCodec$MimeMantikBundle$.MODULE$}));

    public Seq<StreamCodec.CodecMimeType> MimeTypes() {
        return MimeTypes;
    }

    public Flow<RootElement, ByteString, ?> encoder(DataType dataType, StreamCodec.CodecMimeType mimeType) {
        Flow<RootElement, ByteString, ?> flow;
        StreamCodec.CodecMimeType codecMimeType = mimeType;
        if (StreamCodec$MimeJson$.MODULE$.equals(codecMimeType)) {
            flow = JsonFormat$.MODULE$.createStreamRootElementEncoder(dataType);
        } else if (StreamCodec$MimeMantikBundleJson$.MODULE$.equals(codecMimeType)) {
            flow = JsonFormat$.MODULE$.createStreamRootElementEncoderWithHeader(dataType);
        } else if (StreamCodec$MimeMsgPack$.MODULE$.equals(codecMimeType)) {
            flow = new MessagePackReaderWriter(dataType, false).encoder();
        } else if (StreamCodec$MimeMantikBundle$.MODULE$.equals(codecMimeType)) {
            flow = new MessagePackReaderWriter(dataType, true).encoder();
        } else {
            throw new MatchError((Object)codecMimeType);
        }
        return flow;
    }

    public Flow<RootElement, ByteString, ?> encoder(DataType dataType, String contentType) throws Errors.FormatNotSupportedException {
        return this.encoder(dataType, this.findMimeType(contentType));
    }

    public Flow<ByteString, RootElement, ?> decoder(DataType dataType, StreamCodec.CodecMimeType mimeType) {
        Flow<ByteString, RootElement, ?> flow;
        StreamCodec.CodecMimeType codecMimeType = mimeType;
        if (StreamCodec$MimeJson$.MODULE$.equals(codecMimeType)) {
            flow = JsonFormat$.MODULE$.createStreamRootElementDecoder(dataType);
        } else if (StreamCodec$MimeMantikBundleJson$.MODULE$.equals(codecMimeType)) {
            flow = JsonFormat$.MODULE$.createStreamRootElementDecoderWithHeader(dataType);
        } else if (StreamCodec$MimeMsgPack$.MODULE$.equals(codecMimeType)) {
            flow = new MessagePackReaderWriter(dataType, false).decoder();
        } else if (StreamCodec$MimeMantikBundle$.MODULE$.equals(codecMimeType)) {
            flow = new MessagePackReaderWriter(dataType, true).decoder();
        } else {
            throw new MatchError((Object)codecMimeType);
        }
        return flow;
    }

    public Flow<ByteString, RootElement, ?> decoder(DataType dataType, String contentType) throws Errors.FormatNotSupportedException {
        return this.decoder(dataType, this.findMimeType(contentType));
    }

    private StreamCodec.CodecMimeType findMimeType(String contentType) throws Errors.FormatNotSupportedException {
        return (StreamCodec.CodecMimeType)this.MimeTypes().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamCodec$.$anonfun$findMimeType$1(contentType, x$1))).getOrElse((Function0 & Serializable)() -> {
            throw new Errors.FormatNotSupportedException(new StringBuilder(21).append("Format ").append(contentType).append(" not supported").toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$findMimeType$1(String contentType$1, StreamCodec.CodecMimeType x$1) {
        String string = x$1.name();
        String string2 = contentType$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private StreamCodec$() {
    }
}

