/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.helper;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ZipUtils$ {
    public static final ZipUtils$ MODULE$ = new ZipUtils$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public Source<ByteString, Future<BoxedUnit>> zipDirectory(Path directory, FiniteDuration timeout, ExecutionContext ec) {
        Source outputStream2 = StreamConverters$.MODULE$.asOutputStream(timeout);
        return outputStream2.mapMaterializedValue((Function1 & Serializable)outputStream -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.zipDirectory(directory, (OutputStream)outputStream), ec));
    }

    public void zipDirectory(Path directory, Path zipFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile.toFile());){
            this.zipDirectory(directory, fileOutputStream);
        }
    }

    private void zipDirectory(Path directory, OutputStream outputStream) {
        File directoryFile = directory.toFile();
        if (!directoryFile.isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(19).append(directory).append(" is not a directory").toString());
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])directoryFile.listFiles()), (Function1 & Serializable)file -> {
                this.addFile$1(file, file.getName(), zipOutputStream);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Future<BoxedUnit> unzip(Source<ByteString, ?> input, Path targetDirectory, FiniteDuration readTimeout, Materializer materializer) {
        Sink converter = StreamConverters$.MODULE$.asInputStream(readTimeout);
        InputStream inputStream = (InputStream)input.runWith((Graph)converter, materializer);
        ExecutionContextExecutor ec = materializer.executionContext();
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unzip(inputStream, targetDirectory), (ExecutionContext)ec);
    }

    public void unzip(Path file, Path targetDirectory) {
        FileInputStream fileInputStream = new FileInputStream(file.toFile());
        this.unzip(fileInputStream, targetDirectory);
    }

    private void unzip(InputStream inputStream, Path targetDirectory) {
        File targetDirectoryFile = targetDirectory.toFile();
        if (!(targetDirectoryFile.isDirectory() || Option$.MODULE$.apply((Object)targetDirectoryFile.getParentFile()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())) && targetDirectoryFile.mkdir())) {
            throw new IOException("Target directory does not exit, or could not be created");
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry entry = null;
        while ((entry = zipInputStream.getNextEntry()) != null) {
            this.unzipSingleEntry(zipInputStream, entry, targetDirectory);
        }
    }

    private void unzipSingleEntry(ZipInputStream zipInputStream, ZipEntry zipEntry, Path targetDirectory) {
        Path targetPath = targetDirectory.resolve(zipEntry.getName()).normalize();
        if (!targetPath.startsWith(targetDirectory)) {
            this.logger().warn(new StringBuilder(47).append("Skipping ").append(targetPath).append(", as it's not inside target directory ").append(targetDirectory).toString());
        } else {
            File targetFile = targetPath.toFile();
            if (zipEntry.isDirectory()) {
                targetFile.mkdirs();
            } else {
                Option$.MODULE$.apply((Object)targetFile.getParentFile()).foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.mkdir()));
                try (FileOutputStream targetOutputStream = new FileOutputStream(targetFile);){
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)targetOutputStream);
                }
            }
        }
    }

    private final void addFile$1(File file, String name, ZipOutputStream zipOutputStream$1) {
        if (file.isHidden()) {
            this.logger().debug(new StringBuilder(22).append("Ignoring ").append(file).append(", it's hidden").toString());
            return;
        }
        if (file.isDirectory()) {
            String nameToAdd = name.endsWith("/") ? name : new StringBuilder(1).append(name).append("/").toString();
            zipOutputStream$1.putNextEntry(new ZipEntry(nameToAdd));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)subFile -> {
                this.addFile$1(subFile, new StringBuilder(1).append(name).append("/").append(subFile.getName()).toString(), zipOutputStream$1);
                return BoxedUnit.UNIT;
            });
        } else {
            zipOutputStream$1.putNextEntry(new ZipEntry(name));
            try (FileInputStream inputStream = new FileInputStream(file);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream$1);
            }
        }
    }

    private ZipUtils$() {
    }
}

