/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql;

import ai.mantik.ds.sql.Alias;
import ai.mantik.ds.sql.AnonymousInput;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.Join;
import ai.mantik.ds.sql.JoinCondition;
import ai.mantik.ds.sql.JoinCondition$Cross$;
import ai.mantik.ds.sql.MultiQuery;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.SelectProjection;
import ai.mantik.ds.sql.SingleQuery;
import ai.mantik.ds.sql.Split;
import ai.mantik.ds.sql.SqlFormatter;
import ai.mantik.ds.sql.Union;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SqlFormatter$ {
    public static final SqlFormatter$ MODULE$ = new SqlFormatter$();

    public String formatSql(MultiQuery query) {
        String string;
        MultiQuery multiQuery = query;
        if (multiQuery instanceof SingleQuery) {
            SingleQuery singleQuery = (SingleQuery)multiQuery;
            Query query2 = singleQuery.query();
            string = this.formatSql(query2);
        } else if (multiQuery instanceof Split) {
            String string2;
            Split split = (Split)multiQuery;
            String fractions = split.fractions().mkString(",");
            String inner = new StringBuilder(2).append("(").append(this.formatSql(split.query())).append(")").toString();
            Option<Object> option = split.shuffleSeed();
            if (option instanceof Some) {
                Some some = (Some)option;
                long seed = BoxesRunTime.unboxToLong((Object)some.value());
                string2 = this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"WITH", "SHUFFLE", Long.toString(seed)}));
            } else if (None$.MODULE$.equals(option)) {
                string2 = "";
            } else {
                throw new MatchError(option);
            }
            String shuffle = string2;
            string = this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SPLIT", inner, "AT", fractions, shuffle}));
        } else {
            throw new MatchError((Object)multiQuery);
        }
        return string;
    }

    public String formatSql(Query query) {
        String string;
        Query query2 = query;
        if (query2 instanceof AnonymousInput) {
            AnonymousInput anonymousInput = (AnonymousInput)query2;
            int slot = anonymousInput.slot();
            string = new StringBuilder(1).append("$").append(String.valueOf(BoxesRunTime.boxToInteger((int)slot))).toString();
        } else if (query2 instanceof Select) {
            Select select = (Select)query2;
            string = this.formatSelect(select);
        } else if (query2 instanceof Union) {
            Union union = (Union)query2;
            string = this.formatUnion(union);
        } else if (query2 instanceof Join) {
            Join join = (Join)query2;
            string = this.formatJoin(join);
        } else if (query2 instanceof Alias) {
            Alias alias = (Alias)query2;
            string = this.formatAlias(alias);
        } else {
            throw new MatchError((Object)query2);
        }
        return string;
    }

    public String formatSelect(Select select) {
        SeqOps seqOps;
        String string;
        String string2;
        SqlFormatter formatter = new SqlFormatter(select.input().resultingQueryType());
        Option<Vector<SelectProjection>> option = select.projections();
        if (None$.MODULE$.equals(option)) {
            string2 = "*";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Vector values = (Vector)some.value();
            string2 = ((IterableOnceOps)values.map((Function1 & Serializable)projection -> formatter.formatSelectProjection((SelectProjection)projection))).mkString(", ");
        } else {
            throw new MatchError(option);
        }
        String projectionString = string2;
        Vector<Condition> vector = select.selection();
        if (vector.isEmpty()) {
            string = "";
        } else if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq(vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            Condition singleValue = (Condition)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            string = new StringBuilder(6).append("WHERE ").append(formatter.formatExpression(singleValue)).toString();
        } else {
            Vector parts = (Vector)vector.map((Function1 & Serializable)x -> new StringBuilder(2).append("(").append(formatter.formatExpression((Expression)x)).append(")").toString());
            string = new StringBuilder(6).append("WHERE ").append(parts.mkString("AND")).toString();
        }
        String selectionString = string;
        Query query = select.input();
        String string3 = query instanceof AnonymousInput ? this.formatSql(select.input()) : new StringBuilder(2).append("(").append(this.formatSql(query)).append(")").toString();
        String fromQuery = string3;
        return this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT", projectionString, "FROM", fromQuery, selectionString}));
    }

    public String formatUnion(Union union) {
        String left = this.formatSql(union.left());
        String right = this.formatSql(union.right());
        String all = this.formatOptional(union.all(), "ALL");
        return this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{left, "UNION", all, right}));
    }

    private String formatOptional(boolean v, String s) {
        return v ? s : "";
    }

    private String joinWithWhitespace(Seq<String> s) {
        return ((IterableOnceOps)s.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1))))).mkString(" ");
    }

    public String formatJoin(Join join) {
        String string;
        String left = this.formatSql(join.left());
        String right = this.formatSql(join.right());
        JoinCondition joinCondition = join.condition();
        JoinCondition$Cross$ joinCondition$Cross$ = JoinCondition$Cross$.MODULE$;
        if (!(joinCondition != null ? !joinCondition.equals(joinCondition$Cross$) : joinCondition$Cross$ != null)) {
            return this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{left, "CROSS", join.joinType().sqlName(), right}));
        }
        JoinCondition joinCondition2 = join.condition();
        if (JoinCondition$Cross$.MODULE$.equals(joinCondition2)) {
            string = "";
        } else if (joinCondition2 instanceof JoinCondition.On) {
            JoinCondition.On on = (JoinCondition.On)joinCondition2;
            Condition condition = on.expression();
            SqlFormatter formatter = new SqlFormatter(join.innerType());
            string = this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ON", formatter.formatExpression(condition)}));
        } else if (joinCondition2 instanceof JoinCondition.Using) {
            JoinCondition.Using using = (JoinCondition.Using)joinCondition2;
            Vector<JoinCondition.UsingColumn> columns = using.columns();
            String formattedColumns = ((IterableOnceOps)columns.map((Function1 & Serializable)column -> column.caseSensitive() ? new StringBuilder(2).append("\"").append(column.name()).append("\"").toString() : column.name())).mkString(", ");
            string = this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"USING", formattedColumns}));
        } else {
            throw new MatchError((Object)joinCondition2);
        }
        String condition = string;
        return this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{left, join.joinType().sqlName(), "JOIN", right, condition}));
    }

    public String formatAlias(Alias alias) {
        return this.joinWithWhitespace((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.formatSql(alias.query()), "AS", alias.name()}));
    }

    private SqlFormatter$() {
    }
}

