/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.builder;

import ai.mantik.ds.DataType;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.sql.AnonymousInput;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.Join;
import ai.mantik.ds.sql.JoinCondition;
import ai.mantik.ds.sql.JoinCondition$Cross$;
import ai.mantik.ds.sql.JoinType;
import ai.mantik.ds.sql.JoinType$Inner$;
import ai.mantik.ds.sql.JoinType$Left$;
import ai.mantik.ds.sql.JoinType$Outer$;
import ai.mantik.ds.sql.JoinType$Right$;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.QueryTabularType;
import ai.mantik.ds.sql.SqlContext;
import ai.mantik.ds.sql.SqlFormatter;
import ai.mantik.ds.sql.builder.CastBuilder$;
import ai.mantik.ds.sql.builder.ExpressionBuilder$;
import ai.mantik.ds.sql.builder.QueryBuilder$;
import ai.mantik.ds.sql.parser.AST;
import ai.mantik.ds.sql.parser.AST$IdentifierNode$;
import ai.mantik.ds.sql.parser.AST$JoinCondition$Cross$;
import ai.mantik.ds.sql.parser.AST$JoinType$Inner$;
import ai.mantik.ds.sql.parser.AST$JoinType$Left$;
import ai.mantik.ds.sql.parser.AST$JoinType$Outer$;
import ai.mantik.ds.sql.parser.AST$JoinType$Right$;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

public final class JoinBuilder$ {
    public static final JoinBuilder$ MODULE$ = new JoinBuilder$();

    public Either<String, Join> buildJoinFromParsed(AST.JoinNode parsed, SqlContext sqlContext) {
        return QueryBuilder$.MODULE$.buildQueryFromParsed(parsed.left(), sqlContext).flatMap((Function1 & Serializable)leftQuery -> QueryBuilder$.MODULE$.buildQueryFromParsed(parsed.right(), sqlContext).map((Function1 & Serializable)rightQuery -> {
            JoinType joinType = MODULE$.convertJoinType(parsed.joinType());
            QueryTabularType innerModel = MODULE$.innerTabularData((Query)leftQuery, (Query)rightQuery, joinType);
            return new Tuple3(rightQuery, (Object)joinType, (Object)innerModel);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Query rightQuery = (Query)tuple3._1();
            JoinType joinType = (JoinType)tuple3._2();
            QueryTabularType innerModel = (QueryTabularType)tuple3._3();
            Either either = MODULE$.buildJoinCondition((Query)leftQuery, rightQuery, joinType, innerModel, parsed.condition()).map((Function1 & Serializable)condition -> new Join((Query)leftQuery, rightQuery, joinType, (JoinCondition)condition));
            return either;
        }));
    }

    public Either<String, Join> buildAnonymousUsing(TabularData left, TabularData right, Seq<String> using, JoinType joinType) {
        AST.JoinCondition.Using condition2 = new AST.JoinCondition.Using((Vector<AST.IdentifierNode>)((IterableOnceOps)using.map((Function1 & Serializable)name -> new AST.IdentifierNode((String)name, AST$IdentifierNode$.MODULE$.apply$default$2()))).toVector());
        AnonymousInput leftQuery = new AnonymousInput(left, 0);
        AnonymousInput rightQuery = new AnonymousInput(right, 1);
        return this.buildUsingCondition(leftQuery, rightQuery, joinType, condition2).map((Function1 & Serializable)condition -> new Join(leftQuery, rightQuery, joinType, (JoinCondition)condition));
    }

    private JoinType convertJoinType(AST.JoinType joinType) {
        JoinType joinType2;
        AST.JoinType joinType3 = joinType;
        if (AST$JoinType$Inner$.MODULE$.equals(joinType3)) {
            joinType2 = JoinType$Inner$.MODULE$;
        } else if (AST$JoinType$Left$.MODULE$.equals(joinType3)) {
            joinType2 = JoinType$Left$.MODULE$;
        } else if (AST$JoinType$Right$.MODULE$.equals(joinType3)) {
            joinType2 = JoinType$Right$.MODULE$;
        } else if (AST$JoinType$Outer$.MODULE$.equals(joinType3)) {
            joinType2 = JoinType$Outer$.MODULE$;
        } else {
            throw new MatchError((Object)joinType3);
        }
        return joinType2;
    }

    /*
     * Unable to fully structure code
     */
    public QueryTabularType innerTabularData(Query left, Query right, JoinType joinType) {
        v0 = joinType;
        var5_4 = JoinType$Right$.MODULE$;
        if (!(v0 == null ? var5_4 != null : v0.equals(var5_4) == false)) ** GOTO lbl-1000
        v1 = joinType;
        var6_5 = JoinType$Outer$.MODULE$;
        if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) lbl-1000:
        // 2 sources

        {
            v2 = left.resultingQueryType().makeNullable();
        } else {
            v2 = left.resultingQueryType();
        }
        leftMaybeNullable = v2;
        v3 = joinType;
        var8_7 = JoinType$Left$.MODULE$;
        if (!(v3 == null ? var8_7 != null : v3.equals(var8_7) == false)) ** GOTO lbl-1000
        v4 = joinType;
        var9_8 = JoinType$Outer$.MODULE$;
        if (!(v4 != null ? v4.equals(var9_8) == false : var9_8 != null)) lbl-1000:
        // 2 sources

        {
            v5 = right.resultingQueryType().makeNullable();
        } else {
            v5 = right.resultingQueryType();
        }
        rightMaybeNullable = v5;
        combined = leftMaybeNullable.$plus$plus(rightMaybeNullable);
        v6 = joinType;
        var12_11 = JoinType$Right$.MODULE$;
        shadowed = !(v6 != null ? v6.equals(var12_11) == false : var12_11 != null) ? combined.shadow(false, combined.shadow$default$2()) : combined.shadow(true, combined.shadow$default$2());
        return shadowed;
    }

    private Either<String, JoinCondition> buildJoinCondition(Query left, Query right, JoinType joinType, QueryTabularType innerModel, AST.JoinCondition condition) {
        Object object;
        AST.JoinCondition joinCondition = condition;
        if (AST$JoinCondition$Cross$.MODULE$.equals(joinCondition)) {
            object = package$.MODULE$.Right().apply((Object)JoinCondition$Cross$.MODULE$);
        } else if (joinCondition instanceof AST.JoinCondition.On) {
            AST.JoinCondition.On on = (AST.JoinCondition.On)joinCondition;
            object = this.buildOnCondition(innerModel, on);
        } else if (joinCondition instanceof AST.JoinCondition.Using) {
            AST.JoinCondition.Using using = (AST.JoinCondition.Using)joinCondition;
            object = this.buildUsingCondition(left, right, joinType, using);
        } else {
            throw new MatchError((Object)joinCondition);
        }
        return object;
    }

    private Either<String, JoinCondition.On> buildOnCondition(QueryTabularType innerModel, AST.JoinCondition.On condition) {
        return ExpressionBuilder$.MODULE$.convertExpression(innerModel, condition.expression()).flatMap((Function1 & Serializable)expression -> MODULE$.extractCondition((Expression)expression, innerModel).map((Function1 & Serializable)asCondition -> new JoinCondition.On((Condition)asCondition)));
    }

    private Either<String, JoinCondition.Using> buildUsingCondition(Query left, Query right, JoinType joinType, AST.JoinCondition.Using condition) {
        return ((Either)implicits$.MODULE$.toTraverseOps(condition.columns().map((Function1 & Serializable)identifierNode -> ExpressionBuilder$.MODULE$.findColumnByIdentifier(left.resultingQueryType(), (AST.IdentifierNode)identifierNode).map((Function1 & Serializable)leftLookup -> {
            int leftId = leftLookup._1$mcI$sp();
            DataType leftDataType = (DataType)leftLookup._2();
            return new Tuple3(leftLookup, (Object)BoxesRunTime.boxToInteger((int)leftId), (Object)leftDataType);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple3 tuple3 = x$3;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int leftId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            DataType leftDataType = (DataType)tuple3._3();
            Either either = ExpressionBuilder$.MODULE$.findColumnByIdentifier(right.resultingQueryType(), (AST.IdentifierNode)identifierNode).map((Function1 & Serializable)rightLookup -> {
                int rightId = rightLookup._1$mcI$sp();
                DataType rightDataType = (DataType)rightLookup._2();
                return new Tuple3(rightLookup, (Object)BoxesRunTime.boxToInteger((int)rightId), (Object)rightDataType);
            }).flatMap((Function1 & Serializable)x$2 -> {
                Tuple3 tuple3 = x$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int rightId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                DataType rightDataType = (DataType)tuple3._3();
                Either either = CastBuilder$.MODULE$.comparisonType(leftDataType, rightDataType).map((Function1 & Serializable)comparisonType -> {
                    JoinType joinType = joinType;
                    JoinType$Right$ joinType$Right$ = JoinType$Right$.MODULE$;
                    int dropId = !(joinType != null ? !joinType.equals(joinType$Right$) : joinType$Right$ != null) ? leftId : rightId + left.resultingQueryType().columns().size();
                    return new JoinCondition.UsingColumn(identifierNode.name(), !identifierNode.ignoreCase(), leftId, rightId, dropId, (DataType)comparisonType);
                });
                return either;
            });
            return either;
        })), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)columns -> new JoinCondition.Using((Vector<JoinCondition.UsingColumn>)columns));
    }

    private Either<String, Condition> extractCondition(Expression expression, QueryTabularType innerModel) {
        Right right;
        Option<Condition> option = expression.asCondition();
        if (option instanceof Some) {
            Some some = (Some)option;
            Condition c = (Condition)some.value();
            right = package$.MODULE$.Right().apply((Object)c);
        } else if (None$.MODULE$.equals(option)) {
            String formatted = new SqlFormatter(innerModel).formatExpression(expression);
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(24).append("Expected condition, got ").append(formatted).toString());
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    private JoinBuilder$() {
    }
}

