/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.converter.casthelper;

import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.FundamentalType$Float32$;
import ai.mantik.ds.FundamentalType$Float64$;
import ai.mantik.ds.FundamentalType$Int32$;
import ai.mantik.ds.FundamentalType$Int64$;
import ai.mantik.ds.FundamentalType$Int8$;
import ai.mantik.ds.FundamentalType$Uint32$;
import ai.mantik.ds.FundamentalType$Uint64$;
import ai.mantik.ds.FundamentalType$Uint8$;
import ai.mantik.ds.Image;
import ai.mantik.ds.ImageComponent;
import ai.mantik.ds.ImageFormat;
import ai.mantik.ds.ImageFormat$Plain$;
import ai.mantik.ds.element.ImageElement;
import ai.mantik.ds.element.Primitive;
import ai.mantik.ds.element.Primitive$mcD$sp;
import ai.mantik.ds.element.Primitive$mcF$sp;
import ai.mantik.ds.element.Primitive$mcI$sp;
import ai.mantik.ds.element.Primitive$mcJ$sp;
import akka.util.ByteIterator;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ImageHelper$ {
    public static final ImageHelper$ MODULE$ = new ImageHelper$();
    private static final ByteOrder order = ByteOrder.BIG_ENDIAN;

    private ByteOrder order() {
        return order;
    }

    public Either<String, Function1<ImageElement, IndexedSeq<Primitive<?>>>> imageUnpacker(Image image) {
        FundamentalType single;
        SeqOps seqOps;
        block5: {
            block4: {
                Iterable iterable = (Iterable)image.components().map((Function1 & Serializable)x$1 -> ((ImageComponent)x$1._2()).componentType());
                if (!(iterable instanceof List)) break block4;
                List list = (List)iterable;
                seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) break block5;
            }
            return package$.MODULE$.Left().apply((Object)"Can only convert single component images to tensors");
        }
        FundamentalType fundamentalType = single = (FundamentalType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        FundamentalType singleComponent = fundamentalType;
        ImageFormat imageFormat = image.format();
        ImageFormat$Plain$ imageFormat$Plain$ = ImageFormat$Plain$.MODULE$;
        if (imageFormat == null ? imageFormat$Plain$ != null : !imageFormat.equals(imageFormat$Plain$)) {
            return package$.MODULE$.Left().apply((Object)"Only plain images can be converted");
        }
        return this.buildReader(singleComponent).map((Function1 & Serializable)reader -> (Function1 & Serializable)i -> {
            Builder builder = package$.MODULE$.IndexedSeq().newBuilder();
            builder.sizeHint(image.width() * image.height());
            ByteIterator it = i.bytes().iterator();
            while (it.hasNext()) {
                builder.$plus$eq(reader.apply((Object)it));
            }
            return (IndexedSeq)builder.result();
        });
    }

    public Either<String, Function1<IndexedSeq<Primitive<?>>, ImageElement>> imagePacker(Image image) {
        FundamentalType single;
        SeqOps seqOps;
        block5: {
            block4: {
                Iterable iterable = (Iterable)image.components().map((Function1 & Serializable)x$2 -> ((ImageComponent)x$2._2()).componentType());
                if (!(iterable instanceof List)) break block4;
                List list = (List)iterable;
                seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) break block5;
            }
            return package$.MODULE$.Left().apply((Object)"Can only convert single component images to tensors");
        }
        FundamentalType fundamentalType = single = (FundamentalType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        FundamentalType singleComponent = fundamentalType;
        ImageFormat imageFormat = image.format();
        ImageFormat$Plain$ imageFormat$Plain$ = ImageFormat$Plain$.MODULE$;
        if (imageFormat == null ? imageFormat$Plain$ != null : !imageFormat.equals(imageFormat$Plain$)) {
            return package$.MODULE$.Left().apply((Object)"Only plain images can be converted");
        }
        return this.buildWriter(singleComponent).flatMap((Function1 & Serializable)writer -> MODULE$.byteSize(singleComponent).map((Function1 & Serializable)bs -> ImageHelper$.$anonfun$imagePacker$3(image, writer, BoxesRunTime.unboxToInt((Object)bs))));
    }

    private Either<String, Function1<ByteIterator, Primitive<?>>> buildReader(FundamentalType ft) {
        Function1 & Serializable intersect;
        FundamentalType fundamentalType = ft;
        if (FundamentalType$Uint8$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive<Byte>(BoxesRunTime.boxToByte((byte)it.getByte()));
        } else if (FundamentalType$Int8$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive<Byte>(BoxesRunTime.boxToByte((byte)it.getByte()));
        } else if (FundamentalType$Int32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcI$sp(it.getInt(MODULE$.order()));
        } else if (FundamentalType$Uint32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcI$sp(it.getInt(MODULE$.order()));
        } else if (FundamentalType$Int64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcJ$sp(it.getLong(MODULE$.order()));
        } else if (FundamentalType$Uint64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcJ$sp(it.getLong(MODULE$.order()));
        } else if (FundamentalType$Float32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcF$sp(it.getFloat(MODULE$.order()));
        } else if (FundamentalType$Float64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function1 & Serializable)it -> new Primitive$mcD$sp(it.getDouble(MODULE$.order()));
        } else {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Type ").append(fundamentalType).append(" not supported").toString());
        }
        Function1 & Serializable reader = intersect;
        return package$.MODULE$.Right().apply((Object)reader);
    }

    private Either<String, Function2<Primitive<?>, ByteStringBuilder, BoxedUnit>> buildWriter(FundamentalType ft) {
        Function2 & Serializable intersect;
        FundamentalType fundamentalType = ft;
        if (FundamentalType$Uint8$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putByte(BoxesRunTime.unboxToByte(a.x()));
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Int8$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putByte(BoxesRunTime.unboxToByte(((Primitive)b).x()));
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Int32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putInt(a.x$mcI$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Uint32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putInt(a.x$mcI$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Int64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putLong(a.x$mcJ$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Uint64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putLong(a.x$mcJ$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Float32$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putFloat(a.x$mcF$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else if (FundamentalType$Float64$.MODULE$.equals(fundamentalType)) {
            intersect = (Function2 & Serializable)(a, b) -> {
                b.putDouble(a.x$mcD$sp(), ImageHelper$.MODULE$.order());
                return BoxedUnit.UNIT;
            };
        } else {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Type ").append(ft).append(" not supported").toString());
        }
        Function2 & Serializable writer = intersect;
        return package$.MODULE$.Right().apply((Object)writer);
    }

    private Either<String, Object> byteSize(FundamentalType ft) {
        int n;
        FundamentalType fundamentalType = ft;
        boolean bl = FundamentalType$Uint8$.MODULE$.equals(fundamentalType) ? true : FundamentalType$Int8$.MODULE$.equals(fundamentalType);
        if (bl) {
            n = 1;
        } else {
            boolean bl2 = FundamentalType$Uint32$.MODULE$.equals(fundamentalType) ? true : FundamentalType$Int32$.MODULE$.equals(fundamentalType);
            if (bl2) {
                n = 4;
            } else {
                boolean bl3 = FundamentalType$Uint64$.MODULE$.equals(fundamentalType) ? true : FundamentalType$Int64$.MODULE$.equals(fundamentalType);
                if (bl3) {
                    n = 8;
                } else if (FundamentalType$Float32$.MODULE$.equals(fundamentalType)) {
                    n = 4;
                } else if (FundamentalType$Float64$.MODULE$.equals(fundamentalType)) {
                    n = 4;
                } else {
                    return package$.MODULE$.Left().apply((Object)new StringBuilder(19).append("Type ").append(ft).append(" not supported").toString());
                }
            }
        }
        int size = n;
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)size));
    }

    public static final /* synthetic */ Function1 $anonfun$imagePacker$3(Image image$2, Function2 writer$1, int bs) {
        return (Function1 & Serializable)elements -> {
            ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
            builder.sizeHint(image$2.width() * image$2.height() * bs);
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                writer$1.apply(it.next(), (Object)builder);
            }
            return new ImageElement(builder.result());
        };
    }

    private ImageHelper$() {
    }
}

