/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.helper.circe;

import akka.util.ByteString;
import akka.util.ByteString$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ValueType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MessagePackJsonSupport$ {
    public static final MessagePackJsonSupport$ MODULE$ = new MessagePackJsonSupport$();

    public ByteString toMessagePackBytes(Json in) {
        MessageBufferPacker writer = MessagePack.newDefaultBufferPacker();
        this.writeJsonToMessagePack((MessagePacker)writer, in);
        return ByteString$.MODULE$.fromArrayUnsafe(writer.toByteArray());
    }

    public Json fromMessagePackBytes(ByteString in) {
        MessageUnpacker reader = MessagePack.newDefaultUnpacker((byte[])((byte[])in.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
        return this.readJsonToMessagePack(reader);
    }

    public void writeJsonToMessagePack(MessagePacker out, Json json) {
        MessagePackJsonSupport$.writeJsonValue$1(json, out);
    }

    public Json readJsonToMessagePack(MessageUnpacker in) throws IOException {
        Json json;
        ValueType valueType = in.getNextFormat().getValueType();
        if (ValueType.NIL.equals(valueType)) {
            in.unpackNil();
            json = Json$.MODULE$.Null();
        } else if (ValueType.BOOLEAN.equals(valueType)) {
            json = Json$.MODULE$.fromBoolean(in.unpackBoolean());
        } else if (ValueType.INTEGER.equals(valueType)) {
            json = Json$.MODULE$.fromLong(in.unpackLong());
        } else if (ValueType.STRING.equals(valueType)) {
            json = Json$.MODULE$.fromString(in.unpackString());
        } else if (ValueType.ARRAY.equals(valueType)) {
            int length = in.unpackArrayHeader();
            ReusableBuilder buffer = package$.MODULE$.Vector().newBuilder();
            buffer.sizeHint(length);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable)i -> MessagePackJsonSupport$.$anonfun$readJsonToMessagePack$1(buffer, in, BoxesRunTime.unboxToInt((Object)i)));
            json = Json$.MODULE$.fromValues((Iterable)buffer.result());
        } else if (ValueType.FLOAT.equals(valueType)) {
            json = Json$.MODULE$.fromDoubleOrNull(in.unpackDouble());
        } else if (ValueType.MAP.equals(valueType)) {
            int length = in.unpackMapHeader();
            ReusableBuilder buffer = package$.MODULE$.Vector().newBuilder();
            buffer.sizeHint(length);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable)i -> MessagePackJsonSupport$.$anonfun$readJsonToMessagePack$2(in, buffer, BoxesRunTime.unboxToInt((Object)i)));
            json = Json$.MODULE$.fromFields((Iterable)buffer.result());
        } else {
            throw new IOException(new StringBuilder(18).append("Unexpected format ").append(valueType).toString());
        }
        return json;
    }

    public static final /* synthetic */ void $anonfun$writeJsonToMessagePack$1(MessagePacker out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Json value = (Json)tuple2._2();
        out$1.packString(key);
        MessagePackJsonSupport$.writeJsonValue$1(value, out$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void writeJsonObject$1(JsonObject o, MessagePacker out$1) {
        out$1.packMapHeader(o.size());
        o.toIterable().foreach((Function1 & Serializable)x0$1 -> {
            MessagePackJsonSupport$.$anonfun$writeJsonToMessagePack$1(out$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final void writeJsonValue$1(Json j, MessagePacker out$1) {
        j.fold((Function0 & Serializable)() -> out$1.packNil(), (Function1 & Serializable)b -> out$1.packBoolean(BoxesRunTime.unboxToBoolean((Object)b)), (Function1 & Serializable)num -> {
            MessagePackJsonSupport$.writeJsonNumber$1(num, out$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)s -> out$1.packString(s), (Function1 & Serializable)a -> {
            MessagePackJsonSupport$.writeJsonArray$1(a, out$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)o -> {
            MessagePackJsonSupport$.writeJsonObject$1(o, out$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final void writeJsonNumber$1(JsonNumber n, MessagePacker out$1) {
        Option option = n.toInt();
        if (option instanceof Some) {
            Some some = (Some)option;
            int i = BoxesRunTime.unboxToInt((Object)some.value());
            out$1.packInt(i);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Option option2 = n.toBigInt();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                BigInt bigInt = (BigInt)some.value();
                out$1.packBigInteger(bigInt.bigInteger());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                out$1.packDouble(n.toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private static final void writeJsonArray$1(Vector j2, MessagePacker out$1) {
        out$1.packArrayHeader(j2.size());
        j2.foreach((Function1 & Serializable)j -> {
            MessagePackJsonSupport$.writeJsonValue$1(j, out$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ ReusableBuilder $anonfun$readJsonToMessagePack$1(ReusableBuilder buffer$1, MessageUnpacker in$1, int i) {
        return (ReusableBuilder)buffer$1.$plus$eq((Object)MODULE$.readJsonToMessagePack(in$1));
    }

    public static final /* synthetic */ ReusableBuilder $anonfun$readJsonToMessagePack$2(MessageUnpacker in$1, ReusableBuilder buffer$2, int i) {
        String key = in$1.unpackString();
        Json value = MODULE$.readJsonToMessagePack(in$1);
        return (ReusableBuilder)buffer$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
    }

    private MessagePackJsonSupport$() {
    }
}

