/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql;

import ai.mantik.ds.DataType;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.converter.Cast;
import ai.mantik.ds.converter.Cast$;
import ai.mantik.ds.sql.AnonymousInput;
import ai.mantik.ds.sql.AnonymousInput$;
import ai.mantik.ds.sql.CastExpression;
import ai.mantik.ds.sql.ColumnExpression;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.Select$;
import ai.mantik.ds.sql.SelectProjection;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public final class AutoSelect$ {
    public static final AutoSelect$ MODULE$ = new AutoSelect$();

    public Either<String, Select> autoSelect(DataType from, DataType expected) {
        return this.fetchTabular(from).flatMap((Function1 & Serializable)fromTabular -> MODULE$.fetchTabular(expected).flatMap((Function1 & Serializable)toTabular -> MODULE$.autoSelect((TabularData)fromTabular, (TabularData)toTabular).map((Function1 & Serializable)autoSelect -> autoSelect)));
    }

    public Either<String, TabularData> fetchTabular(DataType dt) {
        Left left;
        DataType dataType = dt;
        if (dataType instanceof TabularData) {
            TabularData tabularData = (TabularData)dataType;
            left = package$.MODULE$.Right().apply((Object)tabularData);
        } else {
            left = package$.MODULE$.Left().apply((Object)"Can only auto adapt tabular data");
        }
        return left;
    }

    public Either<String, Select> autoSelect(TabularData from, TabularData to) {
        return this.buildColumnMapping(from, to).flatMap((Function1 & Serializable)columnMapping -> {
            Either maybeProjections = (Either)implicits$.MODULE$.toTraverseOps((Object)((IterableOnceOps)to.columns().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String toColumn = (String)tuple2._1();
                DataType targetType = (DataType)tuple2._2();
                String fromColumn = (String)columnMapping.apply((Object)toColumn);
                Either<String, SelectProjection> either = MODULE$.buildColumnSelector(from, fromColumn, toColumn, targetType);
                return either;
            })).toVector(), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
            return maybeProjections.map((Function1 & Serializable)projections -> new Select(new AnonymousInput(from, AnonymousInput$.MODULE$.apply$default$2()), (Option<Vector<SelectProjection>>)new Some(projections), Select$.MODULE$.apply$default$3()));
        });
    }

    private Either<String, Map<String, String>> buildColumnMapping(TabularData from, TabularData to) {
        String single;
        SeqOps seqOps;
        List missing;
        List fromColumnNames = from.columns().keys().toList();
        List toColumnNames = to.columns().keys().toList();
        Map resolved = ((List)fromColumnNames.intersect((Seq)toColumnNames)).map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(v), v)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List list = missing = (List)toColumnNames.diff((Seq)fromColumnNames);
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return package$.MODULE$.Right().apply((Object)resolved);
        }
        if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("Could not resolve ").append(list).toString());
        }
        String string = single = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String singleMissing = string;
        List unresolved = (List)fromColumnNames.diff((Seq)toColumnNames);
        if (unresolved.size() == 1) {
            return package$.MODULE$.Right().apply((Object)resolved.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)singleMissing), unresolved.head())));
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(18).append("Could not resolve ").append(singleMissing).toString());
    }

    private Either<String, SelectProjection> buildColumnSelector(TabularData from, String fromColumn, String targetColumn, DataType expectedType) {
        int fromIndex = BoxesRunTime.unboxToInt((Object)from.lookupColumnIndex(fromColumn).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(17).append("Column ").append(fromColumn).append(" not found").toString());
        }));
        DataType fromType = (DataType)from.columns().apply((Object)fromColumn);
        return Cast$.MODULE$.findCast(fromType, expectedType).flatMap((Function1 & Serializable)x0$1 -> {
            Cast cast;
            Cast cast2;
            Left left;
            Cast cast3;
            Cast cast4 = x0$1;
            if (cast4 != null && (cast3 = cast4).canFail()) {
                left = package$.MODULE$.Left().apply((Object)new StringBuilder(45).append("Cast from ").append(fromColumn).append(" can fail, cannot be auto converted").toString());
            } else if (cast4 != null && (cast2 = cast4).loosing()) {
                left = package$.MODULE$.Left().apply((Object)new StringBuilder(55).append("Cast from ").append(fromColumn).append(" can loose precision, cannot be autoconverted").toString());
            } else if (cast4 != null && (cast = cast4).isIdentity()) {
                left = package$.MODULE$.Right().apply((Object)new SelectProjection(targetColumn, new ColumnExpression(fromIndex, fromType)));
            } else if (cast4 != null) {
                left = package$.MODULE$.Right().apply((Object)new SelectProjection(targetColumn, new CastExpression(new ColumnExpression(fromIndex, fromType), expectedType)));
            } else {
                throw new MatchError((Object)cast4);
            }
            return left;
        });
    }

    private AutoSelect$() {
    }
}

