/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.builder;

import ai.mantik.ds.DataType;
import ai.mantik.ds.FundamentalType$BoolType$;
import ai.mantik.ds.FundamentalType$Int32$;
import ai.mantik.ds.Struct;
import ai.mantik.ds.operations.BinaryOperation;
import ai.mantik.ds.operations.BinaryOperation$Add$;
import ai.mantik.ds.operations.BinaryOperation$Div$;
import ai.mantik.ds.operations.BinaryOperation$Mul$;
import ai.mantik.ds.operations.BinaryOperation$Sub$;
import ai.mantik.ds.sql.ArrayGetExpression;
import ai.mantik.ds.sql.BinaryOperationExpression;
import ai.mantik.ds.sql.ColumnExpression;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.QueryColumn;
import ai.mantik.ds.sql.QueryTabularType;
import ai.mantik.ds.sql.SizeExpression;
import ai.mantik.ds.sql.StructAccessExpression;
import ai.mantik.ds.sql.builder.CastBuilder$;
import ai.mantik.ds.sql.builder.ConstantBuilder$;
import ai.mantik.ds.sql.parser.AST;
import ai.mantik.ds.sql.parser.AST$NullNode$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class ExpressionBuilder$ {
    public static final ExpressionBuilder$ MODULE$ = new ExpressionBuilder$();
    private static final Seq<String> binaryConditions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"=", "and", "or"}));
    private static final Map<String, Product> opMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+"), (Object)BinaryOperation$Add$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)BinaryOperation$Sub$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)BinaryOperation$Mul$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/"), (Object)BinaryOperation$Div$.MODULE$)}));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, Expression> convertExpression(QueryTabularType input2, AST.ExpressionNode node) {
        AST.ExpressionNode expressionNode;
        AST.BinaryOperationNode binaryOperationNode;
        boolean bl;
        block18: {
            Either either;
            String string;
            block19: {
                AST.UnaryOperationNode unaryOperationNode;
                block20: {
                    bl = false;
                    binaryOperationNode = null;
                    expressionNode = node;
                    if (expressionNode instanceof AST.IdentifierNode) {
                        AST.IdentifierNode identifierNode = (AST.IdentifierNode)expressionNode;
                        return this.buildColumnExpressionByIdentifier(input2, identifierNode);
                    }
                    if (expressionNode instanceof AST.CastNode) {
                        AST.CastNode castNode = (AST.CastNode)expressionNode;
                        return this.convertExpression(input2, castNode.expression()).flatMap((Function1 & Serializable)expression -> CastBuilder$.MODULE$.buildCast((Expression)expression, castNode).map((Function1 & Serializable)cast -> cast));
                    }
                    if (expressionNode instanceof AST.ConstantExpressionNode) {
                        AST.ConstantExpressionNode constantExpressionNode = (AST.ConstantExpressionNode)expressionNode;
                        return ConstantBuilder$.MODULE$.convertConstant(constantExpressionNode);
                    }
                    if (!(expressionNode instanceof AST.UnaryOperationNode)) break block18;
                    unaryOperationNode = (AST.UnaryOperationNode)expressionNode;
                    string = unaryOperationNode.operation();
                    switch (string == null ? 0 : string.hashCode()) {
                        case 109267: {
                            if ("not".equals(string)) {
                                break;
                            }
                            break block19;
                        }
                        case 3530753: {
                            if (!"size".equals(string)) break block19;
                            break block20;
                        }
                        default: {
                            break block19;
                        }
                    }
                    either = this.convertExpression(input2, unaryOperationNode.exp()).flatMap((Function1 & Serializable)exp -> {
                        DataType dataType = exp.dataType();
                        Object object = FundamentalType$BoolType$.MODULE$.equals(dataType) ? package$.MODULE$.Right().apply((Object)new Condition.Not(new Condition.WrappedExpression((Expression)exp))) : package$.MODULE$.Left().apply((Object)"Cannot negate a non boolean data type");
                        return object;
                    });
                    return either;
                }
                either = this.convertExpression(input2, unaryOperationNode.exp()).flatMap((Function1 & Serializable)exp -> CastBuilder$.MODULE$.ensureArray((Expression)exp, true).map((Function1 & Serializable)expArray -> new SizeExpression((Expression)expArray._1())));
                return either;
            }
            either = package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("Unsupported unary operation ").append(string).toString());
            return either;
        }
        if (expressionNode instanceof AST.BinaryOperationNode) {
            bl = true;
            binaryOperationNode = (AST.BinaryOperationNode)expressionNode;
            String string = binaryOperationNode.operation();
            String string2 = "is";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                AST.ExpressionNode expressionNode2 = binaryOperationNode.right();
                AST$NullNode$ aST$NullNode$ = AST$NullNode$.MODULE$;
                return !(expressionNode2 != null ? !expressionNode2.equals(aST$NullNode$) : aST$NullNode$ != null) ? this.convertExpression(input2, binaryOperationNode.left()).map((Function1 & Serializable)left -> new Condition.IsNull((Expression)left)) : package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Only IS <NULL> supported, got ").append(binaryOperationNode.right()).toString());
            }
        }
        if (bl) {
            String string = binaryOperationNode.operation();
            String string3 = "isnot";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                AST.ExpressionNode expressionNode3 = binaryOperationNode.right();
                AST$NullNode$ aST$NullNode$ = AST$NullNode$.MODULE$;
                return !(expressionNode3 != null ? !expressionNode3.equals(aST$NullNode$) : aST$NullNode$ != null) ? this.convertExpression(input2, binaryOperationNode.left()).map((Function1 & Serializable)left -> new Condition.Not(new Condition.IsNull((Expression)left))) : package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Only IS NOT <NULL> supported, got ").append(binaryOperationNode.right()).toString());
            }
        }
        if (bl) {
            String string = binaryOperationNode.operation();
            String string4 = "[]";
            if (string == null) {
                if (string4 == null) return this.convertExpression(input2, binaryOperationNode.left()).flatMap((Function1 & Serializable)left -> CastBuilder$.MODULE$.ensureArray((Expression)left, true).flatMap((Function1 & Serializable)leftArray -> MODULE$.convertExpression(input2, binaryOperationNode.right()).flatMap((Function1 & Serializable)right -> CastBuilder$.MODULE$.wrapTypeWithNullableSupport((Expression)right, FundamentalType$Int32$.MODULE$).map((Function1 & Serializable)rightIndex -> new ArrayGetExpression((Expression)leftArray._1(), (Expression)rightIndex)))));
            } else if (string.equals(string4)) {
                return this.convertExpression(input2, binaryOperationNode.left()).flatMap((Function1 & Serializable)left -> CastBuilder$.MODULE$.ensureArray((Expression)left, true).flatMap((Function1 & Serializable)leftArray -> MODULE$.convertExpression(input2, binaryOperationNode.right()).flatMap((Function1 & Serializable)right -> CastBuilder$.MODULE$.wrapTypeWithNullableSupport((Expression)right, FundamentalType$Int32$.MODULE$).map((Function1 & Serializable)rightIndex -> new ArrayGetExpression((Expression)leftArray._1(), (Expression)rightIndex)))));
            }
        }
        if (expressionNode instanceof AST.StructAccessNode) {
            AST.StructAccessNode structAccessNode = (AST.StructAccessNode)expressionNode;
            return this.convertExpression(input2, structAccessNode.expression()).flatMap((Function1 & Serializable)input -> CastBuilder$.MODULE$.ensureStruct((Expression)input, true).map((Function1 & Serializable)inputStructure -> {
                Struct structure = (Struct)inputStructure._2();
                return new Tuple2(inputStructure, (Object)structure);
            }).flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 inputStructure = (Tuple2)tuple2._1();
                Struct structure = (Struct)tuple2._2();
                Either either = (structure.fields().contains((Object)structAccessNode.name()) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new StringBuilder(33).append("Structure ").append(structure).append(" doesn't contain field ").append(structAccessNode.name()).toString())).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    StructAccessExpression structAccessExpression = new StructAccessExpression((Expression)inputStructure._1(), structAccessNode.name());
                    return structAccessExpression;
                });
                return either;
            }));
        }
        if (bl && this.binaryConditions().contains((Object)binaryOperationNode.operation())) {
            return this.convertExpression(input2, binaryOperationNode.left()).flatMap((Function1 & Serializable)left -> MODULE$.convertExpression(input2, binaryOperationNode.right()).flatMap((Function1 & Serializable)right -> MODULE$.convertBinaryCondition(binaryOperationNode.operation(), (Expression)left, (Expression)right).map((Function1 & Serializable)op -> op)));
        }
        if (!bl) throw new MatchError((Object)expressionNode);
        return this.convertBinaryOperation(binaryOperationNode.operation()).flatMap((Function1 & Serializable)op -> MODULE$.convertExpression(input2, binaryOperationNode.left()).flatMap((Function1 & Serializable)left -> MODULE$.convertExpression(input2, binaryOperationNode.right()).flatMap((Function1 & Serializable)right -> CastBuilder$.MODULE$.operationType((BinaryOperation)op, (Expression)left, (Expression)right).flatMap((Function1 & Serializable)commonType -> CastBuilder$.MODULE$.wrapType((Expression)left, (DataType)commonType).flatMap((Function1 & Serializable)leftCasted -> CastBuilder$.MODULE$.wrapType((Expression)right, (DataType)commonType).map((Function1 & Serializable)rightCasted -> new BinaryOperationExpression((BinaryOperation)op, (Expression)leftCasted, (Expression)rightCasted)))))));
    }

    private Seq<String> binaryConditions() {
        return binaryConditions;
    }

    private Either<String, Condition> convertBinaryCondition(String op, Expression left, Expression right) {
        Either either;
        block9: {
            String string;
            block6: {
                block7: {
                    block8: {
                        string = op;
                        switch (string == null ? 0 : string.hashCode()) {
                            case 61: {
                                if ("=".equals(string)) {
                                    break;
                                }
                                break block6;
                            }
                            case 3555: {
                                if (!"or".equals(string)) break block6;
                                break block7;
                            }
                            case 96727: {
                                if (!"and".equals(string)) break block6;
                                break block8;
                            }
                            default: {
                                break block6;
                            }
                        }
                        either = CastBuilder$.MODULE$.comparisonType(left, right).flatMap((Function1 & Serializable)commonType -> CastBuilder$.MODULE$.wrapType(left, (DataType)commonType).flatMap((Function1 & Serializable)leftCasted -> CastBuilder$.MODULE$.wrapType(right, (DataType)commonType).map((Function1 & Serializable)rightCasted -> new Condition.Equals((Expression)leftCasted, (Expression)rightCasted))));
                        break block9;
                    }
                    either = ExpressionBuilder$.asCondition$1(left).flatMap((Function1 & Serializable)leftc -> ExpressionBuilder$.asCondition$1(right).map((Function1 & Serializable)rightc -> new Condition.And((Condition)leftc, (Condition)rightc)));
                    break block9;
                }
                either = ExpressionBuilder$.asCondition$1(left).flatMap((Function1 & Serializable)leftc -> ExpressionBuilder$.asCondition$1(right).map((Function1 & Serializable)rightc -> new Condition.Or((Condition)leftc, (Condition)rightc)));
                break block9;
            }
            throw new MatchError((Object)string);
        }
        return either;
    }

    private Either<String, BinaryOperation> convertBinaryOperation(String op) {
        Left left;
        Option option = this.opMap().get((Object)op);
        if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("Operation ").append(op).append(" not yet supported").toString());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Product op2 = (Product)some.value();
            left = package$.MODULE$.Right().apply((Object)op2);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private Map<String, Product> opMap() {
        return opMap;
    }

    public Either<String, ColumnExpression> buildColumnExpressionByIdentifier(QueryTabularType input, AST.IdentifierNode identifier) {
        return this.findColumnByIdentifier(input, identifier).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int columnId = tuple2._1$mcI$sp();
            DataType dataType = (DataType)tuple2._2();
            ColumnExpression columnExpression = new ColumnExpression(columnId, dataType);
            return columnExpression;
        });
    }

    public Either<String, Tuple2<Object, DataType>> findColumnByIdentifier(QueryTabularType input, AST.IdentifierNode identifier) {
        return input.lookupColumn(identifier.name(), !identifier.ignoreCase(), input.lookupColumn$default$3()).map((Function1 & Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)((QueryColumn)x._2()).dataType()));
    }

    private static final Either asCondition$1(Expression e) {
        Left left;
        Option<Condition> option = e.asCondition();
        if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(23).append("Expected condition got ").append(e).toString());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Condition ok = (Condition)some.value();
            left = package$.MODULE$.Right().apply((Object)ok);
        } else {
            throw new MatchError(option);
        }
        return left;
    }

    private ExpressionBuilder$() {
    }
}

