/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.builder;

import ai.mantik.ds.TabularData;
import ai.mantik.ds.sql.Alias;
import ai.mantik.ds.sql.AnonymousInput;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.QueryTabularType;
import ai.mantik.ds.sql.SqlContext;
import ai.mantik.ds.sql.Union;
import ai.mantik.ds.sql.builder.JoinBuilder$;
import ai.mantik.ds.sql.builder.SelectBuilder$;
import ai.mantik.ds.sql.parser.AST;
import ai.mantik.ds.sql.parser.QueryParser$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;

public final class QueryBuilder$ {
    public static final QueryBuilder$ MODULE$ = new QueryBuilder$();

    public Either<String, Query> buildQuery(String statement, SqlContext context) {
        return QueryParser$.MODULE$.parseQueryNode(statement).flatMap((Function1 & Serializable)queryNode -> MODULE$.buildQueryFromParsed((AST.QueryNode)queryNode, context).map((Function1 & Serializable)query -> query));
    }

    public Either<String, Query> buildQueryFromParsed(AST.QueryNode query, SqlContext context) {
        Either either;
        AST.QueryNode queryNode = query;
        if (queryNode instanceof AST.AnonymousReference) {
            AST.AnonymousReference anonymousReference = (AST.AnonymousReference)queryNode;
            either = this.buildAnonymousInput(anonymousReference, context);
        } else if (queryNode instanceof AST.SelectNode) {
            AST.SelectNode selectNode = (AST.SelectNode)queryNode;
            either = SelectBuilder$.MODULE$.buildSelectFromParsed(selectNode, context);
        } else if (queryNode instanceof AST.UnionNode) {
            AST.UnionNode unionNode = (AST.UnionNode)queryNode;
            either = this.buildUnionFromParsed(unionNode, context);
        } else if (queryNode instanceof AST.JoinNode) {
            AST.JoinNode joinNode = (AST.JoinNode)queryNode;
            either = JoinBuilder$.MODULE$.buildJoinFromParsed(joinNode, context);
        } else if (queryNode instanceof AST.AliasNode) {
            AST.AliasNode aliasNode = (AST.AliasNode)queryNode;
            either = this.buildQueryFromParsed(aliasNode.query(), context).map((Function1 & Serializable)inner -> new Alias((Query)inner, aliasNode.name()));
        } else {
            throw new MatchError((Object)queryNode);
        }
        return either;
    }

    public Either<String, AnonymousInput> buildAnonymousInput(AST.AnonymousReference a, SqlContext context) {
        Left left;
        if (context.anonymous().isDefinedAt(a.id())) {
            TabularData dataType = (TabularData)context.anonymous().apply(a.id());
            left = package$.MODULE$.Right().apply((Object)new AnonymousInput(dataType, a.id()));
        } else {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Could not resolve anonymous input ").append(a).toString());
        }
        return left;
    }

    public Either<String, Union> buildUnionFromParsed(AST.UnionNode union, SqlContext context) {
        return this.buildQueryFromParsed(union.left(), context).flatMap((Function1 & Serializable)leftQuery -> MODULE$.buildQueryFromParsed(union.right(), context).flatMap((Function1 & Serializable)rightQuery -> MODULE$.validateSameType((Query)leftQuery, (Query)rightQuery).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            Union union = new Union((Query)leftQuery, (Query)rightQuery, union.all());
            return union;
        })));
    }

    private Either<String, BoxedUnit> validateSameType(Query left, Query right) {
        QueryTabularType queryTabularType = left.resultingQueryType();
        QueryTabularType queryTabularType2 = right.resultingQueryType();
        return !(queryTabularType != null ? !((Object)queryTabularType).equals(queryTabularType2) : queryTabularType2 != null) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Type mismatch, left: ").append(left.resultingQueryType()).append(", right: ").append(right.resultingQueryType()).toString());
    }

    private QueryBuilder$() {
    }
}

