/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.builder;

import ai.mantik.ds.TabularData;
import ai.mantik.ds.sql.Condition;
import ai.mantik.ds.sql.Expression;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.QueryTabularType;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.SelectProjection;
import ai.mantik.ds.sql.SqlContext;
import ai.mantik.ds.sql.builder.ExpressionBuilder$;
import ai.mantik.ds.sql.builder.QueryBuilder$;
import ai.mantik.ds.sql.builder.SelectorBuilder$;
import ai.mantik.ds.sql.parser.AST;
import ai.mantik.ds.sql.parser.QueryParser$;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class SelectBuilder$ {
    public static final SelectBuilder$ MODULE$ = new SelectBuilder$();

    public Either<String, Select> buildSelect(TabularData input, String statement) {
        SqlContext context = new SqlContext((Vector<TabularData>)((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TabularData[]{input}))));
        return this.buildSelect(statement, context);
    }

    public Either<String, Select> buildSelect(String statement, SqlContext context) {
        return QueryParser$.MODULE$.parseSelectToNode(statement).flatMap((Function1 & Serializable)node -> MODULE$.buildSelectFromParsed((AST.SelectNode)node, context).map((Function1 & Serializable)build -> build));
    }

    public Either<String, Select> buildSelectFromParsed(AST.SelectNode statement, SqlContext context) {
        AST.QueryNode from = (AST.QueryNode)statement.from().getOrElse((Function0 & Serializable)() -> new AST.AnonymousReference(0));
        return QueryBuilder$.MODULE$.buildQueryFromParsed(from, context).map((Function1 & Serializable)input -> {
            QueryTabularType inputType = input.resultingQueryType();
            return new Tuple2(input, (Object)inputType);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Query input = (Query)tuple2._1();
            QueryTabularType inputType = (QueryTabularType)tuple2._2();
            Either either = MODULE$.buildProjections(inputType, statement).flatMap((Function1 & Serializable)projections -> MODULE$.buildSelectors(inputType, statement).map((Function1 & Serializable)selectors -> new Select(input, (Option<Vector<SelectProjection>>)projections, (Vector<Condition>)selectors)));
            return either;
        });
    }

    private Either<String, Option<Vector<SelectProjection>>> buildProjections(QueryTabularType input, AST.SelectNode statement) {
        return statement.isAll() ? package$.MODULE$.Right().apply((Object)None$.MODULE$) : ((Either)implicits$.MODULE$.toTraverseOps(((StrictOptimizedIterableOps)statement.selectColumns().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AST.SelectColumnNode selectColumnNode = (AST.SelectColumnNode)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Either<String, SelectProjection> either = MODULE$.buildProjection(input, selectColumnNode, idx);
            return either;
        }), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)x$2 -> new Some(x$2));
    }

    private Either<String, Vector<Condition>> buildSelectors(QueryTabularType input, AST.SelectNode statement) {
        Either<String, Vector<Condition>> either;
        Option<AST.ExpressionNode> option = statement.where();
        if (None$.MODULE$.equals(option)) {
            either = package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().empty());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            AST.ExpressionNode expression = (AST.ExpressionNode)some.value();
            either = SelectorBuilder$.MODULE$.convertSelector(input, expression);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<String, SelectProjection> buildProjection(QueryTabularType input, AST.SelectColumnNode node, int idx) {
        String name = this.guessName(node, idx);
        return ExpressionBuilder$.MODULE$.convertExpression(input, node.expression()).map((Function1 & Serializable)expression -> new SelectProjection(name, (Expression)expression));
    }

    private String guessName(AST.SelectColumnNode node, int idx) {
        String string;
        Option<AST.IdentifierNode> option = node.as();
        if (option instanceof Some) {
            Some some = (Some)option;
            AST.IdentifierNode identifier = (AST.IdentifierNode)some.value();
            string = identifier.name();
        } else if (None$.MODULE$.equals(option)) {
            string = (String)this.guessName(node.expression()).getOrElse((Function0 & Serializable)() -> new StringBuilder(1).append("$").append(Integer.toString(idx + 1)).toString());
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private Option<String> guessName(AST.ExpressionNode node) {
        Some some;
        block3: {
            while (true) {
                AST.ExpressionNode expressionNode;
                if ((expressionNode = node) instanceof AST.IdentifierNode) {
                    AST.IdentifierNode identifierNode = (AST.IdentifierNode)expressionNode;
                    some = new Some((Object)identifierNode.name());
                    break block3;
                }
                if (expressionNode instanceof AST.StructAccessNode) {
                    AST.StructAccessNode structAccessNode = (AST.StructAccessNode)expressionNode;
                    some = new Some((Object)structAccessNode.name());
                    break block3;
                }
                if (!(expressionNode instanceof AST.CastNode)) break;
                AST.CastNode castNode = (AST.CastNode)expressionNode;
                node = castNode.expression();
            }
            some = None$.MODULE$;
        }
        return some;
    }

    private SelectBuilder$() {
    }
}

