/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.elements;

import ai.mantik.elements.NamedMantikId;
import ai.mantik.elements.errors.InvalidMantikIdException;
import ai.mantik.elements.errors.InvalidMantikIdException$;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.data.Validated;
import io.circe.ACursor;
import io.circe.AccumulatingDecoder;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.DecodingFailure$;
import io.circe.Encoder;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.matching.Regex;

public final class NamedMantikId$
implements scala.Serializable {
    public static NamedMantikId$ MODULE$;
    private final String DefaultVersion;
    private final String DefaultAccount;
    private final Encoder<NamedMantikId> encoder;
    private final Decoder<NamedMantikId> decoder;
    private final Encoder<NamedMantikId> mantikIdCodec;
    private final Regex NameRegex;
    private final Regex AccountRegex;
    private final Regex VersionRegex;

    static {
        new NamedMantikId$();
    }

    public String $lessinit$greater$default$1() {
        return this.DefaultAccount();
    }

    public String $lessinit$greater$default$3() {
        return this.DefaultVersion();
    }

    public String DefaultVersion() {
        return this.DefaultVersion;
    }

    public String DefaultAccount() {
        return this.DefaultAccount;
    }

    public NamedMantikId fromString(String s) throws InvalidMantikIdException {
        NamedMantikId v;
        Either<InvalidMantikIdException, NamedMantikId> either = this.decodeString(s);
        if (either instanceof Left) {
            Left left = (Left)either;
            InvalidMantikIdException e = (InvalidMantikIdException)left.value();
            throw e;
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        NamedMantikId namedMantikId = v = (NamedMantikId)right.value();
        return namedMantikId;
    }

    public NamedMantikId apply(String s) throws InvalidMantikIdException {
        return this.fromString(s);
    }

    public String apply$default$1() {
        return this.DefaultAccount();
    }

    public String apply$default$3() {
        return this.DefaultVersion();
    }

    public Encoder<NamedMantikId> encoder() {
        return this.encoder;
    }

    public Decoder<NamedMantikId> decoder() {
        return this.decoder;
    }

    public Either<DecodingFailure, NamedMantikId> decodeStringResult(String s) {
        Left left;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(":"))).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
            String accountName = (String)((LinearSeqOptimized)some.get()).apply(0);
            String version = (String)((LinearSeqOptimized)some.get()).apply(1);
            left = this.decodeAccountName(accountName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String account = (String)tuple2._1();
                String name = (String)tuple2._2();
                NamedMantikId namedMantikId = new NamedMantikId(account, name, version);
                return namedMantikId;
            });
        } else {
            Some some2 = List$.MODULE$.unapplySeq((Seq)list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                String accountName = (String)((LinearSeqOptimized)some2.get()).apply(0);
                left = this.decodeAccountName(accountName).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    String name;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String account = (String)tuple2._1();
                    String x$1 = name = (String)tuple2._2();
                    String x$2 = account;
                    String x$3 = MODULE$.DefaultVersion();
                    NamedMantikId namedMantikId = new NamedMantikId(x$2, x$1, x$3);
                    return namedMantikId;
                });
            } else {
                left = package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(new StringBuilder(25).append(s).append(" is not a valid Mantik id").toString(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
        }
        return left;
    }

    public Either<InvalidMantikIdException, NamedMantikId> decodeString(String s) {
        return this.decodeStringResult(s).left().map((Function1 & Serializable & scala.Serializable)decodingFailure -> InvalidMantikIdException$.MODULE$.fromDecodingFailure((DecodingFailure)decodingFailure));
    }

    private Either<DecodingFailure, Tuple2<String, String>> decodeAccountName(String s) {
        Left left;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split("/"))).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
            String account = (String)((LinearSeqOptimized)some.get()).apply(0);
            String name = (String)((LinearSeqOptimized)some.get()).apply(1);
            left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)account, (Object)name));
        } else {
            Some some2 = List$.MODULE$.unapplySeq((Seq)list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                String name = (String)((LinearSeqOptimized)some2.get()).apply(0);
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)this.DefaultAccount(), (Object)name));
            } else {
                left = package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(new StringBuilder(42).append(s).append(" is not a valid account / name combination").toString(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
        }
        return left;
    }

    public Encoder<NamedMantikId> mantikIdCodec() {
        return this.mantikIdCodec;
    }

    public Seq<String> accountViolations(String account) {
        Builder violations = Seq$.MODULE$.newBuilder();
        Object object = !this.AccountRegex().pattern().matcher(account).matches() ? violations.$plus$eq((Object)"Invalid Account") : BoxedUnit.UNIT;
        return (Seq)violations.result();
    }

    public Seq<String> nameViolations(String name) {
        Builder violations = Seq$.MODULE$.newBuilder();
        Object object = !this.NameRegex().pattern().matcher(name).matches() ? violations.$plus$eq((Object)"Invalid Name") : BoxedUnit.UNIT;
        return (Seq)violations.result();
    }

    public Seq<String> versionViolations(String version) {
        Builder violations = Seq$.MODULE$.newBuilder();
        Object object = !this.VersionRegex().pattern().matcher(version).matches() ? violations.$plus$eq((Object)"Invalid Version") : BoxedUnit.UNIT;
        return (Seq)violations.result();
    }

    public Regex NameRegex() {
        return this.NameRegex;
    }

    public Regex AccountRegex() {
        return this.AccountRegex;
    }

    public Regex VersionRegex() {
        return this.VersionRegex;
    }

    public NamedMantikId apply(String account, String name, String version) {
        return new NamedMantikId(account, name, version);
    }

    public Option<Tuple3<String, String, String>> unapply(NamedMantikId x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.account(), (Object)x$0.name(), (Object)x$0.version()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NamedMantikId$() {
        MODULE$ = this;
        this.DefaultVersion = "latest";
        this.DefaultAccount = "library";
        this.encoder = new Encoder<NamedMantikId>(){

            public final <B> Encoder<B> contramap(Function1<B, NamedMantikId> f) {
                return Encoder.contramap$((Encoder)this, f);
            }

            public final Encoder<NamedMantikId> mapJson(Function1<Json, Json> f) {
                return Encoder.mapJson$((Encoder)this, f);
            }

            public Json apply(NamedMantikId a) {
                return Json$.MODULE$.fromString(a.toString());
            }
            {
                Encoder.$init$((Encoder)this);
            }
        };
        this.decoder = new Decoder<NamedMantikId>(){

            public Validated<NonEmptyList<DecodingFailure>, NamedMantikId> decodeAccumulating(HCursor c) {
                return Decoder.decodeAccumulating$((Decoder)this, (HCursor)c);
            }

            public Either<DecodingFailure, NamedMantikId> tryDecode(ACursor c) {
                return Decoder.tryDecode$((Decoder)this, (ACursor)c);
            }

            public Validated<NonEmptyList<DecodingFailure>, NamedMantikId> tryDecodeAccumulating(ACursor c) {
                return Decoder.tryDecodeAccumulating$((Decoder)this, (ACursor)c);
            }

            public final Either<DecodingFailure, NamedMantikId> decodeJson(Json j) {
                return Decoder.decodeJson$((Decoder)this, (Json)j);
            }

            public final AccumulatingDecoder<NamedMantikId> accumulating() {
                return Decoder.accumulating$((Decoder)this);
            }

            public final <B> Decoder<B> map(Function1<NamedMantikId, B> f) {
                return Decoder.map$((Decoder)this, f);
            }

            public final <B> Decoder<B> flatMap(Function1<NamedMantikId, Decoder<B>> f) {
                return Decoder.flatMap$((Decoder)this, f);
            }

            public final Decoder<NamedMantikId> handleErrorWith(Function1<DecodingFailure, Decoder<NamedMantikId>> f) {
                return Decoder.handleErrorWith$((Decoder)this, f);
            }

            public final Decoder<NamedMantikId> withErrorMessage(String message) {
                return Decoder.withErrorMessage$((Decoder)this, (String)message);
            }

            public final Decoder<NamedMantikId> ensure(Function1<NamedMantikId, Object> pred, Function0<String> message) {
                return Decoder.ensure$((Decoder)this, pred, message);
            }

            public final Decoder<NamedMantikId> ensure(Function1<NamedMantikId, List<String>> errors) {
                return Decoder.ensure$((Decoder)this, errors);
            }

            public final Decoder<NamedMantikId> validate(Function1<HCursor, List<String>> errors) {
                return Decoder.validate$((Decoder)this, errors);
            }

            public final Decoder<NamedMantikId> validate(Function1<HCursor, Object> pred, Function0<String> message) {
                return Decoder.validate$((Decoder)this, pred, message);
            }

            public final Kleisli<Either, HCursor, NamedMantikId> kleisli() {
                return Decoder.kleisli$((Decoder)this);
            }

            public final <B> Decoder<Tuple2<NamedMantikId, B>> product(Decoder<B> fb) {
                return Decoder.product$((Decoder)this, fb);
            }

            public final <AA> Decoder<AA> or(Function0<Decoder<AA>> d) {
                return Decoder.or$((Decoder)this, d);
            }

            public final <B> Decoder<Either<NamedMantikId, B>> either(Decoder<B> decodeB) {
                return Decoder.either$((Decoder)this, decodeB);
            }

            public final Decoder<NamedMantikId> prepare(Function1<ACursor, ACursor> f) {
                return Decoder.prepare$((Decoder)this, f);
            }

            public final <B> Decoder<B> emap(Function1<NamedMantikId, Either<String, B>> f) {
                return Decoder.emap$((Decoder)this, f);
            }

            public final <B> Decoder<B> emapTry(Function1<NamedMantikId, Try<B>> f) {
                return Decoder.emapTry$((Decoder)this, f);
            }

            public Either<DecodingFailure, NamedMantikId> apply(HCursor c) {
                Left left;
                Option option = c.value().asString();
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply("Expected string", (Function0 & Serializable & scala.Serializable)() -> c.history()));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String s = (String)some.value();
                    left = NamedMantikId$.MODULE$.decodeString(s).left().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.wrapInDecodingFailure());
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            }
            {
                Decoder.$init$((Decoder)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$4(io.circe.HCursor ), $anonfun$apply$5(ai.mantik.elements.errors.InvalidMantikIdException )}, serializedLambda);
            }
        };
        this.mantikIdCodec = new Encoder<NamedMantikId>(){

            public Validated<NonEmptyList<DecodingFailure>, NamedMantikId> decodeAccumulating(HCursor c) {
                return Decoder.decodeAccumulating$((Decoder)this, (HCursor)c);
            }

            public Either<DecodingFailure, NamedMantikId> tryDecode(ACursor c) {
                return Decoder.tryDecode$((Decoder)this, (ACursor)c);
            }

            public Validated<NonEmptyList<DecodingFailure>, NamedMantikId> tryDecodeAccumulating(ACursor c) {
                return Decoder.tryDecodeAccumulating$((Decoder)this, (ACursor)c);
            }

            public final Either<DecodingFailure, NamedMantikId> decodeJson(Json j) {
                return Decoder.decodeJson$((Decoder)this, (Json)j);
            }

            public final AccumulatingDecoder<NamedMantikId> accumulating() {
                return Decoder.accumulating$((Decoder)this);
            }

            public final <B> Decoder<B> map(Function1<NamedMantikId, B> f) {
                return Decoder.map$((Decoder)this, f);
            }

            public final <B> Decoder<B> flatMap(Function1<NamedMantikId, Decoder<B>> f) {
                return Decoder.flatMap$((Decoder)this, f);
            }

            public final Decoder<NamedMantikId> handleErrorWith(Function1<DecodingFailure, Decoder<NamedMantikId>> f) {
                return Decoder.handleErrorWith$((Decoder)this, f);
            }

            public final Decoder<NamedMantikId> withErrorMessage(String message) {
                return Decoder.withErrorMessage$((Decoder)this, (String)message);
            }

            public final Decoder<NamedMantikId> ensure(Function1<NamedMantikId, Object> pred, Function0<String> message) {
                return Decoder.ensure$((Decoder)this, pred, message);
            }

            public final Decoder<NamedMantikId> ensure(Function1<NamedMantikId, List<String>> errors) {
                return Decoder.ensure$((Decoder)this, errors);
            }

            public final Decoder<NamedMantikId> validate(Function1<HCursor, List<String>> errors) {
                return Decoder.validate$((Decoder)this, errors);
            }

            public final Decoder<NamedMantikId> validate(Function1<HCursor, Object> pred, Function0<String> message) {
                return Decoder.validate$((Decoder)this, pred, message);
            }

            public final Kleisli<Either, HCursor, NamedMantikId> kleisli() {
                return Decoder.kleisli$((Decoder)this);
            }

            public final <B> Decoder<Tuple2<NamedMantikId, B>> product(Decoder<B> fb) {
                return Decoder.product$((Decoder)this, fb);
            }

            public final <AA> Decoder<AA> or(Function0<Decoder<AA>> d) {
                return Decoder.or$((Decoder)this, d);
            }

            public final <B> Decoder<Either<NamedMantikId, B>> either(Decoder<B> decodeB) {
                return Decoder.either$((Decoder)this, decodeB);
            }

            public final Decoder<NamedMantikId> prepare(Function1<ACursor, ACursor> f) {
                return Decoder.prepare$((Decoder)this, f);
            }

            public final <B> Decoder<B> emap(Function1<NamedMantikId, Either<String, B>> f) {
                return Decoder.emap$((Decoder)this, f);
            }

            public final <B> Decoder<B> emapTry(Function1<NamedMantikId, Try<B>> f) {
                return Decoder.emapTry$((Decoder)this, f);
            }

            public final <B> Encoder<B> contramap(Function1<B, NamedMantikId> f) {
                return Encoder.contramap$((Encoder)this, f);
            }

            public final Encoder<NamedMantikId> mapJson(Function1<Json, Json> f) {
                return Encoder.mapJson$((Encoder)this, f);
            }

            public Json apply(NamedMantikId a) {
                return Json$.MODULE$.fromString(a.toString());
            }

            public Either<DecodingFailure, NamedMantikId> apply(HCursor c) {
                return c.as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)s -> NamedMantikId$.MODULE$.decodeStringResult((String)s).map((Function1 & Serializable & scala.Serializable)r -> r));
            }
            {
                Encoder.$init$((Encoder)this);
                Decoder.$init$((Decoder)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$6(java.lang.String ), $anonfun$apply$7(ai.mantik.elements.NamedMantikId )}, serializedLambda);
            }
        };
        this.NameRegex = new StringOps(Predef$.MODULE$.augmentString("^[a-z\\d](?:[a-z\\d_\\.]|-(?=[a-z\\d])){0,50}$")).r();
        this.AccountRegex = this.NameRegex();
        this.VersionRegex = new StringOps(Predef$.MODULE$.augmentString("^[a-z\\d]([a-z\\d_\\.\\-]*[a-z\\d])?$")).r();
    }
}

