/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.elements.errors;

import ai.mantik.elements.errors.ErrorCode;
import io.grpc.Status;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;

public final class ErrorCodes$ {
    public static final ErrorCodes$ MODULE$ = new ErrorCodes$();
    private static Seq<ErrorCode> defaultErrorCodes;
    private static final Builder<ErrorCode, Seq<ErrorCode>> defaultCodeBuilder;
    private static final ErrorCode RootCode;
    private static final ErrorCode MantikItem;
    private static final ErrorCode MantikItemNotFound;
    private static final ErrorCode MantikItemPayloadNotFound;
    private static final ErrorCode MantikItemWrongType;
    private static final ErrorCode MantikItemConflict;
    private static final ErrorCode MantikItemInvalidBridge;
    private static final ErrorCode InvalidMantikHeader;
    private static final ErrorCode InvalidMantikId;
    private static final ErrorCode Configuration;
    private static final ErrorCode LocalRegistry;
    private static final ErrorCode RemoteRegistryFailure;
    private static final ErrorCode RemoteRegistryCouldNotGetToken;
    private static final ErrorCode ProtocolError;
    private static final ErrorCode InternalError;
    private static volatile boolean bitmap$0;

    static {
        defaultCodeBuilder = package$.MODULE$.Seq().newBuilder();
        RootCode = new ErrorCode("", Status.Code.UNKNOWN);
        MantikItem = MODULE$.addCode("MantikItem", Status.Code.INVALID_ARGUMENT);
        MantikItemNotFound = MODULE$.add(MODULE$.MantikItem().derive("NotFound", (Option<Status.Code>)new Some((Object)Status.Code.NOT_FOUND)));
        MantikItemPayloadNotFound = MODULE$.add(MODULE$.MantikItem().derive("PayloadNotFound", (Option<Status.Code>)new Some((Object)Status.Code.NOT_FOUND)));
        MantikItemWrongType = MODULE$.add(MODULE$.MantikItem().derive("WrongType", (Option<Status.Code>)new Some((Object)Status.Code.INVALID_ARGUMENT)));
        MantikItemConflict = MODULE$.add(MODULE$.MantikItem().derive("Conflict", (Option<Status.Code>)new Some((Object)Status.Code.FAILED_PRECONDITION)));
        MantikItemInvalidBridge = MODULE$.add(MODULE$.MantikItem().derive("InvalidBridge", (Option<Status.Code>)new Some((Object)Status.Code.FAILED_PRECONDITION)));
        InvalidMantikHeader = MODULE$.addCode("InvalidMantikHeader", Status.Code.INVALID_ARGUMENT);
        InvalidMantikId = MODULE$.addCode("InvalidMantikId", Status.Code.INVALID_ARGUMENT);
        Configuration = MODULE$.addCode("Configuration", Status.Code.INTERNAL);
        LocalRegistry = MODULE$.addCode("LocalRegistry", Status.Code.INTERNAL);
        RemoteRegistryFailure = MODULE$.addCode("RemoteRegistry", Status.Code.UNKNOWN);
        RemoteRegistryCouldNotGetToken = MODULE$.add(MODULE$.RemoteRegistryFailure().derive("CouldNotGetToken", MODULE$.RemoteRegistryFailure().derive$default$2()));
        ProtocolError = MODULE$.addCode("ProtocolError", Status.Code.INVALID_ARGUMENT);
        InternalError = MODULE$.addCode("Internal", Status.Code.INTERNAL);
    }

    private Builder<ErrorCode, Seq<ErrorCode>> defaultCodeBuilder() {
        return defaultCodeBuilder;
    }

    private ErrorCode add(ErrorCode errorCode) {
        this.defaultCodeBuilder().$plus$eq((Object)errorCode);
        return errorCode;
    }

    /*
     * WARNING - void declaration
     */
    private ErrorCode addCode(String code, Status.Code grpcCode) {
        void var3_3;
        ErrorCode c = this.RootCode().derive(code, (Option<Status.Code>)new Some((Object)grpcCode));
        this.defaultCodeBuilder().$plus$eq((Object)c);
        return var3_3;
    }

    public ErrorCode RootCode() {
        return RootCode;
    }

    public ErrorCode MantikItem() {
        return MantikItem;
    }

    public ErrorCode MantikItemNotFound() {
        return MantikItemNotFound;
    }

    public ErrorCode MantikItemPayloadNotFound() {
        return MantikItemPayloadNotFound;
    }

    public ErrorCode MantikItemWrongType() {
        return MantikItemWrongType;
    }

    public ErrorCode MantikItemConflict() {
        return MantikItemConflict;
    }

    public ErrorCode MantikItemInvalidBridge() {
        return MantikItemInvalidBridge;
    }

    public ErrorCode InvalidMantikHeader() {
        return InvalidMantikHeader;
    }

    public ErrorCode InvalidMantikId() {
        return InvalidMantikId;
    }

    public ErrorCode Configuration() {
        return Configuration;
    }

    public ErrorCode LocalRegistry() {
        return LocalRegistry;
    }

    public ErrorCode RemoteRegistryFailure() {
        return RemoteRegistryFailure;
    }

    public ErrorCode RemoteRegistryCouldNotGetToken() {
        return RemoteRegistryCouldNotGetToken;
    }

    public ErrorCode ProtocolError() {
        return ProtocolError;
    }

    public ErrorCode InternalError() {
        return InternalError;
    }

    private Seq<ErrorCode> defaultErrorCodes$lzycompute() {
        ErrorCodes$ errorCodes$ = this;
        synchronized (errorCodes$) {
            if (!bitmap$0) {
                defaultErrorCodes = (Seq)this.defaultCodeBuilder().result();
                bitmap$0 = true;
            }
        }
        return defaultErrorCodes;
    }

    public Seq<ErrorCode> defaultErrorCodes() {
        return !bitmap$0 ? this.defaultErrorCodes$lzycompute() : defaultErrorCodes;
    }

    private ErrorCodes$() {
    }
}

