/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.engine.session;

import ai.mantik.engine.session.EngineErrors$;
import ai.mantik.engine.session.SessionBase;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0004\b\u0001/!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005;\u0001\t\u0005\t\u0015a\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007;\u0002\u0001\u000b\u0011\u0002+\t\u000fy\u0003!\u0019!C\u0005?\"1a\r\u0001Q\u0001\n\u0001DQa\u001a\u0001\u0005\u0002!DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001e\u0001\u0005\u0002U\u0014!cU3tg&|g.T1oC\u001e,'OQ1tK*\u0011q\u0002E\u0001\bg\u0016\u001c8/[8o\u0015\t\t\"#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003'Q\ta!\\1oi&\\'\"A\u000b\u0002\u0005\u0005L7\u0001A\u000b\u00031A\u001a\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u00039\u0019Xm]:j_:4\u0015m\u0019;pef\u0004BAG\u0011$]%\u0011!e\u0007\u0002\n\rVt7\r^5p]F\u0002\"\u0001J\u0016\u000f\u0005\u0015J\u0003C\u0001\u0014\u001c\u001b\u00059#B\u0001\u0015\u0017\u0003\u0019a$o\\8u}%\u0011!fG\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+7A\u0011q\u0006\r\u0007\u0001\t\u0015\t\u0004A1\u00013\u0005\u0005\u0019\u0016CA\u001a7!\tQB'\u0003\u000267\t9aj\u001c;iS:<\u0007CA\u001c9\u001b\u0005q\u0011BA\u001d\u000f\u0005-\u0019Vm]:j_:\u0014\u0015m]3\u0002\u0005\u0015\u001c\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u001c\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0001v\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\t\u0019e\t\u0006\u0002E\u000bB\u0019q\u0007\u0001\u0018\t\u000bi\u001a\u00019A\u001e\t\u000b}\u0019\u0001\u0019\u0001\u0011\u0002\r1|wmZ3s+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0013\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005A1/Z:tS>t7/F\u0001U!\u0011)6l\t\u0018\u000e\u0003YS!AP,\u000b\u0005aK\u0016\u0001B;uS2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]-\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002\u0013M,7o]5p]N\u0004\u0013A\u00028fqRLE-F\u0001a!\t\tG-D\u0001c\u0015\t\u0019g+\u0001\u0004bi>l\u0017nY\u0005\u0003K\n\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018a\u00028fqRLE\rI\u0001\u0007GJ,\u0017\r^3\u0015\u0003%\u00042\u0001\u00106/\u0013\tYWH\u0001\u0004GkR,(/Z\u0001\u0006G2|7/\u001a\u000b\u0003]J\u00042\u0001\u00106p!\tQ\u0002/\u0003\u0002r7\t!QK\\5u\u0011\u0015\u00198\u00021\u0001$\u0003%\u0019Xm]:j_:LE-A\u0002hKR$\"!\u001b<\t\u000b]d\u0001\u0019A\u0012\u0002\u0005%$\u0007")
public class SessionManagerBase<S extends SessionBase> {
    private final Function1<String, S> sessionFactory;
    private final ExecutionContext ec;
    private final Logger logger;
    private final ConcurrentHashMap<String, S> sessions;
    private final AtomicInteger nextId;

    private Logger logger() {
        return this.logger;
    }

    private ConcurrentHashMap<String, S> sessions() {
        return this.sessions;
    }

    private AtomicInteger nextId() {
        return this.nextId;
    }

    public Future<S> create() {
        String id = new StringBuilder(1).append("s").append(this.nextId().incrementAndGet()).toString();
        SessionBase session = (SessionBase)this.sessionFactory.apply((Object)id);
        Option previous = Option$.MODULE$.apply((Object)this.sessions().put(id, session));
        if (previous.isDefined()) {
            throw new IllegalStateException("Session already exists?!");
        }
        this.logger().info(new StringBuilder(16).append("Created session ").append(id).toString());
        return Future$.MODULE$.successful((Object)session);
    }

    public Future<BoxedUnit> close(String sessionId) {
        Option session = Option$.MODULE$.apply(this.sessions().remove(sessionId));
        if (session.isEmpty()) {
            this.logger().info(new StringBuilder(18).append("Session ").append(sessionId).append(" not found").toString());
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info(new StringBuilder(14).append("Shutting down ").append(sessionId).toString());
            session.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.quitSession();
                return BoxedUnit.UNIT;
            });
        }, this.ec);
    }

    public Future<S> get(String id) {
        Future future;
        Option option = Option$.MODULE$.apply(this.sessions().get(id));
        if (option instanceof Some) {
            Some some = (Some)option;
            SessionBase session = (SessionBase)some.value();
            future = Future$.MODULE$.successful((Object)session);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.failed((Throwable)EngineErrors$.MODULE$.SessionNotFound().toException(id, EngineErrors$.MODULE$.SessionNotFound().toException$default$2()));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    public SessionManagerBase(Function1<String, S> sessionFactory, ExecutionContext ec) {
        this.sessionFactory = sessionFactory;
        this.ec = ec;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.sessions = new ConcurrentHashMap();
        this.nextId = new AtomicInteger();
    }
}

