/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.pipelines;

import ai.mantik.ds.DataType;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.element.Bundle;
import ai.mantik.ds.element.SingleElementBundle;
import ai.mantik.ds.formats.json.JsonFormat$;
import ai.mantik.ds.functional.FunctionType;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.Select$;
import ai.mantik.elements.MantikHeader;
import ai.mantik.elements.MantikId;
import ai.mantik.elements.PipelineDefinition;
import ai.mantik.elements.PipelineStep;
import ai.mantik.elements.meta.MetaVariable;
import ai.mantik.elements.meta.MetaVariableException;
import ai.mantik.elements.meta.MetaVariableException$;
import ai.mantik.planner.Algorithm;
import ai.mantik.planner.MantikItem;
import ai.mantik.planner.pipelines.InvalidPipelineException;
import ai.mantik.planner.pipelines.InvalidPipelineException$;
import ai.mantik.planner.pipelines.PipelineException;
import ai.mantik.planner.pipelines.PipelineTypeException;
import ai.mantik.planner.pipelines.ResolvedPipeline;
import ai.mantik.planner.pipelines.ResolvedPipelineStep;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PipelineResolver$ {
    public static PipelineResolver$ MODULE$;

    static {
        new PipelineResolver$();
    }

    public Either<PipelineException, ResolvedPipeline> resolvePipeline(MantikHeader<PipelineDefinition> mantikHeader, Map<MantikId, MantikItem> algorithms) {
        Left left;
        try {
            DataType inputType = this.figureOutInputType(mantikHeader, algorithms);
            Tuple2 tuple2 = this.foldingMap((List)((PipelineDefinition)mantikHeader.definition()).steps().zipWithIndex(List$.MODULE$.canBuildFrom()), inputType, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                DataType currentType;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        currentType = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                PipelineStep step = (PipelineStep)tuple2._1();
                int stepNum = tuple2._2$mcI$sp();
                ResolvedPipelineStep resolvedPipelineStep = MODULE$.resolvePipelineStep(stepNum, currentType, step, algorithms);
                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resolvedPipelineStep), (Object)resolvedPipelineStep.functionType().output());
                return tuple23;
            });
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List steps = (List)tuple2._1();
            DataType outputType = (DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)steps, (Object)outputType);
            Tuple2 tuple23 = tuple22;
            List steps2 = (List)tuple23._1();
            DataType outputType2 = (DataType)tuple23._2();
            ((PipelineDefinition)mantikHeader.definition()).outputType().foreach((Function1 & Serializable & scala.Serializable)expectedOutputType -> {
                PipelineResolver$.$anonfun$resolvePipeline$2(outputType2, expectedOutputType);
                return BoxedUnit.UNIT;
            });
            left = package$.MODULE$.Right().apply((Object)new ResolvedPipeline((List<ResolvedPipelineStep>)steps2, new FunctionType(inputType, outputType2)));
        }
        catch (PipelineException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        catch (Exception o) {
            left = package$.MODULE$.Left().apply((Object)new PipelineException(o.getMessage(), o));
        }
        return left;
    }

    private <A, B, S> Tuple2<List<B>, S> foldingMap(List<A> in, S initial, Function2<A, S, Tuple2<B, S>> f) {
        Builder builder = List$.MODULE$.newBuilder();
        ObjectRef s = ObjectRef.create(initial);
        in.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Object newState;
            Tuple2 tuple2 = (Tuple2)f.apply(value, s$1.elem);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object transformed = tuple2._1();
            Object newState2 = tuple2._2();
            Tuple2 tuple22 = new Tuple2(transformed, newState2);
            Tuple2 tuple23 = tuple22;
            Object transformed2 = tuple23._1();
            s$1.elem = newState = tuple23._2();
            return builder.$plus$eq(transformed2);
        });
        return new Tuple2(builder.result(), s.elem);
    }

    private DataType figureOutInputType(MantikHeader<PipelineDefinition> mantikHeader, Map<MantikId, MantikItem> algorithms) {
        return (DataType)((PipelineDefinition)mantikHeader.definition()).inputType().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            PipelineStep as;
            block6: {
                Option option;
                Some some;
                boolean bl;
                block5: {
                    bl = false;
                    some = null;
                    option = ((PipelineDefinition)mantikHeader.definition()).steps().headOption();
                    if (None$.MODULE$.equals(option)) {
                        throw new InvalidPipelineException("Empty Pipeline", InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (!(option instanceof Some)) break block5;
                    bl = true;
                    some = (Some)option;
                    as = (PipelineStep)some.value();
                    if (as instanceof PipelineStep.AlgorithmStep) break block6;
                }
                if (bl) {
                    PipelineStep other = (PipelineStep)some.value();
                    throw new InvalidPipelineException(new StringBuilder(93).append("Cannot deduct input type of pipeline, either describe it or let it start with algorithm, got ").append(other).toString(), InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
                }
                throw new MatchError((Object)option);
            }
            PipelineStep.AlgorithmStep algorithmStep = (PipelineStep.AlgorithmStep)as;
            DataType dataType = MODULE$.resolveAlgorithmPipelineStep(0, (Option<DataType>)None$.MODULE$, algorithmStep, algorithms).functionType().input();
            return dataType;
        });
    }

    private ResolvedPipelineStep resolvePipelineStep(int stepNum, DataType inputDataType, PipelineStep pipelineStep, Map<MantikId, MantikItem> algorithms) {
        ResolvedPipelineStep resolvedPipelineStep;
        PipelineStep pipelineStep2 = pipelineStep;
        if (pipelineStep2 instanceof PipelineStep.AlgorithmStep) {
            PipelineStep.AlgorithmStep algorithmStep = (PipelineStep.AlgorithmStep)pipelineStep2;
            resolvedPipelineStep = this.resolveAlgorithmPipelineStep(stepNum, (Option<DataType>)new Some((Object)inputDataType), algorithmStep, algorithms);
        } else if (pipelineStep2 instanceof PipelineStep.SelectStep) {
            PipelineStep.SelectStep selectStep = (PipelineStep.SelectStep)pipelineStep2;
            resolvedPipelineStep = this.resolveSelectStep(stepNum, inputDataType, selectStep);
        } else {
            throw new MatchError((Object)pipelineStep2);
        }
        return resolvedPipelineStep;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResolvedPipelineStep.AlgorithmStep resolveAlgorithmPipelineStep(int stepNum, Option<DataType> incomingDataType, PipelineStep.AlgorithmStep as, Map<MantikId, MantikItem> algorithms) {
        boolean bl = false;
        Some some = null;
        Option option = algorithms.get((Object)as.algorithm());
        if (None$.MODULE$.equals(option)) {
            throw new InvalidPipelineException(new StringBuilder(16).append("Missing element ").append(as.algorithm()).toString(), InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            MantikItem algorithm = (MantikItem)some.value();
            if (algorithm instanceof Algorithm) {
                Algorithm algorithm2;
                Algorithm algorithm3 = (Algorithm)algorithm;
                try {
                    algorithm2 = this.applyMetaVariables(algorithm3, (List<PipelineStep.MetaVariableSetting>)((List)as.metaVariables().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)));
                }
                catch (MetaVariableException e) {
                    throw new InvalidPipelineException(new StringBuilder(40).append("Could not apply meta variables to step ").append(stepNum).append("/").append(as.algorithm()).toString(), e);
                }
                Algorithm algorithmWithMetaVariables = algorithm2;
                incomingDataType.foreach((Function1 & Serializable & scala.Serializable)inputDataType -> {
                    PipelineResolver$.$anonfun$resolveAlgorithmPipelineStep$2(algorithmWithMetaVariables, stepNum, inputDataType);
                    return BoxedUnit.UNIT;
                });
                return new ResolvedPipelineStep.AlgorithmStep(algorithmWithMetaVariables);
            }
        }
        if (!bl) throw new MatchError((Object)option);
        MantikItem other = (MantikItem)some.value();
        throw new InvalidPipelineException(new StringBuilder(32).append(as.algorithm()).append(" references no algorithm but an ").append(other.getClass().getSimpleName()).toString(), InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
    }

    private ResolvedPipelineStep.SelectStep resolveSelectStep(int stepNum, DataType inputDataType, PipelineStep.SelectStep s) {
        Select select;
        DataType dataType = inputDataType;
        if (dataType instanceof TabularData) {
            Select ok;
            TabularData tabularData = (TabularData)dataType;
            Either either = Select$.MODULE$.parse(tabularData, s.select());
            if (either instanceof Left) {
                Left left = (Left)either;
                String msg = (String)left.value();
                throw new InvalidPipelineException(new StringBuilder(24).append("Could not parse select: ").append(msg).toString(), InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            select = ok = (Select)right.value();
        } else {
            throw new PipelineTypeException(new StringBuilder(60).append("Only tabular data types can be transformed via selects, got ").append(dataType).toString());
        }
        Select select2 = select;
        Select select3 = select2;
        return new ResolvedPipelineStep.SelectStep(select3);
    }

    private Algorithm applyMetaVariables(Algorithm algorithm, List<PipelineStep.MetaVariableSetting> metaVariables) {
        if (metaVariables.isEmpty()) {
            return algorithm;
        }
        List newValues = (List)metaVariables.map((Function1 & Serializable & scala.Serializable)ms -> {
            MetaVariable mv = (MetaVariable)algorithm.mantikHeader().metaJson().metaVariable(ms.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new InvalidPipelineException(new StringBuilder(38).append("Meta variable ").append(ms.name()).append(" not found in algorithm ").append(algorithm).toString(), InvalidPipelineException$.MODULE$.$lessinit$greater$default$2());
            });
            Either either = JsonFormat$.MODULE$.deserializeBundleValue(mv.value().model(), ms.value());
            if (either instanceof Left) {
                throw new MetaVariableException(new StringBuilder(62).append("Meta variable ").append(ms.name()).append(" cannot be applied to ").append(ms.value()).append(", invalid type (expected ").append(mv.value().model()).append(")").toString(), MetaVariableException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Bundle ok = (Bundle)right.value();
            SingleElementBundle singleElementBundle = ok.toSingleElementBundle();
            SingleElementBundle newValue = singleElementBundle;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mv.name()), (Object)newValue);
        }, List$.MODULE$.canBuildFrom());
        return (Algorithm)algorithm.withMetaValues((Seq<Tuple2<String, SingleElementBundle>>)newValues);
    }

    public static final /* synthetic */ void $anonfun$resolvePipeline$2(DataType outputType$1, DataType expectedOutputType) {
        DataType dataType = expectedOutputType;
        DataType dataType2 = outputType$1;
        if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
            throw new PipelineTypeException(new StringBuilder(59).append("Expected output type ").append(expectedOutputType).append(" doesn't match calculated output type ").append(outputType$1).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAlgorithmPipelineStep$2(Algorithm algorithmWithMetaVariables$1, int stepNum$1, DataType inputDataType) {
        DataType dataType = algorithmWithMetaVariables$1.functionType().input();
        DataType dataType2 = inputDataType;
        if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
            throw new PipelineTypeException(new StringBuilder(39).append("Type mismatch on step").append(stepNum$1).append(", input ").append(inputDataType).append(" expected ").append(algorithmWithMetaVariables$1.functionType().input()).toString());
        }
    }

    private PipelineResolver$() {
        MODULE$ = this;
    }
}

