/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.repository.impl;

import ai.mantik.componently.AkkaRuntime;
import ai.mantik.componently.ComponentBase;
import ai.mantik.elements.errors.ConfigurationException;
import ai.mantik.planner.repository.FileRepository;
import ai.mantik.planner.repository.FileRepository$;
import ai.mantik.planner.repository.impl.LocalFileRepository$;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.Cancellable;
import akka.stream.IOResult;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\r}e\u0001B$I\u0001MC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005A\"I1\u000e\u0001B\u0001B\u0003-An\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006a\u0002!\ta\u001e\u0005\n\u0003\u000f\u0001!\u0019!C\t\u0003\u0013A\u0001\"a\b\u0001A\u0003%\u00111\u0002\u0005\n\u0003C\u0001!\u0019!C\u0001\u0003GA\u0001\"!\u000f\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003GA\u0001\"!\u0010\u0001A\u0003%\u0011Q\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011)\tY\u0005\u0001b\u0001\n\u0003A\u0015Q\n\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002P!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\t9\f\u0001C!\u0003sCq!a9\u0001\t\u0003\n)\u000fC\u0004\u0002r\u0002!\t%a=\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;Aqa!\u0018\u0001\t\u0013\u0019y\u0006C\u0004\u0004h\u0001!\t!!\u0011\t\u000f\r%\u0004\u0001\"\u0003\u0004l!A1\u0011\u0011\u0001\u0005\u0002!\u001b\u0019\tC\u0004\u0004\u0006\u0002!\tea\"\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"i11\u0013\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0004\u0016><qAa\u000eI\u0011\u0003\u0011ID\u0002\u0004H\u0011\"\u0005!1\b\u0005\u0007a\n\"\tAa\u0011\t\u0013\t\u0015#E1A\u0005\u0002\t\u001d\u0003\u0002\u0003B*E\u0001\u0006IA!\u0013\t\u0013\tU#E1A\u0005\u0002\t\u001d\u0003\u0002\u0003B,E\u0001\u0006IA!\u0013\u0007\r\te#\u0005\u0011B.\u0011)\t9\n\u000bBK\u0002\u0013\u0005!\u0011\u000e\u0005\u000b\u0005WB#\u0011#Q\u0001\n\u0005\u0015\u0004BCANQ\tU\r\u0011\"\u0001\u0003n!Q!q\u000e\u0015\u0003\u0012\u0003\u0006I!!(\t\u0015\tE\u0004F!f\u0001\n\u0003\u0011\u0019\b\u0003\u0006\u0003\u0002\"\u0012\t\u0012)A\u0005\u0005kBa\u0001\u001d\u0015\u0005\u0002\t\r\u0005\"CAyQ\u0005\u0005I\u0011\u0001BH\u0011%\u00119\nKI\u0001\n\u0003\u0011I\nC\u0005\u00030\"\n\n\u0011\"\u0001\u00032\"I!Q\u0017\u0015\u0012\u0002\u0013\u0005!q\u0017\u0005\n\u0005wC\u0013\u0011!C!\u0005\u000fB\u0011B!0)\u0003\u0003%\tAa0\t\u0013\t\u001d\u0007&!A\u0005\u0002\t%\u0007\"\u0003BkQ\u0005\u0005I\u0011\tBl\u0011%\u0011)\u000fKA\u0001\n\u0003\u00119\u000fC\u0005\u0003l\"\n\t\u0011\"\u0011\u0003n\"I!q\u001e\u0015\u0002\u0002\u0013\u0005#\u0011\u001f\u0005\n\u0005gD\u0013\u0011!C!\u0005k<\u0011B!?#\u0003\u0003E\tAa?\u0007\u0013\te#%!A\t\u0002\tu\bB\u00029>\t\u0003\u0019Y\u0001C\u0005\u0003pv\n\t\u0011\"\u0012\u0003r\"I1QB\u001f\u0002\u0002\u0013\u00055q\u0002\u0005\n\u0007/i\u0014\u0013!C\u0001\u0005cC\u0011b!\u0007>\u0003\u0003%\tia\u0007\t\u0013\r5R(%A\u0005\u0002\tE\u0006\"CB\u0018{\u0005\u0005I\u0011BB\u0019\u0011%\u0019ID\tb\u0001\n\u0007\u0019Y\u0004\u0003\u0005\u0004Z\t\u0002\u000b\u0011BB\u001f\u0005MaunY1m\r&dWMU3q_NLGo\u001c:z\u0015\tI%*\u0001\u0003j[Bd'BA&M\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u001b:\u000bq\u0001\u001d7b]:,'O\u0003\u0002P!\u00061Q.\u00198uS.T\u0011!U\u0001\u0003C&\u001c\u0001aE\u0002\u0001)j\u0003\"!\u0016-\u000e\u0003YS!a\u0016(\u0002\u0017\r|W\u000e]8oK:$H._\u0005\u00033Z\u0013QbQ8na>tWM\u001c;CCN,\u0007CA.]\u001b\u0005Q\u0015BA/K\u000591\u0015\u000e\\3SKB|7/\u001b;pef\f\u0011\u0002Z5sK\u000e$xN]=\u0016\u0003\u0001\u0004\"!\u00195\u000e\u0003\tT!a\u00193\u0002\t\u0019LG.\u001a\u0006\u0003K\u001a\f1A\\5p\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b2\u0003\tA\u000bG\u000f[\u0001\u000bI&\u0014Xm\u0019;pef\u0004\u0013aC1lW\u0006\u0014VO\u001c;j[\u0016\u0004\"!V7\n\u000594&aC!lW\u0006\u0014VO\u001c;j[\u0016L!a\u001b-\u0002\rqJg.\u001b;?)\t\u0011h\u000f\u0006\u0002tkB\u0011A\u000fA\u0007\u0002\u0011\")1\u000e\u0002a\u0002Y\")a\f\u0002a\u0001AR\t\u0001\u0010\u0006\u0002ts\")1.\u0002a\u0002Y\"\u0012Qa\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018AB5oU\u0016\u001cGO\u0003\u0002\u0002\u0002\u0005)!.\u0019<bq&\u0019\u0011QA?\u0003\r%s'.Z2u\u0003%\u0019XOY\"p]\u001aLw-\u0006\u0002\u0002\fA!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB2p]\u001aLwM\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005e\u0011aA2p[&!\u0011QDA\b\u0005\u0019\u0019uN\u001c4jO\u0006Q1/\u001e2D_:4\u0017n\u001a\u0011\u0002\u001f\rdW-\u00198va&sG/\u001a:wC2,\"!!\n\u0011\t\u0005\u001d\u0012QG\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005AA-\u001e:bi&|gN\u0003\u0003\u00020\u0005E\u0012AC2p]\u000e,(O]3oi*\u0011\u00111G\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003o\tIC\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002!\rdW-\u00198va&sG/\u001a:wC2\u0004\u0013AD2mK\u0006tW\u000f\u001d+j[\u0016|W\u000f^\u0001\u0010G2,\u0017M\\;q)&lWm\\;uA\u0005yQM\\:ve\u0016$\u0015N]3di>\u0014\u0018\u0010\u0006\u0002\u0002DA!\u0011QIA$\u001b\t\t\t$\u0003\u0003\u0002J\u0005E\"\u0001B+oSR\f\u0001\u0003^5nK>,HoU2iK\u0012,H.\u001a:\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u00033\nA!Y6lC&!\u0011QLA*\u0005-\u0019\u0015M\\2fY2\f'\r\\3\u0002#QLW.Z8viN\u001b\u0007.\u001a3vY\u0016\u0014\b%A\u0005nC.,g*Z<JIR\u0011\u0011Q\r\t\u0005\u0003O\n)H\u0004\u0003\u0002j\u0005E\u0004\u0003BA6\u0003ci!!!\u001c\u000b\u0007\u0005=$+\u0001\u0004=e>|GOP\u0005\u0005\u0003g\n\t$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003g\n\t$\u0001\nsKF,Xm\u001d;GS2,7\u000b^8sC\u001e,GCBA@\u0003+\u000bI\n\u0005\u0004\u0002\u0002\u0006\r\u0015qQ\u0007\u0003\u0003[IA!!\"\u0002.\t1a)\u001e;ve\u0016\u0004B!!#\u0002\u0010:\u00191,a#\n\u0007\u00055%*\u0001\bGS2,'+\u001a9pg&$xN]=\n\t\u0005E\u00151\u0013\u0002\u0012\r&dWm\u0015;pe\u0006<WMU3tk2$(bAAG\u0015\"9\u0011q\u0013\tA\u0002\u0005\u0015\u0014aC2p]R,g\u000e\u001e+za\u0016Dq!a'\u0011\u0001\u0004\ti*A\u0005uK6\u0004xN]1ssB!\u0011QIAP\u0013\u0011\t\t+!\r\u0003\u000f\t{w\u000e\\3b]\u0006q!/Z9vKN$h)\u001b7f\u000f\u0016$HCBAT\u0003_\u000b\u0019\f\u0005\u0004\u0002\u0002\u0006\r\u0015\u0011\u0016\t\u0005\u0003\u0013\u000bY+\u0003\u0003\u0002.\u0006M%!\u0004$jY\u0016<U\r\u001e*fgVdG\u000fC\u0004\u00022F\u0001\r!!\u001a\u0002\u0005%$\u0007\"CA[#A\u0005\t\u0019AAO\u0003)y\u0007\u000f^5nSN$\u0018nY\u0001\ngR|'/\u001a$jY\u0016$B!a/\u0002bB1\u0011\u0011QAB\u0003{\u0003\u0002\"a0\u0002J\u00065\u0017\u0011\\\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006A1oY1mC\u0012\u001cHN\u0003\u0003\u0002H\u0006]\u0013AB:ue\u0016\fW.\u0003\u0003\u0002L\u0006\u0005'\u0001B*j].\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f9&\u0001\u0003vi&d\u0017\u0002BAl\u0003#\u0014!BQ=uKN#(/\u001b8h!\u0019\t\t)a!\u0002\\B!\u0011QIAo\u0013\u0011\ty.!\r\u0003\t1{gn\u001a\u0005\b\u0003c\u0013\u0002\u0019AA3\u0003!aw.\u00193GS2,G\u0003BAt\u0003_\u0004b!!!\u0002\u0004\u0006%\b\u0003BAE\u0003WLA!!<\u0002\u0014\nqAj\\1e\r&dWMU3tk2$\bbBAY'\u0001\u0007\u0011QM\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002v\u0006]\u00181 \t\u0007\u0003\u0003\u000b\u0019)a\u0011\t\u000f\u0005eH\u00031\u0001\u0002f\u0005!aM]8n\u0011\u001d\ti\u0010\u0006a\u0001\u0003K\n!\u0001^8\u0002\u0011\u0019LG.\u001a(b[\u0016$2\u0001\u0019B\u0002\u0011\u001d\t\t,\u0006a\u0001\u0003K\nA\"\\3uC\u001aKG.\u001a(b[\u0016$2\u0001\u0019B\u0005\u0011\u001d\t\tL\u0006a\u0001\u0003K\nA\u0002]1si\u001aKG.\u001a(b[\u0016$2\u0001\u0019B\b\u0011\u001d\t\tl\u0006a\u0001\u0003K\nqA]3t_24X\rF\u0003a\u0005+\u00119\u0002C\u0004\u00022b\u0001\r!!\u001a\t\u000f\te\u0001\u00041\u0001\u0002f\u00051QM\u001c3j]\u001e\f\u0001\u0002\\8bI6+G/\u0019\u000b\u0005\u0005?\u0019Y\u0006E\u0002\u0003\"!r1Aa\t\"\u001d\u0011\u0011)C!\u000e\u000f\t\t\u001d\"1\u0007\b\u0005\u0005S\u0011\tD\u0004\u0003\u0003,\t=b\u0002BA6\u0005[I\u0011!U\u0005\u0003\u001fBK!!\u0014(\n\u0005-c\u0015BA%K\u0003MaunY1m\r&dWMU3q_NLGo\u001c:z!\t!(eE\u0002#\u0005{\u0001B!!\u0012\u0003@%!!\u0011IA\u0019\u0005\u0019\te.\u001f*fMR\u0011!\u0011H\u0001\u0013\t&\u0014Xm\u0019;pef\u001cuN\u001c4jO.+\u00170\u0006\u0002\u0003JA!!1\nB)\u001b\t\u0011iEC\u0002\u0003P\u0019\fA\u0001\\1oO&!\u0011q\u000fB'\u0003M!\u0015N]3di>\u0014\u0018pQ8oM&<7*Z=!\u0003)iU\r^1F]\u0012LgnZ\u0001\f\u001b\u0016$\u0018-\u00128eS:<\u0007E\u0001\u0007GS2,W*\u001a;b\t\u0006$\u0018mE\u0004)\u0005{\u0011iFa\u0019\u0011\t\u0005\u0015#qL\u0005\u0005\u0005C\n\tDA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015#QM\u0005\u0005\u0005O\n\tD\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0006\u0002\u0002f\u0005a1m\u001c8uK:$H+\u001f9fAU\u0011\u0011QT\u0001\u000bi\u0016l\u0007o\u001c:bef\u0004\u0013a\u0003:fcV,7\u000f\u001e+j[\u0016,\"A!\u001e\u0011\t\t]$QP\u0007\u0003\u0005sR1Aa\u001fg\u0003\u0011!\u0018.\\3\n\t\t}$\u0011\u0010\u0002\b\u0013:\u001cH/\u00198u\u00031\u0011X-];fgR$\u0016.\\3!)!\u0011)I!#\u0003\f\n5\u0005c\u0001BDQ5\t!\u0005C\u0004\u0002\u0018>\u0002\r!!\u001a\t\u0013\u0005mu\u0006%AA\u0002\u0005u\u0005b\u0002B9_\u0001\u0007!Q\u000f\u000b\t\u0005\u000b\u0013\tJa%\u0003\u0016\"I\u0011q\u0013\u0019\u0011\u0002\u0003\u0007\u0011Q\r\u0005\n\u00037\u0003\u0004\u0013!a\u0001\u0003;C\u0011B!\u001d1!\u0003\u0005\rA!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0014\u0016\u0005\u0003K\u0012ij\u000b\u0002\u0003 B!!\u0011\u0015BV\u001b\t\u0011\u0019K\u0003\u0003\u0003&\n\u001d\u0016!C;oG\",7m[3e\u0015\u0011\u0011I+!\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003.\n\r&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BZU\u0011\tiJ!(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0018\u0016\u0005\u0005k\u0012i*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u0003\u0004B!!\u0012\u0003D&!!QYA\u0019\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011YM!5\u0011\t\u0005\u0015#QZ\u0005\u0005\u0005\u001f\f\tDA\u0002B]fD\u0011Ba57\u0003\u0003\u0005\rA!1\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u000e\u0005\u0004\u0003\\\n\u0005(1Z\u0007\u0003\u0005;TAAa8\u00022\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r(Q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001e\n%\b\"\u0003Bjq\u0005\u0005\t\u0019\u0001Bf\u0003!A\u0017m\u001d5D_\u0012,GC\u0001Ba\u0003!!xn\u0015;sS:<GC\u0001B%\u0003\u0019)\u0017/^1mgR!\u0011Q\u0014B|\u0011%\u0011\u0019nOA\u0001\u0002\u0004\u0011Y-\u0001\u0007GS2,W*\u001a;b\t\u0006$\u0018\rE\u0002\u0003\bv\u001aR!\u0010B\u0000\u0005G\u0002Bb!\u0001\u0004\b\u0005\u0015\u0014Q\u0014B;\u0005\u000bk!aa\u0001\u000b\t\r\u0015\u0011\u0011G\u0001\beVtG/[7f\u0013\u0011\u0019Iaa\u0001\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003|\u0006)\u0011\r\u001d9msRA!QQB\t\u0007'\u0019)\u0002C\u0004\u0002\u0018\u0002\u0003\r!!\u001a\t\u0013\u0005m\u0005\t%AA\u0002\u0005u\u0005b\u0002B9\u0001\u0002\u0007!QO\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BB\u000f\u0007S\u0001b!!\u0012\u0004 \r\r\u0012\u0002BB\u0011\u0003c\u0011aa\u00149uS>t\u0007CCA#\u0007K\t)'!(\u0003v%!1qEA\u0019\u0005\u0019!V\u000f\u001d7fg!I11\u0006\"\u0002\u0002\u0003\u0007!QQ\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GCAB\u001a!\u0011\u0011Ye!\u000e\n\t\r]\"Q\n\u0002\u0007\u001f\nTWm\u0019;\u0002\u001d5,G/\u0019#bi\u00064uN]7biV\u00111Q\b\n\u0007\u0007\u007f\u0019\u0019ea\u0015\u0007\r\r\u0005#\u0005AB\u001f\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0019\u0019)ea\u0014\u0003\u00066\u00111q\t\u0006\u0005\u0007\u0013\u001aY%A\u0003dSJ\u001cWM\u0003\u0002\u0004N\u0005\u0011\u0011n\\\u0005\u0005\u0007#\u001a9EA\u0004F]\u000e|G-\u001a:\u0011\r\r\u00153Q\u000bBC\u0013\u0011\u00199fa\u0012\u0003\u000f\u0011+7m\u001c3fe\u0006yQ.\u001a;b\t\u0006$\u0018MR8s[\u0006$\b\u0005C\u0004\u00022f\u0001\r!!\u001a\u0002\u0011M\fg/Z'fi\u0006$b!a\u0011\u0004b\r\r\u0004bBAY5\u0001\u0007\u0011Q\r\u0005\b\u0007KR\u0002\u0019\u0001B\u0010\u0003\u0011iW\r^1\u0002)I,Wn\u001c<f)&lWm\\;uK\u00124\u0015\u000e\\3t\u0003I1\u0017N\u001c3US6,w.\u001e;fI\u001aKG.Z:\u0015\t\r54Q\u0010\t\u0007\u0007_\u001aI(!\u001a\u000f\t\rE4Q\u000f\b\u0005\u0003W\u001a\u0019(\u0003\u0002\u00024%!1qOA\u0019\u0003\u001d\u0001\u0018mY6bO\u0016LAAa9\u0004|)!1qOA\u0019\u0011\u001d\u0019y\b\ba\u0001\u0005k\naAY8sI\u0016\u0014\u0018!\u00037jgR4\u0015\u000e\\3t)\t\u0019i'\u0001\u0006eK2,G/\u001a$jY\u0016$Ba!#\u0004\fB1\u0011\u0011QAB\u0003;Cq!!-\u001f\u0001\u0004\t)'\u0001\beK2,G/\u001a$jY\u0016LU\u000e\u001d7\u0015\t\u0005u5\u0011\u0013\u0005\b\u0003c{\u0002\u0019AA3\u0003E\u0019X\u000f]3sI\u0005\\7.\u0019*v]RLW.Z\u000b\u0002Y\"\u001a\u0001a!'\u0011\u0007q\u001cY*C\u0002\u0004\u001ev\u0014\u0011bU5oO2,Go\u001c8")
public class LocalFileRepository
extends ComponentBase
implements FileRepository {
    private final Path directory;
    private final Config subConfig;
    private final FiniteDuration cleanupInterval;
    private final FiniteDuration cleanupTimeout;
    private final Cancellable timeoutScheduler;

    public static Encoder<FileMetaData> metaDataFormat() {
        return LocalFileRepository$.MODULE$.metaDataFormat();
    }

    public static String MetaEnding() {
        return LocalFileRepository$.MODULE$.MetaEnding();
    }

    public static String DirectoryConfigKey() {
        return LocalFileRepository$.MODULE$.DirectoryConfigKey();
    }

    @Override
    public boolean requestFileGet$default$2() {
        return FileRepository.requestFileGet$default$2$(this);
    }

    private /* synthetic */ AkkaRuntime super$akkaRuntime() {
        return super.akkaRuntime();
    }

    public Path directory() {
        return this.directory;
    }

    public Config subConfig() {
        return this.subConfig;
    }

    public FiniteDuration cleanupInterval() {
        return this.cleanupInterval;
    }

    public FiniteDuration cleanupTimeout() {
        return this.cleanupTimeout;
    }

    private void ensureDirectory() {
        try {
            Files.createDirectories(this.directory(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create directory for local file repository. Check configuration.", (Throwable)e);
        }
    }

    public Cancellable timeoutScheduler() {
        return this.timeoutScheduler;
    }

    private String makeNewId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Future<FileRepository.FileStorageResult> requestFileStorage(String contentType, boolean temporary) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            FileMetaData meta = new FileMetaData(contentType, temporary, this.super$akkaRuntime().clock().instant());
            String id = this.makeNewId();
            this.saveMeta(id, meta);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Requested storage of new file {}", new Object[]{id});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new FileRepository.FileStorageResult(id, FileRepository$.MODULE$.makePath(id));
        }, this.executionContext());
    }

    @Override
    public Future<FileRepository.FileGetResult> requestFileGet(String id, boolean optimistic) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            None$ fileSize;
            FileMetaData fileMeta = this.loadMeta(id);
            File file = this.fileName(id).toFile();
            boolean fileExits = file.isFile();
            Object object = fileSize = fileExits ? Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> file.length()).toOption() : None$.MODULE$;
            if (!optimistic && !fileExits) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("File {} is not existing and request is not optimistic", new Object[]{id});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(24).append("File ").append(id).append(" is not yet written").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            return new FileRepository.FileGetResult(id, fileMeta.temporary(), FileRepository$.MODULE$.makePath(id), fileMeta.contentType(), (Option<Object>)fileSize);
        }, this.executionContext());
    }

    @Override
    public Future<Sink<ByteString, Future<Object>>> storeFile(String id) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.loadMeta(id), this.executionContext()).map((Function1 & Serializable & scala.Serializable)meta -> {
            Path part = this.partFileName(id);
            Path file = this.fileName(id);
            Sink sink = FileIO$.MODULE$.toPath(part, FileIO$.MODULE$.toPath$default$2());
            return new Tuple4(meta, (Object)part, (Object)file, (Object)sink);
        }, this.executionContext()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Path part = (Path)tuple4._2();
            Path file = (Path)tuple4._3();
            Sink sink = (Sink)tuple4._4();
            Sink sink2 = sink.mapMaterializedValue((Function1 & Serializable & scala.Serializable)writeResult -> writeResult.map((Function1 & Serializable & scala.Serializable)ioResult -> BoxesRunTime.boxToLong((long)LocalFileRepository.$anonfun$storeFile$5(this, part, file, ioResult)), this.executionContext()));
            return sink2;
        }, this.executionContext());
    }

    @Override
    public Future<FileRepository.LoadFileResult> loadFile(String id) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path name = this.fileName(id);
            FileMetaData meta = this.loadMeta(id);
            boolean exists = Files.isRegularFile(name, new LinkOption[0]);
            long fileSize = name.toFile().length();
            if (!exists) {
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(19).append("File ").append(id).append(" doesn't exist").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            Source source = FileIO$.MODULE$.fromPath(name, FileIO$.MODULE$.fromPath$default$2()).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$2 -> NotUsed$.MODULE$);
            String x$1 = meta.contentType();
            long x$22 = fileSize;
            Source x$3 = source;
            return new FileRepository.LoadFileResult(x$22, x$1, (Source<ByteString, NotUsed>)x$3);
        }, this.executionContext());
    }

    @Override
    public Future<BoxedUnit> copy(String from, String to) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path fromName = this.fileName(from);
            Path toName = this.fileName(to);
            FileMetaData fromMeta = this.loadMeta(from);
            FileMetaData toMeta = this.loadMeta(to);
            boolean exists = Files.isRegularFile(fromName, new LinkOption[0]);
            if (!exists) {
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(19).append("File ").append(from).append(" doesn't exist").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            String string = fromMeta.contentType();
            String string2 = toMeta.contentType();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw FileRepository$.MODULE$.InvalidContentType().throwIt(new StringBuilder(31).append("Content Type from=").append(fromMeta.contentType()).append(" to=").append(toMeta.contentType()).append(" mismatch").toString(), FileRepository$.MODULE$.InvalidContentType().throwIt$default$2());
            }
            Files.copy(fromName, toName, new CopyOption[0]);
            FileMetaData newMeta = toMeta.copy(fromMeta.contentType(), toMeta.copy$default$2(), toMeta.copy$default$3());
            this.saveMeta(to, newMeta);
        }, this.executionContext());
    }

    private Path fileName(String id) {
        return this.resolve(id, "");
    }

    private Path metaFileName(String id) {
        return this.resolve(id, LocalFileRepository$.MODULE$.MetaEnding());
    }

    private Path partFileName(String id) {
        return this.resolve(id, ".part");
    }

    private Path resolve(String id, String ending) {
        Predef$.MODULE$.require(!id.contains("/") && !id.contains("."), (Function0 & Serializable & scala.Serializable)() -> "Ids may not contain / or .");
        Predef$.MODULE$.require(ending.isEmpty() || ending.startsWith("."));
        Predef$.MODULE$.require(!ending.contains("/"));
        Predef$.MODULE$.require(!ending.contains("\\"));
        return this.directory().resolve(new StringBuilder(0).append(id).append(ending).toString());
    }

    private FileMetaData loadMeta(String id) {
        FileMetaData ok;
        String string;
        try {
            string = FileUtils.readFileToString((File)this.metaFileName(id).toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("File {} not found when loading meta data", new Object[]{id});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(23).append("File with id ").append(id).append(" not found").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
        }
        String metaJson = string;
        Either either = package$.MODULE$.parse(metaJson).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.as((Decoder)LocalFileRepository$.MODULE$.metaDataFormat()));
        if (either instanceof Left) {
            Left left = (Left)either;
            Error error = (Error)left.value();
            throw new RuntimeException("Could not parse Metadata", (Throwable)error);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        FileMetaData fileMetaData = ok = (FileMetaData)right.value();
        FileMetaData parsed = fileMetaData;
        return parsed;
    }

    private void saveMeta(String id, FileMetaData meta) {
        Path metaFile = this.metaFileName(id);
        FileUtils.write((File)metaFile.toFile(), (CharSequence)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)meta), LocalFileRepository$.MODULE$.metaDataFormat()).spaces2(), (Charset)StandardCharsets.UTF_8);
    }

    public void removeTimeoutedFiles() {
        BoxedUnit boxedUnit;
        Instant border = super.akkaRuntime().clock().instant().minus(this.cleanupTimeout().toSeconds(), ChronoUnit.SECONDS);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking for timeouted files, border: {}", new Object[]{border});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.findTimeoutedFiles(border).foreach((Function1 & Serializable & scala.Serializable)timeoutedFileId -> BoxesRunTime.boxToBoolean((boolean)this.deleteFileImpl(timeoutedFileId)));
    }

    private Iterator<String> findTimeoutedFiles(Instant border) {
        return this.listFiles().filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LocalFileRepository.$anonfun$findTimeoutedFiles$1(this, border, id)));
    }

    public Iterator<String> listFiles() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(this.directory()).iterator()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (((Object)A1.getFileName()).toString().endsWith(LocalFileRepository$.MODULE$.MetaEnding())) {
                    String id = new StringOps(Predef$.MODULE$.augmentString(((Object)A1.getFileName()).toString())).stripSuffix(LocalFileRepository$.MODULE$.MetaEnding());
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = ((Object)path.getFileName()).toString().endsWith(LocalFileRepository$.MODULE$.MetaEnding());
                return bl;
            }
        });
    }

    @Override
    public Future<Object> deleteFile(String id) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.deleteFileImpl(id), this.executionContext());
    }

    /*
     * WARNING - void declaration
     */
    private boolean deleteFileImpl(String id) {
        boolean bl;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Deleting {}...", new Object[]{id});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            void var2_2;
            boolean exists = Files.deleteIfExists(this.fileName(id));
            Files.deleteIfExists(this.partFileName(id));
            Files.deleteIfExists(this.metaFileName(id));
            bl = var2_2;
        }
        catch (Exception e) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error on deleting file", (Throwable)e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ long $anonfun$storeFile$5(LocalFileRepository $this, Path part$1, Path file$2, IOResult ioResult) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Written {} bytes to {}, moving to {}", new Object[]{BoxesRunTime.boxToLong((long)ioResult.count()), part$1, file$2});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Files.move(part$1, file$2, StandardCopyOption.ATOMIC_MOVE);
        return ioResult.count();
    }

    public static final /* synthetic */ boolean $anonfun$findTimeoutedFiles$1(LocalFileRepository $this, Instant border$1, String id) {
        boolean bl;
        block5: {
            try {
                FileMetaData meta = $this.loadMeta(id);
                if (meta.temporary() && meta.requestTime().isBefore(border$1)) {
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("Could not analyze meta", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
        }
        return bl;
    }

    public LocalFileRepository(Path directory, AkkaRuntime akkaRuntime) {
        BoxedUnit boxedUnit;
        this.directory = directory;
        super(akkaRuntime);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Initializing Local File Repository in directory {}", new Object[]{directory});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.subConfig = this.config().getConfig("mantik.repository.fileRepository");
        this.cleanupInterval = Duration$.MODULE$.fromNanos(this.subConfig().getDuration("local.cleanupInterval").toNanos());
        this.cleanupTimeout = Duration$.MODULE$.fromNanos(this.subConfig().getDuration("local.cleanupTimeout").toNanos());
        this.ensureDirectory();
        this.timeoutScheduler = this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), this.cleanupInterval(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTimeoutedFiles(), this.executionContext());
        this.addShutdownHook((Function0 & Serializable & scala.Serializable)() -> {
            this.timeoutScheduler().cancel();
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        });
    }

    @Inject
    public LocalFileRepository(AkkaRuntime akkaRuntime) {
        this(new File(akkaRuntime.config().getString(LocalFileRepository$.MODULE$.DirectoryConfigKey())).toPath(), akkaRuntime);
    }

    public static class FileMetaData
    implements Product,
    scala.Serializable {
        private final String contentType;
        private final boolean temporary;
        private final Instant requestTime;

        public String contentType() {
            return this.contentType;
        }

        public boolean temporary() {
            return this.temporary;
        }

        public Instant requestTime() {
            return this.requestTime;
        }

        public FileMetaData copy(String contentType, boolean temporary, Instant requestTime) {
            return new FileMetaData(contentType, temporary, requestTime);
        }

        public String copy$default$1() {
            return this.contentType();
        }

        public boolean copy$default$2() {
            return this.temporary();
        }

        public Instant copy$default$3() {
            return this.requestTime();
        }

        public String productPrefix() {
            return "FileMetaData";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.contentType();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.temporary());
                    break;
                }
                case 2: {
                    object = this.requestTime();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileMetaData;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.contentType()));
            n = Statics.mix((int)n, (int)(this.temporary() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.requestTime()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileMetaData)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileMetaData fileMetaData = (FileMetaData)x$1;
            String string = this.contentType();
            String string2 = fileMetaData.contentType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.temporary() != fileMetaData.temporary()) return false;
            Instant instant = this.requestTime();
            Instant instant2 = fileMetaData.requestTime();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            if (!fileMetaData.canEqual(this)) return false;
            return true;
        }

        public FileMetaData(String contentType, boolean temporary, Instant requestTime) {
            this.contentType = contentType;
            this.temporary = temporary;
            this.requestTime = requestTime;
            Product.$init$((Product)this);
        }
    }
}

