/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.repository.rpc;

import ai.mantik.elements.ItemId;
import ai.mantik.elements.ItemId$;
import ai.mantik.elements.MantikId;
import ai.mantik.elements.MantikId$;
import ai.mantik.elements.NamedMantikId;
import ai.mantik.elements.NamedMantikId$;
import ai.mantik.elements.errors.ErrorCodes$;
import ai.mantik.elements.errors.MantikException;
import ai.mantik.elements.errors.MantikRemoteException$;
import akka.util.ByteString;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.jawn.JawnParser;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class Conversions$ {
    public static Conversions$ MODULE$;
    private final PartialFunction<Throwable, Throwable> encodeErrors;
    private final PartialFunction<Throwable, Throwable> decodeErrors;
    private final JawnParser jawnParser;

    static {
        new Conversions$();
    }

    public String encodeMantikId(MantikId mantikId) {
        return mantikId.toString();
    }

    public MantikId decodeMantikId(String str) {
        return MantikId$.MODULE$.fromString(str);
    }

    public String encodeNamedMantikId(NamedMantikId namedMantikId) {
        return namedMantikId.toString();
    }

    public NamedMantikId decodeNamedMantikId(String str) {
        return NamedMantikId$.MODULE$.fromString(str);
    }

    public String encodeItemId(ItemId itemId) {
        return itemId.toString();
    }

    public ItemId decodeItemId(String str) {
        return ItemId$.MODULE$.fromString(str);
    }

    public PartialFunction<Throwable, Throwable> encodeErrors() {
        return this.encodeErrors;
    }

    public Throwable encodeErrorIfPossible(Throwable e) {
        return this.encodeErrors().isDefinedAt((Object)e) ? (Throwable)this.encodeErrors().apply((Object)e) : e;
    }

    public <T> Future<T> encodeErrorsIn(Function0<Future<T>> f, ExecutionContext ec) {
        return ((Future)f.apply()).recover((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (Conversions$.MODULE$.encodeErrors().isDefinedAt(A1)) {
                    throw (Throwable)Conversions$.MODULE$.encodeErrors().apply(A1);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = Conversions$.MODULE$.encodeErrors().isDefinedAt((Object)throwable);
                return bl;
            }
        }, ec);
    }

    public PartialFunction<Throwable, Throwable> decodeErrors() {
        return this.decodeErrors;
    }

    public <T> Future<T> decodeErrorsIn(Function0<Future<T>> f, ExecutionContext ec) {
        return ((Future)f.apply()).recover((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (Conversions$.MODULE$.decodeErrors().isDefinedAt(A1)) {
                    throw (Throwable)Conversions$.MODULE$.decodeErrors().apply(A1);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = Conversions$.MODULE$.decodeErrors().isDefinedAt((Object)throwable);
                return bl;
            }
        }, ec);
    }

    private JawnParser jawnParser() {
        return this.jawnParser;
    }

    public <T> T decodeJsonItem(String json, Function1<String, String> msg, Decoder<T> evidence$1) {
        Object ok;
        Either maybeItem = this.jawnParser().decode(json, evidence$1);
        Either either = maybeItem;
        if (either instanceof Left) {
            Left left = (Left)either;
            Error error = (Error)left.value();
            throw ErrorCodes$.MODULE$.ProtocolError().throwIt((String)msg.apply(Option$.MODULE$.apply((Object)error.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")), ErrorCodes$.MODULE$.ProtocolError().throwIt$default$2());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = ok = right.value();
        return (T)object;
    }

    public <T> T decodeLargeJsonItem(ByteString json, Function1<String, String> msg, Decoder<T> evidence$2) {
        Object ok;
        Either either = this.jawnParser().decodeByteBuffer(json.asByteBuffer(), evidence$2);
        if (either instanceof Left) {
            Left left = (Left)either;
            Error error = (Error)left.value();
            Option firstBytes = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)new StringOps(Predef$.MODULE$.augmentString(json.decodeString(StandardCharsets.UTF_8))).take(100)).toOption();
            String message = new StringBuilder(14).append((String)msg.apply(Option$.MODULE$.apply((Object)error.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown"))).append(" first bytes: ").append(firstBytes).toString();
            throw ErrorCodes$.MODULE$.ProtocolError().throwIt(message, ErrorCodes$.MODULE$.ProtocolError().throwIt$default$2());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = ok = right.value();
        return (T)object;
    }

    private Conversions$() {
        MODULE$ = this;
        this.encodeErrors = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof MantikException) {
                    MantikException mantikException = (MantikException)A1;
                    object = mantikException.toGrpc();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof MantikException;
                return bl;
            }
        };
        this.decodeErrors = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof StatusRuntimeException) {
                    StatusRuntimeException statusRuntimeException = (StatusRuntimeException)A1;
                    object = MantikRemoteException$.MODULE$.fromGrpc(statusRuntimeException);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof StatusRuntimeException;
                return bl;
            }
        };
        this.jawnParser = new JawnParser();
    }
}

