/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.impl;

import ai.mantik.bridge.scalafn.ScalaFnDefinition;
import ai.mantik.ds.sql.MultiQuery;
import ai.mantik.ds.sql.Query;
import ai.mantik.ds.sql.Select;
import ai.mantik.ds.sql.SingleQuery;
import ai.mantik.elements.ItemId;
import ai.mantik.elements.MantikId;
import ai.mantik.planner.Algorithm;
import ai.mantik.planner.ApplicableMantikItem;
import ai.mantik.planner.DataSet;
import ai.mantik.planner.Operation;
import ai.mantik.planner.PayloadSource;
import ai.mantik.planner.PayloadSource$Empty$;
import ai.mantik.planner.Pipeline;
import ai.mantik.planner.PlanFile;
import ai.mantik.planner.PlanFileReference;
import ai.mantik.planner.PlanOp;
import ai.mantik.planner.PlanOp$;
import ai.mantik.planner.PlanOp$Empty$;
import ai.mantik.planner.Planner;
import ai.mantik.planner.TrainableAlgorithm;
import ai.mantik.planner.graph.NodePort;
import ai.mantik.planner.graph.NodePortRef;
import ai.mantik.planner.impl.FilesPlan;
import ai.mantik.planner.impl.FilesPlan$;
import ai.mantik.planner.impl.MantikItemStateManager;
import ai.mantik.planner.impl.PlanFileWithContentType;
import ai.mantik.planner.impl.PlannerElements;
import ai.mantik.planner.impl.PlanningState;
import ai.mantik.planner.impl.PlanningState$;
import ai.mantik.planner.impl.ResourcePlan;
import ai.mantik.planner.impl.ResourcePlan$;
import ai.mantik.planner.pipelines.ResolvedPipelineStep;
import ai.mantik.planner.repository.Bridge$;
import ai.mantik.planner.repository.ContentTypes$;
import cats.Applicative;
import cats.Eval;
import cats.Eval$;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.data.IndexedStateT;
import cats.data.IndexedStateT$;
import cats.implicits$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h!B\f\u0019\u0001a\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u00115\u0002!\u0011!Q\u0001\n9BQ!\r\u0001\u0005\u0002IBQA\u000e\u0001\u0005\u0002]BQA\u0016\u0001\u0005\u0002]CQA\u0019\u0001\u0005\n\rDQA\u001c\u0001\u0005\n=DQ!\u001d\u0001\u0005\nIDQ\u0001\u001e\u0001\u0005\nUDq!a\t\u0001\t\u0013\t)\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003C\u0004A\u0011AAr\u0005M\u0011Vm]8ve\u000e,\u0007\u000b\\1o\u0005VLG\u000eZ3s\u0015\tI\"$\u0001\u0003j[Bd'BA\u000e\u001d\u0003\u001d\u0001H.\u00198oKJT!!\b\u0010\u0002\r5\fg\u000e^5l\u0015\u0005y\u0012AA1j'\t\u0001\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\tK2,W.\u001a8ug\u000e\u0001\u0001C\u0001\u0016,\u001b\u0005A\u0012B\u0001\u0017\u0019\u0005=\u0001F.\u00198oKJ,E.Z7f]R\u001c\u0018AF7b]RL7.\u0013;f[N#\u0018\r^3NC:\fw-\u001a:\u0011\u0005)z\u0013B\u0001\u0019\u0019\u0005Yi\u0015M\u001c;jW&#X-\\*uCR,W*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00024iU\u0002\"A\u000b\u0001\t\u000b\u001d\u001a\u0001\u0019A\u0015\t\u000b5\u001a\u0001\u0019\u0001\u0018\u00025Q\u0014\u0018M\\:mCR,\u0017\n^3n!\u0006LHn\\1e'>,(oY3\u0015\u0005a\u0002\u0006\u0003B\u001dH\u00156s!A\u000f#\u000f\u0005m\neB\u0001\u001f@\u001b\u0005i$B\u0001 )\u0003\u0019a$o\\8u}%\t\u0001)\u0001\u0003dCR\u001c\u0018B\u0001\"D\u0003\u0011!\u0017\r^1\u000b\u0003\u0001K!!\u0012$\u0002\u000fA\f7m[1hK*\u0011!iQ\u0005\u0003\u0011&\u0013Qa\u0015;bi\u0016T!!\u0012$\u0011\u0005)Z\u0015B\u0001'\u0019\u00055\u0001F.\u00198oS:<7\u000b^1uKB\u0011!FT\u0005\u0003\u001fb\u0011ABU3t_V\u00148-\u001a)mC:DQ!\u0015\u0003A\u0002I\u000baa]8ve\u000e,\u0007CA*U\u001b\u0005Q\u0012BA+\u001b\u00055\u0001\u0016-\u001f7pC\u0012\u001cv.\u001e:dK\u0006\tCO]1og2\fG/Z%uK6\u0004\u0016-\u001f7pC\u0012\u001cv.\u001e:dK\u0006\u001bh)\u001b7fgR\u0019\u0001\fX/\u0011\te:%*\u0017\t\u0003UiK!a\u0017\r\u0003\u0013\u0019KG.Z:QY\u0006t\u0007\"B)\u0006\u0001\u0004\u0011\u0006\"\u00020\u0006\u0001\u0004y\u0016AD2b]\n+G+Z7q_J\f'/\u001f\t\u0003E\u0001L!!Y\u0012\u0003\u000f\t{w\u000e\\3b]\u0006\t2-Y2iK\u0012\u001cv.\u001e:dK\u001aKG.Z:\u0015\u0007a#W\u000eC\u0003f\r\u0001\u0007a-\u0001\u0007dC\u000eDW\rZ*pkJ\u001cW\r\u0005\u0002hU:\u00111\u000b[\u0005\u0003Sj\tQ\u0002U1zY>\fGmU8ve\u000e,\u0017BA6m\u0005\u0019\u0019\u0015m\u00195fI*\u0011\u0011N\u0007\u0005\u0006=\u001a\u0001\raX\u0001\u0016G\u0006\u001c\u0007.\u001a3UK6\u0004xN]1ssN{WO]2f)\tA\u0006\u000fC\u0003f\u000f\u0001\u0007a-\u0001\fsK\u00164\u0018\r\\;bi\u0016\u001c\u0015m\u00195fIN{WO]2f)\tA6\u000fC\u0003f\u0011\u0001\u0007a-\u0001\u0006dC\u000eDWm\u0015;bi\u0016$2A^A\n!\r\u0011s/_\u0005\u0003q\u000e\u0012aa\u00149uS>t\u0007\u0003\u0002>\u007f\u0003\u0007q!a_?\u000f\u0005qb\u0018\"\u0001\u0013\n\u0005\u0015\u001b\u0013bA@\u0002\u0002\t1a+Z2u_JT!!R\u0012\u0011\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tI\u0001\u0005\u0002=G%\u0019\u00111B\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tYa\t\u0005\b\u0003+I\u0001\u0019AA\f\u0003!\u0019\u0018N\u00197j]\u001e\u001c\b\u0003\u0002>\u007f\u00033\u0001B!a\u0007\u0002 5\u0011\u0011Q\u0004\u0006\u0003OqIA!!\t\u0002\u001e\t1\u0011\n^3n\u0013\u0012\f\u0001CZ5mK\u000e{g\u000e^3oiRK\b/Z:\u0015\t\u0005\u001d\u0012q\u0006\t\u0006s\u001dS\u0015\u0011\u0006\t\u0006u\u0006-\u00121A\u0005\u0005\u0003[\t\tA\u0001\u0006J]\u0012,\u00070\u001a3TKFDa!!\r\u000b\u0001\u0004\u0011\u0016!\u00049bs2|\u0017\rZ*pkJ\u001cW-\u0001\u000bnCJ\\g)\u001b7f\u0003N\u001c\u0015m\u00195fI\u001aKG.\u001a\u000b\u0007\u0003o\ty$a\u0013\u0011\u000be:%*!\u000f\u0011\u0007\t\nY$C\u0002\u0002>\r\u0012A!\u00168ji\"9\u0011\u0011I\u0006A\u0002\u0005\r\u0013!\u00024jY\u0016\u001c\b#\u0002>\u0002,\u0005\u0015\u0003cA*\u0002H%\u0019\u0011\u0011\n\u000e\u0003#Ac\u0017M\u001c$jY\u0016\u0014VMZ3sK:\u001cW\rC\u0004\u0002N-\u0001\r!a\u0006\u0002\u000b%$X-\\:\u0002'I,7o\\;sG\u0016\u0004F.\u00198U_\u001aKG.Z:\u0015\u000ba\u000b\u0019&a\u0016\t\r\u0005UC\u00021\u0001N\u00031\u0011Xm]8ve\u000e,\u0007\u000b\\1o\u0011\u0015qF\u00021\u0001`\u0003]1\u0017\u000e\\3t!2\fg\u000eV8SKN|WO]2f!2\fg\u000eF\u00029\u0003;Ba!a\u0018\u000e\u0001\u0004I\u0016!\u00034jY\u0016\u001c\b\u000b\\1o\u0003a!(/\u00198tY\u0006$Xm\u00149fe\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u000b\u0004q\u0005\u0015\u0004bBA4\u001d\u0001\u0007\u0011\u0011N\u0001\u0003_B\u00042aUA6\u0013\r\tiG\u0007\u0002\n\u001fB,'/\u0019;j_:\f!#\\1oS\u001a,7\u000f^!qa2L7-\u00192mKR\u0019\u0001(a\u001d\t\u000f\u0005Ut\u00021\u0001\u0002x\u0005!\u0012\r\u001d9mS\u000e\f'\r\\3NC:$\u0018n[%uK6\u00042aUA=\u0013\r\tYH\u0007\u0002\u0015\u0003B\u0004H.[2bE2,W*\u00198uS.LE/Z7\u0002#5\fg.\u001b4fgR\fEnZ8sSRDW\u000eF\u00029\u0003\u0003Cq!a!\u0011\u0001\u0004\t))A\u0005bY\u001e|'/\u001b;i[B\u00191+a\"\n\u0007\u0005%%DA\u0005BY\u001e|'/\u001b;i[\u0006\u0001R.\u00198jM\u0016\u001cH\u000fU5qK2Lg.\u001a\u000b\u0004q\u0005=\u0005bBAI#\u0001\u0007\u00111S\u0001\ta&\u0004X\r\\5oKB\u00191+!&\n\u0007\u0005]%D\u0001\u0005QSB,G.\u001b8f\u0003Qi\u0017M\\5gKN$\b+\u001b9fY&tWm\u0015;faR\u0019\u0001(!(\t\u000f\u0005}%\u00031\u0001\u0002\"\u0006!\"/Z:pYZ,G\rU5qK2Lg.Z*uKB\u0004B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003OS\u0012!\u00039ja\u0016d\u0017N\\3t\u0013\u0011\tY+!*\u0003)I+7o\u001c7wK\u0012\u0004\u0016\u000e]3mS:,7\u000b^3q\u00035i\u0017M\\5gKN$\u0018+^3ssR\u0019\u0001(!-\t\u000f\u0005M6\u00031\u0001\u00026\u0006)\u0011/^3ssB!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016aA:rY*\u0019\u0011q\u0018\u000f\u0002\u0005\u0011\u001c\u0018\u0002BAb\u0003s\u0013!\"T;mi&\fV/\u001a:z\u0003ii\u0017M\\5gKN$HK]1j]\u0006\u0014G.Z!mO>\u0014\u0018\u000e\u001e5n)\rA\u0014\u0011\u001a\u0005\b\u0003\u0017$\u0002\u0019AAg\u0003I!(/Y5oC\ndW-\u00117h_JLG\u000f[7\u0011\u0007M\u000by-C\u0002\u0002Rj\u0011!\u0003\u0016:bS:\f'\r\\3BY\u001e|'/\u001b;i[\u0006yQ.\u00198jM\u0016\u001cH\u000fR1uCN+G\u000fF\u00029\u0003/Dq!!7\u0016\u0001\u0004\tY.A\u0004eCR\f7+\u001a;\u0011\u0007M\u000bi.C\u0002\u0002`j\u0011q\u0001R1uCN+G/A\u000bnC:Lg-Z:u\t\u0006$\u0018mU3u\u0003N4\u0015\u000e\\3\u0015\u000ba\u000b)/a:\t\u000f\u0005eg\u00031\u0001\u0002\\\")aL\u0006a\u0001?\u0002")
public class ResourcePlanBuilder {
    private final PlannerElements elements;
    private final MantikItemStateManager mantikItemStateManager;

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> translateItemPayloadSource(PayloadSource source) {
        IndexedStateT indexedStateT;
        PayloadSource payloadSource = source;
        if (PayloadSource$Empty$.MODULE$.equals(payloadSource)) {
            throw new Planner.NotAvailableException("Empty Source");
        }
        if (payloadSource instanceof PayloadSource.Loaded) {
            PayloadSource.Loaded loaded = (PayloadSource.Loaded)payloadSource;
            indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)x$1 -> x$1.readFile(loaded.fileId(), loaded.contentType())).flatMap((Function1 & Serializable)file -> $this.elements.loadFileNode(new PlanFileWithContentType(file.ref(), loaded.contentType())), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (payloadSource instanceof PayloadSource.Literal) {
            PayloadSource.Literal literal = (PayloadSource.Literal)payloadSource;
            indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)x$2 -> x$2.pipeFile(ContentTypes$.MODULE$.MantikBundleContentType(), true)).flatMap((Function1 & Serializable)fileReference -> $this.elements.loadFileNode(new PlanFileWithContentType(fileReference.ref(), ContentTypes$.MODULE$.MantikBundleContentType())).map((Function1 & Serializable)loader -> {
                PlanOp<BoxedUnit> pusher = $this.elements.literalToPushBundle(literal, (PlanFile)fileReference);
                return loader.prependOp(pusher);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (payloadSource instanceof PayloadSource.OperationResult) {
            PayloadSource.OperationResult operationResult = (PayloadSource.OperationResult)payloadSource;
            indexedStateT = this.translateOperationResult(operationResult.op());
        } else if (payloadSource instanceof PayloadSource.Projection) {
            PayloadSource.Projection projection = (PayloadSource.Projection)payloadSource;
            indexedStateT = this.translateItemPayloadSource(projection.source()).map((Function1 & Serializable)x$3 -> x$3.projectOutput(projection.projection()), (Functor)Eval$.MODULE$.catsBimonadForEval());
        } else if (payloadSource instanceof PayloadSource.Cached) {
            PayloadSource.Cached cached = (PayloadSource.Cached)payloadSource;
            indexedStateT = this.cachedSourceFiles(cached, true).flatMap((Function1 & Serializable)filesPlan -> this.filesPlanToResourcePlan((FilesPlan)filesPlan).map((Function1 & Serializable)loader -> loader, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else {
            throw new MatchError((Object)payloadSource);
        }
        return indexedStateT;
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> translateItemPayloadSourceAsFiles(PayloadSource source, boolean canBeTemporary) {
        IndexedStateT indexedStateT;
        PayloadSource payloadSource = source;
        if (PayloadSource$Empty$.MODULE$.equals(payloadSource)) {
            indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s), (Object)new FilesPlan(FilesPlan$.MODULE$.apply$default$1(), FilesPlan$.MODULE$.apply$default$2())));
        } else if (payloadSource instanceof PayloadSource.Loaded) {
            PayloadSource.Loaded loaded = (PayloadSource.Loaded)payloadSource;
            String fileId = loaded.fileId();
            String contentType = loaded.contentType();
            indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)x$4 -> x$4.readFile(fileId, contentType)).map((Function1 & Serializable)fileGet -> {
                IndexedSeq x$1 = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PlanFileWithContentType[]{new PlanFileWithContentType(fileGet.ref(), contentType)}));
                PlanOp<BoxedUnit> x$2 = FilesPlan$.MODULE$.apply$default$1();
                return new FilesPlan(x$2, (IndexedSeq<PlanFileWithContentType>)x$1);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval());
        } else if (payloadSource instanceof PayloadSource.Literal) {
            PayloadSource.Literal literal = (PayloadSource.Literal)payloadSource;
            indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)x$5 -> x$5.pipeFile(ContentTypes$.MODULE$.MantikBundleContentType(), canBeTemporary)).map((Function1 & Serializable)reference -> {
                PlanOp<BoxedUnit> pushing = $this.elements.literalToPushBundle(literal, (PlanFile)reference);
                return new FilesPlan(pushing, (IndexedSeq<PlanFileWithContentType>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PlanFileWithContentType[]{new PlanFileWithContentType(reference.ref(), ContentTypes$.MODULE$.MantikBundleContentType())}))));
            }, (Functor)Eval$.MODULE$.catsBimonadForEval());
        } else if (payloadSource instanceof PayloadSource.Cached) {
            PayloadSource.Cached cached = (PayloadSource.Cached)payloadSource;
            indexedStateT = this.cachedSourceFiles(cached, canBeTemporary);
        } else if (payloadSource instanceof PayloadSource.Projection) {
            PayloadSource.Projection projection = (PayloadSource.Projection)payloadSource;
            indexedStateT = this.translateItemPayloadSourceAsFiles(projection.source(), canBeTemporary).map((Function1 & Serializable)filesPlan -> {
                IndexedSeq x$3 = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PlanFileWithContentType[]{(PlanFileWithContentType)filesPlan.files().apply(projection.projection())}));
                PlanOp<BoxedUnit> x$4 = filesPlan.copy$default$1();
                return filesPlan.copy(x$4, (IndexedSeq<PlanFileWithContentType>)x$3);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval());
        } else {
            indexedStateT = this.translateItemPayloadSource(payloadSource).flatMap((Function1 & Serializable)operationResult -> this.resourcePlanToFiles((ResourcePlan)operationResult, canBeTemporary), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        }
        return indexedStateT;
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> cachedSourceFiles(PayloadSource.Cached cachedSource, boolean canBeTemporary) {
        return canBeTemporary ? this.cachedTemporarySource(cachedSource) : this.cachedTemporarySource(cachedSource).flatMap((Function1 & Serializable)filesPlan -> ((IndexedStateT)implicits$.MODULE$.toTraverseOps((Object)((IterableOnceOps)filesPlan.files().map((Function1 & Serializable)planFile -> PlanningState$.MODULE$.apply((Function1 & Serializable)x$6 -> x$6.pipeFile(planFile.contentType(), false)))).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)nonTemporaries -> {
            IndexedSeq copyOperations = (IndexedSeq)((IndexedSeqOps)filesPlan.files().zip((IterableOnce)nonTemporaries)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PlanFileWithContentType temporaryFile = (PlanFileWithContentType)tuple2._1();
                PlanFile nontemporaryFile = (PlanFile)tuple2._2();
                PlanOp.CopyFile copyFile = new PlanOp.CopyFile(temporaryFile.ref(), nontemporaryFile.ref());
                return copyFile;
            });
            IndexedSeq newFiles = (IndexedSeq)((IndexedSeqOps)filesPlan.files().zip((IterableOnce)nonTemporaries)).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PlanFileWithContentType temporaryFile = (PlanFileWithContentType)tuple2._1();
                PlanFile nonTemporaryFile = (PlanFile)tuple2._2();
                PlanFileWithContentType planFileWithContentType = new PlanFileWithContentType(nonTemporaryFile.ref(), temporaryFile.contentType());
                return planFileWithContentType;
            });
            return new Tuple3(nonTemporaries, (Object)copyOperations, (Object)newFiles);
        }, (Functor)Eval$.MODULE$.catsBimonadForEval()).map((Function1 & Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            IndexedSeq copyOperations = (IndexedSeq)tuple3._2();
            IndexedSeq newFiles = (IndexedSeq)tuple3._3();
            FilesPlan filesPlan = new FilesPlan(PlanOp$.MODULE$.combine(filesPlan.preOp(), new PlanOp.Sequential<BoxedUnit>((Seq<PlanOp<?>>)copyOperations, PlanOp$Empty$.MODULE$)), (IndexedSeq<PlanFileWithContentType>)newFiles);
            return filesPlan;
        }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> cachedTemporarySource(PayloadSource.Cached cachedSource) {
        return PlanningState$.MODULE$.flat((Function1 & Serializable)planningState -> {
            IndexedStateT indexedStateT;
            Option<IndexedSeq<PlanFileWithContentType>> option = planningState.evaluatedCache(cachedSource.siblings());
            if (option instanceof Some) {
                Some some = (Some)option;
                IndexedSeq files = (IndexedSeq)some.value();
                indexedStateT = PlanningState$.MODULE$.pure((Function0 & Serializable)() -> {
                    IndexedSeq x$1 = files;
                    PlanOp<BoxedUnit> x$2 = FilesPlan$.MODULE$.apply$default$1();
                    return new FilesPlan(x$2, (IndexedSeq<PlanFileWithContentType>)x$1);
                });
            } else if (None$.MODULE$.equals(option)) {
                indexedStateT = this.reevaluateCachedSource(cachedSource).flatMap((Function1 & Serializable)filesPlan -> PlanningState$.MODULE$.modify((Function1<PlanningState, PlanningState>)(Function1 & Serializable)x$8 -> x$8.withEvaluatedCache(cachedSource.siblings(), filesPlan.files())).map((Function1 & Serializable)x$9 -> {
                    BoxedUnit boxedUnit = x$9;
                    FilesPlan filesPlan = filesPlan;
                    return filesPlan;
                }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
            } else {
                throw new MatchError(option);
            }
            return indexedStateT;
        });
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> reevaluateCachedSource(PayloadSource.Cached cachedSource) {
        IndexedStateT indexedStateT;
        Option<Vector<String>> option = this.cacheState(cachedSource.siblings());
        if (option instanceof Some) {
            Some some = (Some)option;
            Vector files = (Vector)some.value();
            indexedStateT = this.fileContentTypes(cachedSource.source()).flatMap((Function1 & Serializable)contentTypes -> ((IndexedStateT)implicits$.MODULE$.toTraverseOps(((StrictOptimizedIterableOps)files.zip((IterableOnce)contentTypes)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fileId = (String)tuple2._1();
                String contentType = (String)tuple2._2();
                IndexedStateT indexedStateT = PlanningState$.MODULE$.apply((Function1 & Serializable)x$10 -> x$10.readFile(fileId, contentType)).map((Function1 & Serializable)planFile -> new PlanFileWithContentType(planFile.ref(), contentType), (Functor)Eval$.MODULE$.catsBimonadForEval());
                return indexedStateT;
            }), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)fileReads -> {
                Vector x$1 = fileReads;
                PlanOp<BoxedUnit> x$2 = FilesPlan$.MODULE$.apply$default$1();
                return new FilesPlan(x$2, (IndexedSeq<PlanFileWithContentType>)x$1);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (None$.MODULE$.equals(option)) {
            indexedStateT = this.translateItemPayloadSourceAsFiles(cachedSource.source(), true).flatMap((Function1 & Serializable)opFiles -> this.markFileAsCachedFile(opFiles.fileRefs(), cachedSource.siblings()).map((Function1 & Serializable)x$11 -> {
                BoxedUnit boxedUnit = x$11;
                Vector cacheFiles = (Vector)cachedSource.siblings().zip(opFiles.fileRefs());
                FilesPlan filesPlan = new FilesPlan(PlanOp$.MODULE$.combine(opFiles.preOp(), new PlanOp.MarkCached((Vector<Tuple2<ItemId, PlanFileReference>>)cacheFiles)), opFiles.files());
                return filesPlan;
            }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else {
            throw new MatchError(option);
        }
        return indexedStateT;
    }

    private Option<Vector<String>> cacheState(Vector<ItemId> siblings) {
        Vector cacheFiles = (Vector)siblings.flatMap((Function1 & Serializable)itemId -> $this.mantikItemStateManager.get((ItemId)itemId).flatMap((Function1 & Serializable)state -> state.cacheFile().map((Function1 & Serializable)cacheFile -> cacheFile)));
        return cacheFiles.size() == siblings.size() ? new Some((Object)cacheFiles) : None$.MODULE$;
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, IndexedSeq<String>> fileContentTypes(PayloadSource payloadSource) {
        return this.translateItemPayloadSourceAsFiles(payloadSource, true).flatMap((Function1 & Serializable)filesPlan -> {
            IndexedSeq contentTypes = (IndexedSeq)filesPlan.files().map((Function1 & Serializable)x$12 -> x$12.contentType());
            return PlanningState$.MODULE$.pure((Function0 & Serializable)() -> contentTypes);
        }, (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, BoxedUnit> markFileAsCachedFile(IndexedSeq<PlanFileReference> files, Vector<ItemId> items) {
        Map toCached = ((IterableOnceOps)files.zip(items)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return PlanningState$.MODULE$.apply((Function1 & Serializable)state -> {
            PlanningState updatedState = state.markCached((Map<PlanFileReference, ItemId>)toCached);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)updatedState), (Object)BoxedUnit.UNIT);
        });
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> resourcePlanToFiles(ResourcePlan resourcePlan, boolean canBeTemporary) {
        return ((IndexedStateT)implicits$.MODULE$.toTraverseOps((Object)resourcePlan.outputs().toList().map((Function1 & Serializable)output -> {
            NodePort outputResource = resourcePlan.outputResource((NodePortRef)output);
            return PlanningState$.MODULE$.apply((Function1 & Serializable)x$13 -> x$13.pipeFile(outputResource.contentType(), canBeTemporary)).flatMap((Function1 & Serializable)file -> $this.elements.createStoreFileNode((PlanFile)file, outputResource.contentType()).map((Function1 & Serializable)fileNode -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fileNode), (Object)new PlanFileWithContentType(file.ref(), outputResource.contentType())), (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        }), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)fileNodeWithFile -> {
            ResourcePlan consumers = (ResourcePlan)fileNodeWithFile.foldLeft((Object)new ResourcePlan(ResourcePlan$.MODULE$.apply$default$1(), ResourcePlan$.MODULE$.apply$default$2(), ResourcePlan$.MODULE$.apply$default$3(), ResourcePlan$.MODULE$.apply$default$4()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                ResourcePlan p;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        p = (ResourcePlan)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                ResourcePlan storeFile = (ResourcePlan)tuple2._1();
                ResourcePlan resourcePlan = p.merge(storeFile);
                return resourcePlan;
            });
            ResourcePlan combinedResourcePlan = consumers.application(resourcePlan);
            PlanOp<BoxedUnit> preOp = $this.elements.sourcePlanToJob(combinedResourcePlan);
            FilesPlan filesPlan = new FilesPlan(preOp, (IndexedSeq<PlanFileWithContentType>)fileNodeWithFile.map((Function1 & Serializable)x$14 -> (PlanFileWithContentType)x$14._2()).toIndexedSeq());
            return filesPlan;
        }, (Functor)Eval$.MODULE$.catsBimonadForEval());
    }

    private IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> filesPlanToResourcePlan(FilesPlan filesPlan) {
        return ((IndexedStateT)implicits$.MODULE$.toTraverseOps((Object)filesPlan.files().toList().map((Function1 & Serializable)file -> $this.elements.loadFileNode((PlanFileWithContentType)file)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)fileLoaders -> {
            void var2_2;
            ResourcePlan fullPlan = ((ResourcePlan)fileLoaders.foldLeft((Object)new ResourcePlan(ResourcePlan$.MODULE$.apply$default$1(), ResourcePlan$.MODULE$.apply$default$2(), ResourcePlan$.MODULE$.apply$default$3(), ResourcePlan$.MODULE$.apply$default$4()), (Function2 & Serializable)(x$15, x$16) -> x$15.merge((ResourcePlan)x$16))).prependOp(filesPlan.preOp());
            return var2_2;
        }, (Functor)Eval$.MODULE$.catsBimonadForEval());
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> translateOperationResult(Operation op) {
        IndexedStateT indexedStateT;
        Operation operation = op;
        if (operation instanceof Operation.Application) {
            Operation.Application application = (Operation.Application)operation;
            ApplicableMantikItem algorithm = application.algorithm();
            DataSet argument = application.argument();
            indexedStateT = this.manifestDataSet(argument).flatMap((Function1 & Serializable)argumentSource -> this.manifestApplicable(algorithm).map((Function1 & Serializable)algorithmSource -> algorithmSource.application((ResourcePlan)argumentSource), (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (operation instanceof Operation.Training) {
            Operation.Training training = (Operation.Training)operation;
            TrainableAlgorithm trainable = training.algorithm();
            DataSet learningData = training.trainingData();
            indexedStateT = this.manifestDataSet(learningData).flatMap((Function1 & Serializable)argumentSource -> this.manifestTrainableAlgorithm(trainable).map((Function1 & Serializable)algorithmSource -> algorithmSource.application((ResourcePlan)argumentSource), (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (operation instanceof Operation.SqlQueryOperation) {
            Operation.SqlQueryOperation sqlQueryOperation = (Operation.SqlQueryOperation)operation;
            MultiQuery query = sqlQueryOperation.query();
            Vector<DataSet> arguments = sqlQueryOperation.arguments();
            indexedStateT = ((IndexedStateT)implicits$.MODULE$.toTraverseOps(arguments.map((Function1 & Serializable)dataSet -> this.manifestDataSet((DataSet)dataSet)), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).flatMap((Function1 & Serializable)argumentSource -> this.manifestQuery(query).map((Function1 & Serializable)selectSource -> {
                ResourcePlan mergedArguments = (ResourcePlan)argumentSource.reduceLeft((Function2 & Serializable)(x$17, x$18) -> x$17.merge((ResourcePlan)x$18));
                return selectSource.application(mergedArguments);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else if (operation instanceof Operation.ScalaFnOperation) {
            Operation.ScalaFnOperation scalaFnOperation = (Operation.ScalaFnOperation)operation;
            ScalaFnDefinition definition = scalaFnOperation.definition();
            Vector<DataSet> arguments = scalaFnOperation.arguments();
            indexedStateT = ((IndexedStateT)implicits$.MODULE$.toTraverseOps(arguments.map((Function1 & Serializable)dataSet -> this.manifestDataSet((DataSet)dataSet)), implicits$.MODULE$.catsStdInstancesForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).flatMap((Function1 & Serializable)argumentSource -> $this.elements.scalaFn(definition).map((Function1 & Serializable)scalaFnSource -> {
                ResourcePlan merged = (ResourcePlan)argumentSource.reduce((Function2 & Serializable)(x$19, x$20) -> x$19.merge((ResourcePlan)x$20));
                return scalaFnSource.application(merged);
            }, (Functor)Eval$.MODULE$.catsBimonadForEval()), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
        } else {
            throw new MatchError((Object)operation);
        }
        return indexedStateT;
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestApplicable(ApplicableMantikItem applicableMantikItem) {
        IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> indexedStateT;
        ApplicableMantikItem applicableMantikItem2 = applicableMantikItem;
        if (applicableMantikItem2 instanceof Algorithm) {
            Algorithm algorithm = (Algorithm)applicableMantikItem2;
            indexedStateT = this.manifestAlgorithm(algorithm);
        } else if (applicableMantikItem2 instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)applicableMantikItem2;
            indexedStateT = this.manifestPipeline(pipeline);
        } else {
            throw new Planner.InconsistencyException(new StringBuilder(24).append("Unknown applicable type ").append(applicableMantikItem2.getClass()).toString());
        }
        return indexedStateT;
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestAlgorithm(Algorithm algorithm) {
        return this.translateItemPayloadSourceAsFiles(algorithm.payloadSource(), true).flatMap((Function1 & Serializable)files -> {
            Option algorithmFile = files.fileRefs().headOption();
            return $this.elements.algorithm(algorithm, (Option<PlanFileReference>)algorithmFile).map((Function1 & Serializable)x$21 -> x$21.prependOp(files.preOp()), (Functor)Eval$.MODULE$.catsBimonadForEval());
        }, (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestPipeline(Pipeline pipeline) {
        List<ResolvedPipelineStep> steps = pipeline.resolved().steps();
        Predef$.MODULE$.require(steps.nonEmpty(), (Function0 & Serializable)() -> "Pipelines may not be empty");
        return ((IndexedStateT)implicits$.MODULE$.toTraverseOps((Object)steps.map((Function1 & Serializable)step -> this.manifestPipelineStep((ResolvedPipelineStep)step)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IndexedStateT$.MODULE$.catsDataMonadForIndexedStateT((Monad)Eval$.MODULE$.catsBimonadForEval()))).map((Function1 & Serializable)plans -> {
            void var1_1;
            ResourcePlan resultPlan = (ResourcePlan)plans.reduce((Function2 & Serializable)(c, n) -> n.application((ResourcePlan)c));
            return var1_1;
        }, (Functor)Eval$.MODULE$.catsBimonadForEval());
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestPipelineStep(ResolvedPipelineStep resolvedPipelineStep) {
        IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> indexedStateT;
        ResolvedPipelineStep resolvedPipelineStep2 = resolvedPipelineStep;
        if (resolvedPipelineStep2 instanceof ResolvedPipelineStep.AlgorithmStep) {
            ResolvedPipelineStep.AlgorithmStep algorithmStep = (ResolvedPipelineStep.AlgorithmStep)resolvedPipelineStep2;
            Algorithm algorithm = algorithmStep.algorithm();
            indexedStateT = this.manifestAlgorithm(algorithm);
        } else if (resolvedPipelineStep2 instanceof ResolvedPipelineStep.SelectStep) {
            ResolvedPipelineStep.SelectStep selectStep = (ResolvedPipelineStep.SelectStep)resolvedPipelineStep2;
            Select select = selectStep.select();
            indexedStateT = this.manifestQuery((MultiQuery)new SingleQuery((Query)select));
        } else {
            throw new MatchError((Object)resolvedPipelineStep2);
        }
        return indexedStateT;
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestQuery(MultiQuery query) {
        return this.elements.query(query);
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestTrainableAlgorithm(TrainableAlgorithm trainableAlgorithm) {
        return this.translateItemPayloadSourceAsFiles(trainableAlgorithm.payloadSource(), true).flatMap((Function1 & Serializable)files -> {
            Option algorithmFile = files.fileRefs().headOption();
            return $this.elements.trainableAlgorithm(trainableAlgorithm, (Option<PlanFileReference>)algorithmFile).map((Function1 & Serializable)x$22 -> x$22.prependOp(files.preOp()), (Functor)Eval$.MODULE$.catsBimonadForEval());
        }, (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, ResourcePlan> manifestDataSet(DataSet dataSet) {
        MantikId mantikId = dataSet.bridgeMantikId();
        MantikId mantikId2 = Bridge$.MODULE$.naturalBridge().mantikId();
        return !(mantikId != null ? !mantikId.equals(mantikId2) : mantikId2 != null) ? this.translateItemPayloadSource(dataSet.payloadSource()) : this.translateItemPayloadSourceAsFiles(dataSet.payloadSource(), true).flatMap((Function1 & Serializable)files -> {
            Option dataSetFile = files.fileRefs().headOption();
            return $this.elements.dataSet(dataSet, (Option<PlanFileReference>)dataSetFile).map((Function1 & Serializable)x$23 -> x$23.prependOp(files.preOp()), (Functor)Eval$.MODULE$.catsBimonadForEval());
        }, (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    public IndexedStateT<Eval, PlanningState, PlanningState, FilesPlan> manifestDataSetAsFile(DataSet dataSet, boolean canBeTemporary) {
        MantikId mantikId = dataSet.bridgeMantikId();
        MantikId mantikId2 = Bridge$.MODULE$.naturalBridge().mantikId();
        return !(mantikId != null ? !mantikId.equals(mantikId2) : mantikId2 != null) ? this.translateItemPayloadSourceAsFiles(dataSet.payloadSource(), canBeTemporary) : this.manifestDataSet(dataSet).flatMap((Function1 & Serializable)resourcePlan -> this.resourcePlanToFiles((ResourcePlan)resourcePlan, canBeTemporary), (FlatMap)Eval$.MODULE$.catsBimonadForEval());
    }

    public ResourcePlanBuilder(PlannerElements elements, MantikItemStateManager mantikItemStateManager) {
        this.elements = elements;
        this.mantikItemStateManager = mantikItemStateManager;
    }
}

