/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.impl.exec;

import ai.mantik.componently.utils.FutureHelper$;
import ai.mantik.ds.element.Bundle;
import ai.mantik.ds.element.Bundle$;
import ai.mantik.elements.ItemId;
import ai.mantik.elements.MantikDefinition;
import ai.mantik.elements.MantikHeader;
import ai.mantik.elements.MantikId;
import ai.mantik.elements.NamedMantikId;
import ai.mantik.planner.DeploymentState;
import ai.mantik.planner.MantikItem;
import ai.mantik.planner.MantikItemState;
import ai.mantik.planner.PlanFileReference;
import ai.mantik.planner.PlanOp;
import ai.mantik.planner.PlanOp$Empty$;
import ai.mantik.planner.Planner;
import ai.mantik.planner.impl.MantikItemStateManager;
import ai.mantik.planner.impl.exec.ExecutionOpenFiles;
import ai.mantik.planner.impl.exec.Memory;
import ai.mantik.planner.repository.FileRepository;
import ai.mantik.planner.repository.MantikArtifact;
import ai.mantik.planner.repository.MantikArtifact$;
import ai.mantik.planner.repository.MantikArtifactRetriever;
import ai.mantik.planner.repository.Repository;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005}4Aa\u0003\u0007\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003&\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\fIB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006Y!\u000f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019A\u0006\u0001)A\u0005\u001d\")\u0011\f\u0001C\u00015\ny!)Y:jG>\u0003X\t_3dkR|'O\u0003\u0002\u000e\u001d\u0005!Q\r_3d\u0015\ty\u0001#\u0001\u0003j[Bd'BA\t\u0013\u0003\u001d\u0001H.\u00198oKJT!a\u0005\u000b\u0002\r5\fg\u000e^5l\u0015\u0005)\u0012AA1j\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u000391\u0017\u000e\\3SKB|7/\u001b;pef\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002%C\tqa)\u001b7f%\u0016\u0004xn]5u_JL\bC\u0001\u0011'\u0013\t9\u0013E\u0001\u0006SKB|7/\u001b;pef\f\u0011#\u0019:uS\u001a\f7\r\u001e*fiJLWM^3s!\t\u0001#&\u0003\u0002,C\t9R*\u00198uS.\f%\u000f^5gC\u000e$(+\u001a;sS\u00164XM]\u0001\u0017[\u0006tG/[6Ji\u0016l7\u000b^1uK6\u000bg.Y4feB\u0011afL\u0007\u0002\u001d%\u0011\u0001G\u0004\u0002\u0017\u001b\u0006tG/[6Ji\u0016l7\u000b^1uK6\u000bg.Y4fe\u0006\u0011Qm\u0019\t\u0003gYj\u0011\u0001\u000e\u0006\u0003ki\t!bY8oGV\u0014(/\u001a8u\u0013\t9DG\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Q.\u0019;\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AB:ue\u0016\fWNC\u0001?\u0003\u0011\t7n[1\n\u0005\u0001[$\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003D\u0011&S5\nF\u0002E\r\u001e\u0003\"!\u0012\u0001\u000e\u00031AQ!M\u0004A\u0004IBQ\u0001O\u0004A\u0004eBQAH\u0004A\u0002}AQAI\u0004A\u0002\u0015BQ\u0001K\u0004A\u0002%BQ\u0001L\u0004A\u00025\na\u0001\\8hO\u0016\u0014X#\u0001(\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016\u0001D:dC2\fGn\\4hS:<'BA*U\u0003!!\u0018\u0010]3tC\u001a,'\"A+\u0002\u0007\r|W.\u0003\u0002X!\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0004fq\u0016\u001cW\u000f^3\u0016\u0005m\u0013GC\u0001/v)\ri6\u000e\u001d\t\u0004gy\u0003\u0017BA05\u0005\u00191U\u000f^;sKB\u0011\u0011M\u0019\u0007\u0001\t\u0015\u0019'B1\u0001e\u0005\u0005!\u0016CA3i!\tIb-\u0003\u0002h5\t9aj\u001c;iS:<\u0007CA\rj\u0013\tQ'DA\u0002B]fDQ\u0001\u001c\u0006A\u00045\fQAZ5mKN\u0004\"!\u00128\n\u0005=d!AE#yK\u000e,H/[8o\u001fB,gNR5mKNDQ!\u001d\u0006A\u0004I\fa!\\3n_JL\bCA#t\u0013\t!HB\u0001\u0004NK6|'/\u001f\u0005\u0006m*\u0001\ra^\u0001\u0007a2\fgn\u00149\u0011\u0007ad\bM\u0004\u0002zu6\t\u0001#\u0003\u0002|!\u00051\u0001\u000b\\1o\u001fBL!! @\u0003\u000f\t\u000b7/[2Pa*\u00111\u0010\u0005")
public class BasicOpExecutor {
    private final FileRepository fileRepository;
    private final Repository repository;
    private final MantikArtifactRetriever artifactRetriever;
    public final MantikItemStateManager ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public <T> Future<T> execute(PlanOp.BasicOp<T> planOp, ExecutionOpenFiles files, Memory memory) {
        Future future;
        PlanOp.BasicOp<T> basicOp = planOp;
        if (PlanOp$Empty$.MODULE$.equals(basicOp)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Executing empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (basicOp instanceof PlanOp.StoreBundleToFile) {
            PlanOp.StoreBundleToFile storeBundleToFile = (PlanOp.StoreBundleToFile)basicOp;
            Bundle bundle = storeBundleToFile.bundle();
            int fileRef = storeBundleToFile.fileReference();
            String fileId = files.resolveFileId(fileRef);
            future = FutureHelper$.MODULE$.time(this.logger(), new StringBuilder(12).append("Bundle Push ").append(fileId).toString(), (Function0 & Serializable)() -> $this.fileRepository.storeFile(fileId).flatMap((Function1 & Serializable)sink -> {
                Source source = bundle.encode(true);
                return ((Future)source.runWith((Graph)sink, $this.mat)).map((Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> {}, $this.ec);
            }, $this.ec), this.ec);
        } else if (basicOp instanceof PlanOp.LoadBundleFromFile) {
            PlanOp.LoadBundleFromFile loadBundleFromFile = (PlanOp.LoadBundleFromFile)basicOp;
            int fileRef = loadBundleFromFile.fileReference();
            String fileId = files.resolveFileId(fileRef);
            future = FutureHelper$.MODULE$.time(this.logger(), new StringBuilder(12).append("Bundle Pull ").append(fileId).toString(), (Function0 & Serializable)() -> $this.fileRepository.loadFile(fileId).flatMap((Function1 & Serializable)result -> {
                Sink sink = Bundle$.MODULE$.fromStreamWithHeader($this.ec);
                return (Future)result.source().runWith((Graph)sink, $this.mat);
            }, $this.ec), this.ec);
        } else if (basicOp instanceof PlanOp.AddMantikItem) {
            PlanOp.AddMantikItem addMantikItem = (PlanOp.AddMantikItem)basicOp;
            MantikItem item = addMantikItem.item();
            Option<PlanFileReference> fileReference2 = addMantikItem.file();
            Option fileId = fileReference2.map((Function1 & Serializable)fileReference -> files.resolveFileId(((PlanFileReference)fileReference).id()));
            MantikHeader<MantikDefinition> mantikHeader = item.mantikHeader();
            ItemId id = item.itemId();
            MantikItemState state = this.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager.getOrInit(item);
            Option<NamedMantikId> namedId = state.namedMantikItem();
            MantikArtifact artifact = new MantikArtifact(mantikHeader.toJson(), (Option<String>)fileId, namedId, item.itemId(), MantikArtifact$.MODULE$.apply$default$5(), MantikArtifact$.MODULE$.apply$default$6());
            future = FutureHelper$.MODULE$.time(this.logger(), new StringBuilder(19).append("Adding Mantik Item ").append(id).toString(), (Function0 & Serializable)() -> $this.repository.store(artifact).andThen((PartialFunction)new Serializable(this, id, namedId, fileId){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ BasicOpExecutor $outer;
                private final ItemId id$1;
                private final Option namedId$1;
                private final Option fileId$3;

                public final <A1 extends Try<BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Option<MantikItemState> option = A1 instanceof Success ? this.$outer.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager.update(this.id$1, (Function1<MantikItemState, MantikItemState>)(Function1 & Serializable)x$2 -> {
                        boolean x$1 = true;
                        boolean x$22 = $this.namedId$1.isDefined();
                        Option x$3 = $this.namedId$1;
                        Option x$4 = $this.fileId$3;
                        Option<DeploymentState> x$5 = x$2.copy$default$5();
                        Option<String> x$6 = x$2.copy$default$6();
                        return x$2.copy((Option<NamedMantikId>)x$3, true, x$22, (Option<String>)x$4, x$5, x$6);
                    }) : function1.apply(x1);
                    return (B1)option;
                }

                public final boolean isDefinedAt(Try<BoxedUnit> x1) {
                    Try<BoxedUnit> try_ = x1;
                    boolean bl = try_ instanceof Success;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.id$1 = id$1;
                    this.namedId$1 = namedId$1;
                    this.fileId$3 = fileId$3;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(ai.mantik.planner.impl.exec.BasicOpExecutor$$anonfun$$nestedInanonfun$execute$7$1 ai.mantik.planner.MantikItemState )}, serializedLambda);
                }
            }, $this.ec), this.ec);
        } else if (basicOp instanceof PlanOp.TagMantikItem) {
            PlanOp.TagMantikItem tagMantikItem = (PlanOp.TagMantikItem)basicOp;
            MantikItem item = tagMantikItem.item();
            NamedMantikId id = tagMantikItem.id();
            future = FutureHelper$.MODULE$.time(this.logger(), "Tagging Mantik Item", (Function0 & Serializable)() -> $this.repository.ensureMantikId(item.itemId(), id).andThen((PartialFunction)new Serializable(this, item, id){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ BasicOpExecutor $outer;
                private final MantikItem item$1;
                private final NamedMantikId id$2;

                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Option<MantikItemState> option = A1 instanceof Success ? this.$outer.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager.update(this.item$1.itemId(), (Function1<MantikItemState, MantikItemState>)(Function1 & Serializable)x$3 -> x$3.copy((Option<NamedMantikId>)new Some((Object)$this.id$2), x$3.copy$default$2(), x$3.copy$default$3(), x$3.copy$default$4(), x$3.copy$default$5(), x$3.copy$default$6())) : function1.apply(x2);
                    return (B1)option;
                }

                public final boolean isDefinedAt(Try<Object> x2) {
                    Try<Object> try_ = x2;
                    boolean bl = try_ instanceof Success;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.item$1 = item$1;
                    this.id$2 = id$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(ai.mantik.planner.impl.exec.BasicOpExecutor$$anonfun$$nestedInanonfun$execute$8$1 ai.mantik.planner.MantikItemState )}, serializedLambda);
                }
            }, $this.ec).map((Function1 & Serializable)x$4 -> {
                BasicOpExecutor.$anonfun$execute$9(BoxesRunTime.unboxToBoolean((Object)x$4));
                return BoxedUnit.UNIT;
            }, $this.ec), this.ec);
        } else if (basicOp instanceof PlanOp.PushMantikItem) {
            PlanOp.PushMantikItem pushMantikItem = (PlanOp.PushMantikItem)basicOp;
            MantikItem item = pushMantikItem.item();
            MantikItemState state = this.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager.getOrInit(item);
            if (!state.itemStored()) {
                throw new Planner.InconsistencyException("Item is not stored");
            }
            MantikId mantikId = item.mantikId();
            future = FutureHelper$.MODULE$.time(this.logger(), new StringBuilder(17).append("Pushing Artifact ").append(mantikId).toString(), (Function0 & Serializable)() -> $this.artifactRetriever.push(mantikId, $this.artifactRetriever.push$default$2()), this.ec).map((Function1 & Serializable)x$5 -> {
                BasicOpExecutor.$anonfun$execute$11(x$5);
                return BoxedUnit.UNIT;
            }, this.ec);
        } else if (basicOp instanceof PlanOp.MarkCached) {
            PlanOp.MarkCached markCached = (PlanOp.MarkCached)basicOp;
            markCached.files().foreach((Function1 & Serializable)x0$1 -> {
                BasicOpExecutor.$anonfun$execute$12(this, files, x0$1);
                return BoxedUnit.UNIT;
            });
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (basicOp instanceof PlanOp.Const) {
            PlanOp.Const const_ = (PlanOp.Const)basicOp;
            future = Future$.MODULE$.successful(const_.value());
        } else if (basicOp instanceof PlanOp.CopyFile) {
            PlanOp.CopyFile copyFile = (PlanOp.CopyFile)basicOp;
            String fromId = files.resolveFileId(copyFile.from());
            String toId = files.resolveFileId(copyFile.to());
            future = FutureHelper$.MODULE$.time(this.logger(), "Copy file", (Function0 & Serializable)() -> $this.fileRepository.copy(fromId, toId), this.ec);
        } else if (basicOp instanceof PlanOp.MemoryReader) {
            PlanOp.MemoryReader memoryReader = (PlanOp.MemoryReader)basicOp;
            future = Future$.MODULE$.successful(memory.get(memoryReader.memoryId()));
        } else if (basicOp instanceof PlanOp.MemoryWriter) {
            PlanOp.MemoryWriter memoryWriter = (PlanOp.MemoryWriter)basicOp;
            Object last = memory.getLast();
            memory.put(memoryWriter.memoryId(), last);
            future = Future$.MODULE$.successful(last);
        } else if (basicOp instanceof PlanOp.UploadFile) {
            PlanOp.UploadFile uploadFile = (PlanOp.UploadFile)basicOp;
            String fileId = files.resolveFileId(uploadFile.fileReference());
            future = FutureHelper$.MODULE$.time(this.logger(), new StringBuilder(12).append("Upload File ").append(fileId).toString(), (Function0 & Serializable)() -> $this.fileRepository.storeFile(fileId).flatMap((Function1 & Serializable)sink -> {
                Source source = Source$.MODULE$.single((Object)uploadFile.data());
                return ((Future)source.runWith((Graph)sink, $this.mat)).map((Function1)(JFunction1.mcVJ.sp & Serializable)x$7 -> {}, $this.ec);
            }, $this.ec), this.ec);
        } else {
            throw new MatchError(basicOp);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$execute$9(boolean x$4) {
    }

    public static final /* synthetic */ void $anonfun$execute$11(Tuple2 x$5) {
    }

    public static final /* synthetic */ void $anonfun$execute$12(BasicOpExecutor $this, ExecutionOpenFiles files$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ItemId itemId = (ItemId)tuple2._1();
        int fileRef = ((PlanFileReference)tuple2._2()).id();
        String resolved = files$1.resolveFileId(fileRef);
        $this.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager.updateOrFresh(itemId, (Function1<MantikItemState, MantikItemState>)(Function1 & Serializable)x$6 -> {
            Some x$1 = new Some((Object)resolved);
            Option<NamedMantikId> x$2 = x$6.copy$default$1();
            boolean x$3 = x$6.copy$default$2();
            boolean x$4 = x$6.copy$default$3();
            Option<String> x$5 = x$6.copy$default$4();
            Option<DeploymentState> x$62 = x$6.copy$default$5();
            return x$6.copy(x$2, x$3, x$4, x$5, x$62, (Option<String>)x$1);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BasicOpExecutor(FileRepository fileRepository, Repository repository, MantikArtifactRetriever artifactRetriever, MantikItemStateManager mantikItemStateManager, ExecutionContext ec, Materializer mat) {
        this.fileRepository = fileRepository;
        this.repository = repository;
        this.artifactRetriever = artifactRetriever;
        this.ai$mantik$planner$impl$exec$BasicOpExecutor$$mantikItemStateManager = mantikItemStateManager;
        this.ec = ec;
        this.mat = mat;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }
}

