/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.pipelines;

import ai.mantik.ds.DataType;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.sql.Select;
import ai.mantik.elements.MantikDefinition;
import ai.mantik.elements.MantikHeader;
import ai.mantik.elements.MantikHeader$;
import ai.mantik.elements.MantikId;
import ai.mantik.elements.OptionalFunctionType;
import ai.mantik.elements.OptionalFunctionType$;
import ai.mantik.elements.PipelineDefinition;
import ai.mantik.elements.PipelineStep;
import ai.mantik.planner.Algorithm;
import ai.mantik.planner.DefinitionSource;
import ai.mantik.planner.MantikItem;
import ai.mantik.planner.Pipeline;
import ai.mantik.planner.pipelines.InvalidPipelineException;
import ai.mantik.planner.pipelines.InvalidPipelineException$;
import ai.mantik.planner.pipelines.PipelineException;
import ai.mantik.planner.pipelines.PipelineResolver$;
import ai.mantik.planner.pipelines.ResolvedPipeline;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PipelineBuilder$ {
    public static final PipelineBuilder$ MODULE$ = new PipelineBuilder$();

    public Pipeline buildOrFailFromMantikHeader(DefinitionSource source, MantikHeader<PipelineDefinition> mantikHeader, Map<MantikId, MantikItem> referenced) {
        ResolvedPipeline ok;
        Either<PipelineException, ResolvedPipeline> either = PipelineResolver$.MODULE$.resolvePipeline(mantikHeader, referenced);
        if (either instanceof Left) {
            Left left = (Left)either;
            PipelineException error = (PipelineException)left.value();
            throw error;
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        ResolvedPipeline resolvedPipeline = ok = (ResolvedPipeline)right.value();
        ResolvedPipeline resolved = resolvedPipeline;
        return new Pipeline(source, mantikHeader, resolved);
    }

    public Either<PipelineException, Pipeline> build(Seq<Either<Select, Algorithm>> steps) {
        Option inputType = steps.headOption().map((Function1 & Serializable)x0$1 -> {
            TabularData tabularData;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Select select = (Select)left.value();
                tabularData = select.inputTabularType();
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Algorithm algorithm = (Algorithm)right.value();
                tabularData = algorithm.functionType().input();
            } else {
                throw new MatchError((Object)either);
            }
            return tabularData;
        });
        Seq highLevelSteps = (Seq)steps.map((Function1 & Serializable)x0$2 -> {
            Product product;
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                Select select = (Select)left.value();
                product = new Pipeline.PipelineBuildStep.SelectBuildStep(select.toStatement());
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Algorithm algorithm = (Algorithm)right.value();
                product = new Pipeline.PipelineBuildStep.AlgorithmBuildStep(algorithm);
            } else {
                throw new MatchError((Object)either);
            }
            return product;
        });
        return this.build((Seq<Pipeline.PipelineBuildStep>)highLevelSteps, (Option<DataType>)inputType);
    }

    public Either<PipelineException, Pipeline> build(Seq<Pipeline.PipelineBuildStep> highLevelSteps, Option<DataType> definedInputType) {
        if (highLevelSteps.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)new InvalidPipelineException("Empty pipeline", InvalidPipelineException$.MODULE$.$lessinit$greater$default$2()));
        }
        Option inputType = definedInputType.orElse((Function0 & Serializable)() -> highLevelSteps.headOption().flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            Pipeline.PipelineBuildStep pipelineBuildStep = x0$1;
            if (pipelineBuildStep instanceof Pipeline.PipelineBuildStep.AlgorithmBuildStep) {
                Pipeline.PipelineBuildStep.AlgorithmBuildStep algorithmBuildStep = (Pipeline.PipelineBuildStep.AlgorithmBuildStep)pipelineBuildStep;
                Algorithm algorithm = algorithmBuildStep.algorithm();
                none$ = new Some((Object)algorithm.functionType().input());
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }));
        Seq steps = (Seq)highLevelSteps.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Pipeline.PipelineBuildStep pipelineBuildStep = x0$2;
            if (pipelineBuildStep instanceof Pipeline.PipelineBuildStep.AlgorithmBuildStep) {
                Pipeline.PipelineBuildStep.AlgorithmBuildStep algorithmBuildStep = (Pipeline.PipelineBuildStep.AlgorithmBuildStep)pipelineBuildStep;
                Algorithm algorithm = algorithmBuildStep.algorithm();
                MantikId id = algorithm.mantikId();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new PipelineStep.AlgorithmStep(id, PipelineStep.AlgorithmStep$.MODULE$.apply$default$2(), PipelineStep.AlgorithmStep$.MODULE$.apply$default$3())), (Object)new Some((Object)algorithm));
            } else if (pipelineBuildStep instanceof Pipeline.PipelineBuildStep.SelectBuildStep) {
                Pipeline.PipelineBuildStep.SelectBuildStep selectBuildStep = (Pipeline.PipelineBuildStep.SelectBuildStep)pipelineBuildStep;
                String statement = selectBuildStep.select();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new PipelineStep.SelectStep(statement, PipelineStep.SelectStep$.MODULE$.apply$default$2())), (Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)pipelineBuildStep);
            }
            return tuple2;
        });
        List x$12 = ((IterableOnceOps)steps.map((Function1 & Serializable)x$1 -> (PipelineStep)x$1._1())).toList();
        Some x$2 = new Some((Object)new OptionalFunctionType(inputType, OptionalFunctionType$.MODULE$.apply$default$2()));
        PipelineDefinition pipelineDefinition = new PipelineDefinition((Option)x$2, x$12);
        Map referenced = ((IterableOnceOps)steps.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<PipelineStep, Option<Algorithm>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    PipelineStep as = (PipelineStep)A1._1();
                    Option option = (Option)A1._2();
                    if (as instanceof PipelineStep.AlgorithmStep) {
                        PipelineStep.AlgorithmStep algorithmStep = (PipelineStep.AlgorithmStep)as;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Algorithm algorithm = (Algorithm)some.value();
                            object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)algorithmStep.algorithm()), (Object)algorithm);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<PipelineStep, Option<Algorithm>> x1) {
                Tuple2<PipelineStep, Option<Algorithm>> tuple2 = x1;
                if (tuple2 == null) return false;
                PipelineStep as = (PipelineStep)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(as instanceof PipelineStep.AlgorithmStep)) return false;
                if (!(option instanceof Some)) return false;
                return true;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        MantikHeader mantikHeader = MantikHeader$.MODULE$.pure((MantikDefinition)pipelineDefinition);
        return PipelineResolver$.MODULE$.resolvePipeline((MantikHeader<PipelineDefinition>)mantikHeader, (Map<MantikId, MantikItem>)referenced).map((Function1 & Serializable)resolved -> new Pipeline(new DefinitionSource.Constructed(), (MantikHeader<PipelineDefinition>)mantikHeader, (ResolvedPipeline)resolved));
    }

    public Option<DataType> build$default$2() {
        return None$.MODULE$;
    }

    private PipelineBuilder$() {
    }
}

