package ai.minxiao.ds4s.core.dl4j.cgnn

/**
  * Computation Graph Vertex Type
  *
  * @author mx
  */
object VType extends Enumeration {
  type VType = Value
  // LayerVertex
  //    Fully Connected
  val DenseLayer, OutputLayer = Value
  //    Recurrent
  val LSTM, GravesLSTM, GravesBidirectionalLSTM, RnnOutputLayer = Value
  //    Convolution
  val ConvolutionLayer, SubsamplingLayer = Value
  //    EmbeddingLayer
  val EmbeddingLayer = Value
  /** <a href="https://github.com/deeplearning4j/deeplearning4j/blob/master/deeplearning4j/deeplearning4j-nn/src/main/java/org/deeplearning4j/nn/conf/layers/EmbeddingSequenceLayer.java">
    * EmbeddingSequenceLayer</a>
    */
  val EmbeddingSequenceLayer = Value
  // Other Vertex
  /**
    * <a href="https://github.com/deeplearning4j/deeplearning4j/blob/master/deeplearning4j/deeplearning4j-nn/src/main/java/org/deeplearning4j/nn/graph/vertex/impl/MergeVertex.java">
    * MergeVertex</a>
    */
  val MergeVertex = Value
  val SubsetVertex = Value
  val ElementWiseVertex = Value
  val FrozenVertex = Value
  val L2NormalizeVertex = Value
  val L2Vertex = Value
  val PoolHelperVertex = Value
  val ReshapeVertex = Value
  val ScaleVertex = Value
  val ShiftVertex = Value
  val StackVertex, UnstackVertex = Value
  // RNN
  val DuplicateToTimeSeriesVertex, LastTimeStepVertex, ReverseTimeSeriesVertex = Value

}
