package ai.minxiao.ds4s.core.nlp.embeds

import breeze.linalg.{DenseVector, norm}

/**
  * Mappers based on embeddings
  * 
  * @author mx
  */
@SerialVersionUID(77112L)
class Mapper(private val embeds: Embeds, private val targets: Array[String])
    extends Serializable {

  lazy val targetEmbs: Array[(String, Option[DenseVector[Float]])] = targets
    .map(x => (x, embeds.sEmb(x)))
    .filter(_._2 != None)
  assume(!targetEmbs.isEmpty)

  def findTarget(s: String): Option[(String, Double)] = {
    embeds.sEmb(s) match {
      case None => None
      case sEmb =>
        Some(
          targetEmbs.map{ case (s, e) => (s, norm(e.get - sEmb.get, 2))}
          .minBy(_._2)
        )
    }
  }
}
