package ai.minxiao.ds4s.core.rapi.entities

/**
  * Model Entity: a model is defined as a function: Input => Output
  *
  * @note the application customizes the model by extending the base categories
  *
  * @author mx
  */

// general model
sealed trait Model extends Function[Input, Output]

// classification model
sealed trait ClassificationModel extends Model
trait OneClassModel extends ClassificationModel
trait BinaryClassModel extends ClassificationModel
trait MultiClassModel extends ClassificationModel

// regression model
trait RegressionModel extends Model

// clustering model
trait ClusteringModel extends Model

// dimension reduction model
trait DimensionReductionModel extends Model

// others
trait MiscModel extends Model
