package ai.minxiao.ds4s.core.rapi.main

import java.util.concurrent.TimeUnit
import scala.concurrent.duration._
/*----------------------------------------------------------------------------*/
import akka.actor._
import akka.event.Logging
import akka.http.scaladsl.Http
import akka.http.scaladsl.server.Route
import akka.stream.ActorMaterializer
import akka.util.Timeout
import com.typesafe.config.ConfigFactory
/*----------------------------------------------------------------------------*/
import ai.minxiao.ds4s.core.rapi.entities.{Input, Model, Output}
import ai.minxiao.ds4s.core.rapi.routing.RApiRoutes
import ai.minxiao.ds4s.core.rapi.services.RApiService

/**
  * Simple Rest API: Single Node Version
  * @constructor
  * @param model model
  * @param host host, default="localhost"
  * @param port port, default=5050
  * @param sysName system name, default="rest-api"
  *
  * @author mx
  */
class SimpleRApi(
  model: Model)(
  host: String = "localhost", port: Int = 5050, sysName: String = "rest-api")(
  implicit timeout: Timeout) extends RApiRoutes {

  implicit val system = ActorSystem(sysName)
  implicit val executionContext = system.dispatcher

  implicit val materializer = ActorMaterializer()

  val rapiService = new RApiService(model)

  val log = Logging(system.eventStream, sysName)

  Http().bindAndHandle(
    handler = rapiRoutes, interface = host, port = port
  ).map { binding =>
    log.info(s"${sysName} bound to ${binding.localAddress}")
  }.recover { case ex: Exception  =>
    log.error(ex, s"${sysName} could not bind to ${host}:${port}!")
    system.terminate()
  }
}
