package ai.minxiao.ds4s.core.rapi.routing

import akka.http.scaladsl.server.Route

import ai.minxiao.ds4s.core.rapi.entities.{Input, InputUpdate,
  Output, OutputUpdate}
import ai.minxiao.ds4s.core.rapi.resources.ResourceBase
import ai.minxiao.ds4s.core.rapi.services.RApiService

/**
  * Rest API Routes
  *
  * @author mx
  */
trait RApiRoutes extends ResourceBase {

  val rapiService: RApiService

  def rapiRoutes: Route =
    pathPrefix("inputs") {
      pathEnd {
        post {
          entity(as[Input]) { input =>
            completeWithLocationHeader(
              resourceId = rapiService.createInput(input),
              ifDefinedStatus = 201, ifEmptyStatus = 409)
          }
        }
      } ~
      path(Segment) { id =>
        get {
          complete(rapiService.getInput(id))
        } ~
        put {
          entity(as[InputUpdate]) { update =>
            complete(rapiService.updateInput(id, update))
          }
        } ~
        delete {
          complete(rapiService.deleteInput(id))
        }
      }
    } ~
    pathPrefix("outputs") {
      pathEnd {
        post {
          entity(as[Input]) { input =>
            completeWithLocationHeader(
              resourceId = rapiService.transformInput(input),
              ifDefinedStatus = 201, ifEmptyStatus = 409)
          }
        }
      } ~
      path(Segment) { id =>
        get {
          complete(rapiService.getOutput(id))
        } ~
        delete {
          complete(rapiService.deleteOutput(id))
        }
      }
    }
}
