package ai.minxiao.ds4s.core.rapi.services

import scala.concurrent.{ExecutionContext, Future}
/*----------------------------------------------------------------------------*/
import ai.minxiao.ds4s.core.rapi.entities.{Input, InputUpdate, Model,
  Output, OutputUpdate}
import ai.minxiao.ds4s.core.rapi.resources.ResourceBase

/**
  * Rest API Service:
  *
  * @author mx
  */
class RApiService(model: Model)(implicit val executionContext: ExecutionContext) extends ResourceBase {

  var inputs = Vector.empty[Input]
  var outputs = Vector.empty[Output]

  def createInput(input: Input): Future[Option[String]] = Future {
    inputs.find(_.id == input.id) match {
      case Some(q) => None // Conflict! id is already taken
      case None =>
        inputs = inputs :+ input
        Some(input.id)
    }
  }

  def getInput(id: String): Future[Option[Input]] = Future {
    inputs.find(_.id == id)
  }

  def updateInput(id: String, update: InputUpdate): Future[Option[Input]] = {
    def updateEntity(input: Input): Input = {
      val inputs = update.inputs.getOrElse(input.inputs)
      Input(id, inputs)
    }

    getInput(id).flatMap { maybeInput =>
      maybeInput match {
        case None => Future { None } // No input found, nothing to update
        case Some(input) =>
          val updatedInput = updateEntity(input)
          deleteInput(id).flatMap { _ =>
            createInput(updatedInput).map(_ => Some(updatedInput))
          }
      }
    }
  }

  def deleteInput(id: String): Future[Unit] = Future {
    inputs = inputs.filterNot(_.id == id)
  }

  def transformInput(input: Input): Future[Option[String]] = Future {
    inputs.find(_.id == input.id) match {
      case Some(q) => None // Conflict! id is already taken
      case None =>
        val output: Output = model(input)
        outputs = outputs :+ output
        Some(output.id)
    }
  }


  def getOutput(id: String): Future[Option[Output]] = Future {
    outputs.find(_.id == id)
  }

  def deleteOutput(id: String): Future[Unit] = Future {
    outputs = outputs.filterNot(_.id == id)
  }
}
