package ai.minxiao.ds4s.core.rapi.util

import scala.concurrent.duration._
/*---------------------------------------------------------------------------=*/
import akka.util.Timeout
import com.typesafe.config.Config

/**
  * RequestTimeout Trait
  *
  * @author mx
  */
object RequestTimeout {

  /**
    * @param t timeout-string, e.g., "10 seconds"
    */
  def getTimeout(t: String): Timeout = {
    val d = Duration(t)
    FiniteDuration(d.length, d.unit)
  }

  def getTimeout(config: Config): Timeout = {
    val t = config.getString("spray.can.server.request-timeout")
    getTimeout(t)
  }

}
