package com.mobid.android.http

class RemoteResult <T>(
    var data: T? = null,
    var remoteError: RemoteError? = null
)

fun <T> RemoteResult<T>.isSuccess():Boolean{
    return data != null
}

sealed class RemoteError(val message: String?) {

    class HttpNotFound (msg: String?) : RemoteError(msg)
    class HttpTimeout (msg: String?) : RemoteError(msg)
    class HttpUnauthorized (msg: String?) : RemoteError(msg)
    class HttpBadGetaway (msg: String?) : RemoteError(msg)
    class HttpForbidden (msg: String?) : RemoteError(msg)
    class HttpUnprocessableEntitiy (msg: String?) : RemoteError(msg)
    class Exception (msg: String?) : RemoteError(msg)
    class SslException (msg: String?) : RemoteError(msg)
    class JsonException (msg: String?) : RemoteError(msg)
    class MalformedUrlException (msg: String?) : RemoteError(msg)
    class UnsupportedEncodingException (msg: String?) : RemoteError(msg)
    class NetProtocolException (msg: String?) : RemoteError(msg)
    class NoInternetException (msg: String?) : RemoteError(msg)

}
